/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.linux;

import com.ibm.jusb.UsbConfigurationDescriptorImp;
import com.ibm.jusb.UsbConfigurationImp;
import com.ibm.jusb.UsbControlPipeImp;
import com.ibm.jusb.UsbDeviceDescriptorImp;
import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbEndpointDescriptorImp;
import com.ibm.jusb.UsbEndpointImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.UsbInterfaceDescriptorImp;
import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.UsbPipeImp;
import com.ibm.jusb.os.linux.LinuxControlPipeImp;
import com.ibm.jusb.os.linux.LinuxDeviceOsImp;
import com.ibm.jusb.os.linux.LinuxDeviceProxy;
import com.ibm.jusb.os.linux.LinuxInterfaceOsImp;
import com.ibm.jusb.os.linux.LinuxIsochronousPipeImp;
import com.ibm.jusb.os.linux.LinuxPipeOsImp;
import com.ibm.jusb.os.linux.LinuxUsbServices;
import java.util.Hashtable;
import java.util.List;
import javax.usb.UsbBabbleException;
import javax.usb.UsbBitStuffException;
import javax.usb.UsbCRCException;
import javax.usb.UsbConst;
import javax.usb.UsbException;
import javax.usb.UsbPlatformException;
import javax.usb.UsbShortPacketException;
import javax.usb.UsbStallException;

class JavaxUsb {
    private static Hashtable msgLevelTable = new Hashtable();
    public static final String LIBRARY_NAME = "JavaxUsb";
    public static final String ERROR_WHILE_LOADING_SHARED_LIBRARY = "Error while loading shared library";
    public static final String EXCEPTION_WHILE_LOADING_SHARED_LIBRARY = "Exception while loading shared library";
    private static final int SPEED_UNKNOWN = 0;
    private static final int SPEED_LOW = 1;
    private static final int SPEED_FULL = 2;

    JavaxUsb() {
    }

    public static void loadLibrary() throws UsbException {
        try {
            System.loadLibrary(LIBRARY_NAME);
        }
        catch (Exception e) {
            throw new UsbException("Exception while loading shared library " + System.mapLibraryName(LIBRARY_NAME) + " : " + e.getMessage());
        }
        catch (Error e) {
            throw new UsbException("Error while loading shared library " + System.mapLibraryName(LIBRARY_NAME) + " : " + e.getMessage());
        }
    }

    public static UsbException errorToUsbException(int error) {
        return JavaxUsb.errorToUsbException(error, "");
    }

    public static UsbException errorToUsbException(int error, String string) {
        error = Math.abs(error);
        if (0 < string.length()) {
            string = string + " : ";
        }
        switch (error) {
            case 32: {
                return new UsbStallException(string + "UsbStallException");
            }
            case 71: {
                return new UsbBitStuffException(string + "UsbBitStuffException");
            }
            case 75: {
                return new UsbBabbleException(string + "UsbBabbleException");
            }
            case 84: {
                return new UsbCRCException(string + "UsbCRCException");
            }
            case 121: {
                return new UsbShortPacketException(string + "UsbShortPacketException");
            }
        }
        return new UsbPlatformException(string + JavaxUsb.nativeGetErrorMessage(error));
    }

    static native void nativeSetTracing(boolean var0);

    static native void nativeSetTraceType(boolean var0, String var1);

    static native void nativeSetTraceLevel(int var0);

    static native void nativeSetTraceOutput(int var0, String var1);

    static native int nativeTopologyUpdater(LinuxUsbServices var0, List var1, List var2);

    static native int nativeGetActiveConfigurationNumber(LinuxDeviceOsImp var0);

    static native int nativeGetActiveInterfaceSettingNumber(LinuxDeviceOsImp var0, int var1);

    static native int nativeTopologyListener(LinuxUsbServices var0);

    static native void nativeDeviceProxy(LinuxDeviceProxy var0);

    private static native String nativeGetErrorMessage(int var0);

    private static UsbHubImp createUsbHubImp(String key, int maxPorts) {
        UsbHubImp hub = new UsbHubImp(maxPorts, null, null);
        LinuxDeviceOsImp linuxDeviceOsImp = new LinuxDeviceOsImp(hub, new LinuxDeviceProxy(key));
        hub.setUsbDeviceOsImp(linuxDeviceOsImp);
        return hub;
    }

    private static UsbDeviceImp createUsbDeviceImp(String key) {
        UsbDeviceImp device = new UsbDeviceImp(null, null);
        LinuxDeviceOsImp linuxDeviceOsImp = new LinuxDeviceOsImp(device, new LinuxDeviceProxy(key));
        device.setUsbDeviceOsImp(linuxDeviceOsImp);
        return device;
    }

    private static UsbConfigurationImp createUsbConfigurationImp(UsbDeviceImp device, byte length, byte type, short totalLen, byte numInterfaces, byte configValue, byte configIndex, byte attributes, byte maxPowerNeeded) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        numInterfaces = (byte)(numInterfaces + 0);
        configValue = (byte)(configValue + 0);
        configIndex = (byte)(configIndex + 0);
        attributes = (byte)(attributes + 0);
        maxPowerNeeded = (byte)(maxPowerNeeded + 0);
        UsbConfigurationDescriptorImp desc = new UsbConfigurationDescriptorImp(length, type, totalLen, numInterfaces, configValue, configIndex, attributes, maxPowerNeeded);
        UsbConfigurationImp config = new UsbConfigurationImp(device, desc);
        return config;
    }

    private static UsbInterfaceImp createUsbInterfaceImp(UsbConfigurationImp config, byte length, byte type, byte interfaceNumber, byte alternateNumber, byte numEndpoints, byte interfaceClass, byte interfaceSubClass, byte interfaceProtocol, byte interfaceIndex) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        interfaceNumber = (byte)(interfaceNumber + 0);
        alternateNumber = (byte)(alternateNumber + 0);
        numEndpoints = (byte)(numEndpoints + 0);
        interfaceClass = (byte)(interfaceClass + 0);
        interfaceSubClass = (byte)(interfaceSubClass + 0);
        interfaceProtocol = (byte)(interfaceProtocol + 0);
        interfaceIndex = (byte)(interfaceIndex + 0);
        UsbInterfaceDescriptorImp desc = new UsbInterfaceDescriptorImp(length, type, interfaceNumber, alternateNumber, numEndpoints, interfaceClass, interfaceSubClass, interfaceProtocol, interfaceIndex);
        UsbInterfaceImp iface = new UsbInterfaceImp(config, desc);
        LinuxDeviceOsImp linuxDeviceOsImp = (LinuxDeviceOsImp)iface.getUsbConfigurationImp().getUsbDeviceImp().getUsbDeviceOsImp();
        LinuxInterfaceOsImp linuxInterfaceOsImp = new LinuxInterfaceOsImp(iface, linuxDeviceOsImp);
        iface.setUsbInterfaceOsImp(linuxInterfaceOsImp);
        return iface;
    }

    private static UsbEndpointImp createUsbEndpointImp(UsbInterfaceImp iface, byte length, byte type, byte endpointAddress, byte attributes, byte interval, short maxPacketSize) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        endpointAddress = (byte)(endpointAddress + 0);
        attributes = (byte)(attributes + 0);
        interval = (byte)(interval + 0);
        maxPacketSize = (short)(maxPacketSize + 0);
        UsbEndpointDescriptorImp desc = new UsbEndpointDescriptorImp(length, type, endpointAddress, attributes, interval, maxPacketSize);
        UsbEndpointImp ep = new UsbEndpointImp(iface, desc);
        UsbPipeImp pipe = null;
        LinuxInterfaceOsImp linuxInterfaceOsImp = (LinuxInterfaceOsImp)iface.getUsbInterfaceOsImp();
        switch (ep.getType()) {
            case 0: {
                pipe = new UsbControlPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new LinuxControlPipeImp(pipe, linuxInterfaceOsImp));
                break;
            }
            case 2: {
                pipe = new UsbPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new LinuxPipeOsImp(pipe, linuxInterfaceOsImp));
                break;
            }
            case 3: {
                pipe = new UsbPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new LinuxPipeOsImp(pipe, linuxInterfaceOsImp));
                break;
            }
            case 1: {
                pipe = new UsbPipeImp(ep, null);
                pipe.setUsbPipeOsImp(new LinuxIsochronousPipeImp(pipe, linuxInterfaceOsImp));
                break;
            }
            default: {
                throw new RuntimeException("Invalid UsbEndpoint type " + ep.getType());
            }
        }
        return ep;
    }

    private static void configureUsbDeviceImp(UsbDeviceImp targetDevice, byte length, byte type, byte deviceClass, byte deviceSubClass, byte deviceProtocol, byte maxDefaultEndpointSize, byte manufacturerIndex, byte productIndex, byte serialNumberIndex, byte numConfigs, short vendorId, short productId, short bcdDevice, short bcdUsb, int speed) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        deviceClass = (byte)(deviceClass + 0);
        deviceSubClass = (byte)(deviceSubClass + 0);
        deviceProtocol = (byte)(deviceProtocol + 0);
        maxDefaultEndpointSize = (byte)(maxDefaultEndpointSize + 0);
        manufacturerIndex = (byte)(manufacturerIndex + 0);
        productIndex = (byte)(productIndex + 0);
        serialNumberIndex = (byte)(serialNumberIndex + 0);
        numConfigs = (byte)(numConfigs + 0);
        vendorId = (short)(vendorId + 0);
        productId = (short)(productId + 0);
        bcdDevice = (short)(bcdDevice + 0);
        bcdUsb = (short)(bcdUsb + 0);
        UsbDeviceDescriptorImp desc = new UsbDeviceDescriptorImp(length, type, bcdUsb, deviceClass, deviceSubClass, deviceProtocol, maxDefaultEndpointSize, vendorId, productId, bcdDevice, manufacturerIndex, productIndex, serialNumberIndex, numConfigs);
        targetDevice.setUsbDeviceDescriptor(desc);
        switch (speed) {
            case 1: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_LOW);
                break;
            }
            case 2: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_FULL);
                break;
            }
            case 0: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_UNKNOWN);
                break;
            }
            default: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_UNKNOWN);
            }
        }
    }
}

