/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbControlIrpImp;
import com.ibm.jusb.UsbEndpointImp;
import com.ibm.jusb.UsbIrpImp;
import com.ibm.jusb.event.UsbPipeListenerImp;
import com.ibm.jusb.os.DefaultUsbPipeOsImp;
import com.ibm.jusb.os.UsbPipeOsImp;
import com.ibm.jusb.util.RunnableManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.usb.UsbAbortException;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbIrp;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import javax.usb.util.UsbUtil;

public class UsbPipeImp
implements UsbPipe,
UsbIrpImp.UsbIrpImpListener {
    private boolean open = false;
    private UsbPipeOsImp usbPipeOsImp = new DefaultUsbPipeOsImp();
    private UsbEndpointImp usbEndpointImp = null;
    protected UsbPipeListenerImp listenerImp = new UsbPipeListenerImp();
    private boolean listenerNameSet = false;
    protected RunnableManager queueManager = new RunnableManager(false);
    protected boolean queueSubmissions = false;
    protected boolean abortInProgress = false;
    protected boolean createShortPacketException = false;
    protected Hashtable listTable = new Hashtable();
    protected List submissionList = new Vector();
    private Object submitLock = new Object();
    private Object completeLock = new Object();
    private Object abortLock = new Object();
    public static final String PIPE_CONTROL_QUEUE_POLICY_KEY = "com.ibm.jusb.UsbPipeImp.queueSubmissions.control";
    public static final String PIPE_INTERRUPT_QUEUE_POLICY_KEY = "com.ibm.jusb.UsbPipeImp.queueSubmissions.interrupt";
    public static final String PIPE_ISOCHRONOUS_QUEUE_POLICY_KEY = "com.ibm.jusb.UsbPipeImp.queueSubmissions.isochronous";
    public static final String PIPE_BULK_QUEUE_POLICY_KEY = "com.ibm.jusb.UsbPipeImp.queueSubmissions.bulk";
    public static final String CREATE_SHORT_PACKET_EXCEPTION_POLICY_KEY = "com.ibm.jusb.UsbIrpImp.createShortPacketException";

    public UsbPipeImp() {
    }

    public UsbPipeImp(UsbEndpointImp ep) {
        this.setUsbEndpointImp(ep);
    }

    public UsbPipeImp(UsbPipeOsImp pipe) {
        this.setUsbPipeOsImp(pipe);
    }

    public UsbPipeImp(UsbEndpointImp ep, UsbPipeOsImp pipe) {
        this.setUsbEndpointImp(ep);
        this.setUsbPipeOsImp(pipe);
    }

    public UsbPipeOsImp getUsbPipeOsImp() {
        return this.usbPipeOsImp;
    }

    public void setUsbPipeOsImp(UsbPipeOsImp pipe) {
        this.usbPipeOsImp = null == pipe ? new DefaultUsbPipeOsImp() : pipe;
    }

    @Override
    public boolean isActive() {
        return this.getUsbEndpoint().getUsbInterface().isActive();
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public UsbEndpoint getUsbEndpoint() {
        return this.getUsbEndpointImp();
    }

    public UsbEndpointImp getUsbEndpointImp() {
        return this.usbEndpointImp;
    }

    public void setUsbEndpointImp(UsbEndpointImp ep) {
        this.usbEndpointImp = ep;
        if (null != ep) {
            ep.setUsbPipeImp(this);
        }
        this.setPolicies();
    }

    @Override
    public void open() throws UsbException, UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException {
        this.checkActive();
        if (!this.getUsbEndpointImp().getUsbInterfaceImp().hasUsbInterfacePolicy()) {
            String i = UsbUtil.toHexString(this.getUsbEndpointImp().getUsbInterfaceImp().getUsbInterfaceDescriptor().bInterfaceNumber());
            String a = UsbUtil.toHexString(this.getUsbEndpointImp().getUsbInterfaceImp().getUsbInterfaceDescriptor().bAlternateSetting());
            throw new UsbNotClaimedException("UsbInterface 0x" + i + " setting 0x" + a + " is not claimed");
        }
        if (this.isOpen()) {
            throw new UsbException("UsbPipe is already open");
        }
        this.getUsbPipeOsImp().open();
        this.open = true;
    }

    @Override
    public void close() throws UsbException, UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        this.checkOpen();
        if (0 < this.submissionList.size()) {
            throw new UsbException("Cannot close pipe with pending submissions");
        }
        this.getUsbPipeOsImp().close();
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int syncSubmit(byte[] data) throws UsbException, IllegalArgumentException, UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkOpen();
            UsbIrpImp usbIrpImp = this.createUsbIrpImp();
            usbIrpImp.setData(data);
            this.syncSubmit(usbIrpImp);
            return usbIrpImp.getActualLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsbIrp asyncSubmit(byte[] data) throws UsbException, IllegalArgumentException, UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkOpen();
            UsbIrpImp usbIrpImp = this.createUsbIrpImp();
            usbIrpImp.setData(data);
            this.asyncSubmit(usbIrpImp);
            return usbIrpImp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncSubmit(UsbIrp usbIrp) throws UsbException, IllegalArgumentException, UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkOpen();
            UsbIrpImp usbIrpImp = this.usbIrpToUsbIrpImp(usbIrp);
            this.submissionList.add(usbIrpImp);
            if (this.queueSubmissions) {
                this.queueUsbIrpImp(usbIrpImp);
                usbIrpImp.waitUntilComplete();
                if (usbIrpImp.isUsbException()) {
                    throw usbIrpImp.getUsbException();
                }
            } else {
                try {
                    this.getUsbPipeOsImp().syncSubmit(usbIrpImp);
                }
                catch (UsbException uE) {
                    this.submissionList.remove(usbIrpImp);
                    throw uE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncSubmit(UsbIrp usbIrp) throws UsbException, IllegalArgumentException, UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkOpen();
            UsbIrpImp usbIrpImp = this.usbIrpToUsbIrpImp(usbIrp);
            this.submissionList.add(usbIrpImp);
            if (this.queueSubmissions) {
                this.queueUsbIrpImp(usbIrpImp);
            } else {
                try {
                    this.getUsbPipeOsImp().asyncSubmit(usbIrpImp);
                }
                catch (UsbException uE) {
                    this.submissionList.remove(usbIrpImp);
                    throw uE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncSubmit(List list) throws UsbException, IllegalArgumentException, UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkOpen();
            if (list.isEmpty()) {
                return;
            }
            List usbIrpImpList = this.usbIrpListToUsbIrpImpList(list);
            this.submissionList.addAll(usbIrpImpList);
            if (this.queueSubmissions) {
                this.queueList(usbIrpImpList);
                ((UsbIrp)usbIrpImpList.get(usbIrpImpList.size() - 1)).waitUntilComplete();
            } else {
                try {
                    this.getUsbPipeOsImp().syncSubmit(usbIrpImpList);
                }
                catch (UsbException uE) {
                    this.submissionList.removeAll(usbIrpImpList);
                    throw uE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncSubmit(List list) throws UsbException, IllegalArgumentException, UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkOpen();
            if (list.isEmpty()) {
                return;
            }
            List usbIrpImpList = this.usbIrpListToUsbIrpImpList(list);
            this.submissionList.addAll(usbIrpImpList);
            if (this.queueSubmissions) {
                this.queueList(usbIrpImpList);
            } else {
                try {
                    this.getUsbPipeOsImp().asyncSubmit(usbIrpImpList);
                }
                catch (UsbException uE) {
                    this.submissionList.removeAll(usbIrpImpList);
                    throw uE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortAllSubmissions() throws UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkOpen();
            if (this.queueSubmissions) {
                Object object2 = this.abortLock;
                synchronized (object2) {
                    this.abortInProgress = true;
                    this.getUsbPipeOsImp().abortAllSubmissions();
                    while (0L < this.queueManager.getSize()) {
                        try {
                            this.abortLock.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.abortInProgress = false;
                }
            } else {
                this.getUsbPipeOsImp().abortAllSubmissions();
            }
        }
    }

    @Override
    public UsbIrp createUsbIrp() {
        return new UsbIrpImp();
    }

    @Override
    public UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        return new UsbControlIrpImp(bmRequestType, bRequest, wValue, wIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void usbIrpImpComplete(UsbIrpImp irp) {
        Object object = this.completeLock;
        synchronized (object) {
            this.submissionList.remove(irp);
            if (this.listTable.containsKey(irp)) {
                UsbIrpImp usbIrpImp;
                List list = (List)this.listTable.get(irp);
                while (!list.isEmpty() && (usbIrpImp = (UsbIrpImp)list.get(0)).isComplete()) {
                    list.remove(0);
                    this.listTable.remove(irp);
                    this.fireEvent(usbIrpImp);
                }
            } else {
                this.fireEvent(irp);
            }
        }
    }

    @Override
    public void addUsbPipeListener(UsbPipeListener listener) {
        if (!this.listenerNameSet) {
            this.listenerImp.setName(this.getName() + " UsbPipeListenerImp");
            this.listenerNameSet = true;
        }
        this.listenerImp.addEventListener(listener);
    }

    @Override
    public void removeUsbPipeListener(UsbPipeListener listener) {
        this.listenerImp.removeEventListener(listener);
    }

    public void setupUsbIrpImp(UsbIrpImp irp) {
        irp.setUsbIrpImpListener(this);
        irp.setCreateShortPacketException(this.createShortPacketException && this.isInDirection(irp));
    }

    protected void fireEvent(UsbIrpImp usbIrpImp) {
        UsbIrp irp = usbIrpImp.getUsbIrp();
        if (null == irp) {
            irp = usbIrpImp;
        }
        if (irp.isUsbException()) {
            if (this.isDisconnected()) {
                irp.setUsbException(new UsbAbortException("The device was disconnected"));
            }
            this.listenerImp.errorEventOccurred(new UsbPipeErrorEvent((UsbPipe)this, irp));
        } else {
            this.listenerImp.dataEventOccurred(new UsbPipeDataEvent(this, irp));
        }
    }

    protected UsbIrpImp usbIrpToUsbIrpImp(UsbIrp irp) throws UsbException, IllegalArgumentException {
        UsbIrpImp.checkUsbIrp(irp);
        UsbIrpImp usbIrpImp = null;
        try {
            usbIrpImp = (UsbIrpImp)irp;
        }
        catch (ClassCastException ccE) {
            usbIrpImp = new UsbIrpImp(irp);
        }
        this.setupUsbIrpImp(usbIrpImp);
        return usbIrpImp;
    }

    protected List usbIrpListToUsbIrpImpList(List list) throws UsbException, IllegalArgumentException {
        ArrayList<UsbIrpImp> newlist = new ArrayList<UsbIrpImp>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                newlist.add(this.usbIrpToUsbIrpImp((UsbIrp)list.get(i)));
            }
        }
        catch (ClassCastException ccE) {
            throw new IllegalArgumentException("The List contains a non-UsbIrp object.");
        }
        ArrayList delayEventList = (ArrayList)newlist.clone();
        for (int i = 0; i < delayEventList.size(); ++i) {
            this.listTable.put(delayEventList.get(i), delayEventList);
        }
        return newlist;
    }

    protected void checkDisconnected() throws UsbDisconnectedException {
        this.getUsbEndpointImp().checkDisconnected();
    }

    protected boolean isDisconnected() {
        return this.getUsbEndpointImp().isDisconnected();
    }

    protected void checkActive() throws UsbNotActiveException, UsbDisconnectedException {
        this.checkDisconnected();
        if (!this.isActive()) {
            throw new UsbNotActiveException("UsbPipe not active");
        }
    }

    protected void checkOpen() throws UsbNotActiveException, UsbNotOpenException, UsbDisconnectedException {
        this.checkActive();
        if (!this.isOpen()) {
            throw new UsbNotOpenException("UsbPipe not open");
        }
    }

    protected UsbIrpImp createUsbIrpImp() {
        return new UsbIrpImp();
    }

    protected void addRunnable(Runnable r) {
        if (!this.queueManager.isRunning()) {
            this.queueManager.setName(this.getName() + " RunnableManager");
            this.queueManager.setMaxSize(Long.MAX_VALUE);
            this.queueManager.start();
        }
        this.queueManager.add(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitUsbIrpImpFromQueue(UsbIrpImp usbIrpImp) {
        Object object = this.abortLock;
        synchronized (object) {
            if (this.abortInProgress) {
                usbIrpImp.setUsbException(new UsbAbortException());
                usbIrpImp.complete();
                return;
            }
            try {
                this.getUsbPipeOsImp().asyncSubmit(usbIrpImp);
            }
            catch (UsbException uE) {
                this.submissionList.remove(usbIrpImp);
            }
        }
        usbIrpImp.waitUntilComplete();
    }

    protected void queueUsbIrpImp(final UsbIrpImp usbIrpImp) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UsbPipeImp.this.submitUsbIrpImpFromQueue(usbIrpImp);
            }
        };
        this.addRunnable(r);
    }

    protected void queueList(final List list) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < list.size(); ++i) {
                    UsbPipeImp.this.submitUsbIrpImpFromQueue((UsbIrpImp)list.get(i));
                }
            }
        };
        this.addRunnable(r);
    }

    protected void setPolicies() {
        Properties p = null;
        try {
            p = UsbHostManager.getProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected Exception while calling UsbHostManager.getProperties() : " + e.getMessage());
        }
        String policy = null;
        byte endpointType = (byte)(3 & this.getUsbEndpoint().getUsbEndpointDescriptor().bmAttributes());
        switch (endpointType) {
            case 0: {
                policy = p.getProperty(PIPE_CONTROL_QUEUE_POLICY_KEY);
                break;
            }
            case 3: {
                policy = p.getProperty(PIPE_INTERRUPT_QUEUE_POLICY_KEY);
                break;
            }
            case 1: {
                policy = p.getProperty(PIPE_ISOCHRONOUS_QUEUE_POLICY_KEY);
                break;
            }
            case 2: {
                policy = p.getProperty(PIPE_BULK_QUEUE_POLICY_KEY);
                break;
            }
            default: {
                throw new RuntimeException("Illegal endpoint type 0x" + UsbUtil.toHexString(endpointType));
            }
        }
        if (null != policy) {
            this.queueSubmissions = Boolean.valueOf(policy.trim());
        }
        if (null != (policy = p.getProperty(CREATE_SHORT_PACKET_EXCEPTION_POLICY_KEY))) {
            this.createShortPacketException = Boolean.valueOf(policy.trim());
        }
    }

    protected boolean isInDirection(UsbIrpImp irp) {
        byte dir = this.getUsbEndpoint().getDirection();
        try {
            dir = (byte)(0xFFFFFF80 & ((UsbControlIrp)((Object)irp)).bmRequestType());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return -128 == dir;
    }

    String getName() {
        String deviceName = this.getUsbEndpointImp().getUsbInterfaceImp().getUsbConfigurationImp().getUsbDeviceImp().getName();
        String ep = "";
        ep = null == this.getUsbEndpoint().getUsbEndpointDescriptor() ? "??" : UsbUtil.toHexString(this.getUsbEndpoint().getUsbEndpointDescriptor().bEndpointAddress());
        return deviceName + " UsbPipeImp 0x" + ep;
    }

    void disconnect() {
        this.queueManager.stop();
        this.listenerImp.clear();
    }
}

