/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import java.util.EventListener;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbShortPacketException;
import javax.usb.util.DefaultUsbIrp;

public class UsbIrpImp
extends DefaultUsbIrp
implements UsbIrp {
    protected UsbIrp usbIrp = null;
    protected UsbIrpImpListener usbIrpImpListener = null;
    protected boolean createShortPacketException = false;

    public UsbIrpImp() {
    }

    public UsbIrpImp(UsbIrp irp) {
        this();
        this.setUsbIrp(irp);
    }

    @Override
    public void complete() {
        this.checkShortPacketException();
        this.completeUsbIrp();
        super.complete();
        try {
            this.getUsbIrpImpListener().usbIrpImpComplete(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void completeUsbIrp() {
        try {
            UsbIrp irp = this.getUsbIrp();
            irp.setUsbException(this.getUsbException());
            irp.setActualLength(this.getActualLength());
            irp.complete();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setUsbIrp(UsbIrp irp) {
        this.usbIrp = irp;
        this.setData(irp.getData(), irp.getOffset(), irp.getLength());
        this.setAcceptShortPacket(irp.getAcceptShortPacket());
        this.setUsbException(irp.getUsbException());
        this.setComplete(irp.isComplete());
    }

    public boolean hasUsbIrp() {
        return null != this.getUsbIrp();
    }

    public UsbIrp getUsbIrp() {
        return this.usbIrp;
    }

    public synchronized void setUsbIrpImpListener(UsbIrpImpListener listener) {
        this.usbIrpImpListener = listener;
    }

    public UsbIrpImpListener getUsbIrpImpListener() {
        return this.usbIrpImpListener;
    }

    public static void checkUsbIrp(UsbIrp irp) throws IllegalArgumentException, UsbException {
        if (null == irp.getData()) {
            throw new IllegalArgumentException("UsbIrp data cannot be null.");
        }
        int datalen = irp.getData().length;
        int offset = irp.getOffset();
        int length = irp.getLength();
        if (0 > offset) {
            throw new IllegalArgumentException("UsbIrp offset (" + offset + ") cannot be negative.");
        }
        if (0 > length) {
            throw new IllegalArgumentException("UsbIrp length (" + length + ") cannot be negative.");
        }
        if (datalen < offset + length) {
            throw new UsbException("Data buffer (length " + datalen + ") is smaller than offset (" + offset + ") + length (" + length + ") = " + (offset + length));
        }
        if (irp.isComplete()) {
            throw new UsbException("UsbIrp cannot be used while isComplete() is true.");
        }
        if (irp.isUsbException()) {
            throw new UsbException("UsbIrp cannot be used while isUsbException() is true.");
        }
    }

    protected void checkShortPacketException() {
        if (!this.createShortPacketException || this.getAcceptShortPacket()) {
            return;
        }
        if (this.getLength() > this.getActualLength() && !this.isUsbException()) {
            this.setUsbException(new UsbShortPacketException("Short Packet condition was detected by javax.usb common implementation."));
        }
    }

    public void setCreateShortPacketException(boolean setting) {
        this.createShortPacketException = setting;
    }

    public static interface UsbIrpImpListener
    extends EventListener {
        public void usbIrpImpComplete(UsbIrpImp var1);
    }
}

