/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbConfigurationImp;
import com.ibm.jusb.UsbControlIrpImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.UsbIrpImp;
import com.ibm.jusb.UsbPortImp;
import com.ibm.jusb.UsbStringDescriptorImp;
import com.ibm.jusb.event.UsbDeviceListenerImp;
import com.ibm.jusb.os.DefaultUsbDeviceOsImp;
import com.ibm.jusb.os.UsbDeviceOsImp;
import com.ibm.jusb.util.RunnableManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.usb.UsbAbortException;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbPort;
import javax.usb.UsbStringDescriptor;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.util.StandardRequest;
import javax.usb.util.UsbUtil;

public class UsbDeviceImp
implements UsbDevice,
UsbIrpImp.UsbIrpImpListener {
    private UsbDeviceOsImp usbDeviceOsImp = null;
    private Object submitLock = new Object();
    private UsbDeviceDescriptor usbDeviceDescriptor = null;
    private Hashtable usbStringDescriptors = new Hashtable();
    private short langId = 0;
    private Object speed = UsbConst.DEVICE_SPEED_UNKNOWN;
    private List configurations = new ArrayList();
    private byte activeConfigurationNumber = 0;
    private UsbPortImp usbPortImp = null;
    private UsbDeviceListenerImp listenerImp = new UsbDeviceListenerImp();
    private boolean listenerNameSet = false;
    protected RunnableManager queueManager = new RunnableManager(false);
    protected boolean queueSubmissions = false;
    protected boolean createShortPacketException = false;
    protected Hashtable listTable = new Hashtable();
    protected int submissionCount = 0;
    protected boolean disconnected = false;
    public static final String DCP_QUEUE_POLICY_KEY = "com.ibm.jusb.UsbDeviceImp.queueSubmissions";
    public static final String CREATE_SHORT_PACKET_EXCEPTION_POLICY_KEY = "com.ibm.jusb.UsbIrpImp.createShortPacketException";

    public UsbDeviceImp() {
        this(null, null);
    }

    public UsbDeviceImp(UsbDeviceDescriptor desc) {
        this(desc, null);
    }

    public UsbDeviceImp(UsbDeviceOsImp device) {
        this(null, device);
    }

    public UsbDeviceImp(UsbDeviceDescriptor desc, UsbDeviceOsImp device) {
        this.setUsbDeviceDescriptor(desc);
        this.setUsbDeviceOsImp(device);
        this.setPolicies();
    }

    public UsbDeviceOsImp getUsbDeviceOsImp() {
        return this.usbDeviceOsImp;
    }

    public void setUsbDeviceOsImp(UsbDeviceOsImp deviceImp) {
        this.usbDeviceOsImp = null == deviceImp ? new DefaultUsbDeviceOsImp() : deviceImp;
    }

    @Override
    public UsbPort getParentUsbPort() throws UsbDisconnectedException {
        return this.getParentUsbPortImp();
    }

    public UsbPortImp getParentUsbPortImp() throws UsbDisconnectedException {
        this.checkDisconnected();
        return this.usbPortImp;
    }

    public void setParentUsbPortImp(UsbPortImp port) {
        this.usbPortImp = port;
    }

    @Override
    public boolean isUsbHub() {
        return false;
    }

    @Override
    public String getManufacturerString() throws UsbException, UsbEncodingException, UsbDisconnectedException {
        return this.getString(this.getUsbDeviceDescriptor().iManufacturer());
    }

    @Override
    public String getSerialNumberString() throws UsbException, UsbEncodingException, UsbDisconnectedException {
        return this.getString(this.getUsbDeviceDescriptor().iSerialNumber());
    }

    @Override
    public String getProductString() throws UsbException, UsbEncodingException, UsbDisconnectedException {
        return this.getString(this.getUsbDeviceDescriptor().iProduct());
    }

    @Override
    public Object getSpeed() {
        return this.speed;
    }

    @Override
    public List getUsbConfigurations() {
        return Collections.unmodifiableList(this.configurations);
    }

    @Override
    public UsbConfiguration getUsbConfiguration(byte number) {
        return this.getUsbConfigurationImp(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbConfigurationImp getUsbConfigurationImp(byte number) {
        List list = this.configurations;
        synchronized (list) {
            for (int i = 0; i < this.configurations.size(); ++i) {
                UsbConfigurationImp configuration = (UsbConfigurationImp)this.configurations.get(i);
                if (number != configuration.getUsbConfigurationDescriptor().bConfigurationValue()) continue;
                return configuration;
            }
        }
        return null;
    }

    @Override
    public boolean containsUsbConfiguration(byte number) {
        return null != this.getUsbConfiguration(number);
    }

    @Override
    public boolean isConfigured() {
        return 0 != this.getActiveUsbConfigurationNumber();
    }

    @Override
    public byte getActiveUsbConfigurationNumber() {
        return this.activeConfigurationNumber;
    }

    @Override
    public UsbConfiguration getActiveUsbConfiguration() {
        return this.getActiveUsbConfigurationImp();
    }

    public UsbConfigurationImp getActiveUsbConfigurationImp() {
        return this.getUsbConfigurationImp(this.getActiveUsbConfigurationNumber());
    }

    @Override
    public UsbDeviceDescriptor getUsbDeviceDescriptor() {
        return this.usbDeviceDescriptor;
    }

    @Override
    public UsbStringDescriptor getUsbStringDescriptor(byte index) throws UsbException, UsbDisconnectedException {
        this.checkDisconnected();
        if (0 == index) {
            return null;
        }
        UsbStringDescriptor desc = this.getCachedUsbStringDescriptor(index);
        if (null == desc) {
            this.requestUsbStringDescriptor(index);
            desc = this.getCachedUsbStringDescriptor(index);
        }
        return desc;
    }

    @Override
    public String getString(byte index) throws UsbException, UsbEncodingException, UsbDisconnectedException {
        UsbStringDescriptor desc = this.getUsbStringDescriptor(index);
        try {
            return desc.getString();
        }
        catch (NullPointerException npE) {
            return null;
        }
    }

    @Override
    public UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        return new UsbControlIrpImp(bmRequestType, bRequest, wValue, wIndex);
    }

    @Override
    public void usbIrpImpComplete(UsbIrpImp usbIrpImp) {
        --this.submissionCount;
        UsbControlIrpImp irp = null;
        try {
            irp = (UsbControlIrpImp)usbIrpImp;
        }
        catch (ClassCastException ccE) {
            // empty catch block
        }
        if (this.listTable.containsKey(irp)) {
            UsbControlIrpImp usbControlIrpImp;
            List list = (List)this.listTable.get(irp);
            while (!list.isEmpty() && (usbControlIrpImp = (UsbControlIrpImp)list.get(0)).isComplete()) {
                list.remove(0);
                this.listTable.remove(irp);
                this.fireEvent(usbControlIrpImp);
            }
        } else {
            this.fireEvent(irp);
        }
    }

    @Override
    public void addUsbDeviceListener(UsbDeviceListener listener) {
        if (!this.listenerNameSet) {
            this.listenerImp.setName(this.getName() + " UsbDeviceListenerImp");
            this.listenerNameSet = true;
        }
        this.listenerImp.addEventListener(listener);
    }

    @Override
    public void removeUsbDeviceListener(UsbDeviceListener listener) {
        this.listenerImp.removeEventListener(listener);
    }

    public void setUsbDeviceDescriptor(UsbDeviceDescriptor desc) {
        this.usbDeviceDescriptor = desc;
    }

    public UsbStringDescriptor getCachedUsbStringDescriptor(byte index) {
        return (UsbStringDescriptor)this.usbStringDescriptors.get(new Byte(index).toString());
    }

    public void setCachedUsbStringDescriptor(byte index, UsbStringDescriptor desc) {
        this.usbStringDescriptors.put(new Byte(index).toString(), desc);
    }

    public void setSpeed(Object o) {
        if (UsbConst.DEVICE_SPEED_UNKNOWN != o && UsbConst.DEVICE_SPEED_LOW != o && UsbConst.DEVICE_SPEED_FULL != o) {
            throw new IllegalArgumentException("Device speed must be DEVICE_SPEED_UNKNOWN, DEVICE_SPEED_LOW, or DEVICE_SPEED_FULL.");
        }
        this.speed = o;
    }

    public void setActiveUsbConfigurationNumber(byte num) {
        this.activeConfigurationNumber = num;
    }

    public void addUsbConfigurationImp(UsbConfigurationImp configuration) {
        if (!this.configurations.contains(configuration)) {
            this.configurations.add(configuration);
        }
    }

    public void connect(UsbHubImp hub, byte portNumber) throws UsbException {
        hub.addUsbDeviceImp(this, portNumber);
        this.setParentUsbPortImp(hub.getUsbPortImp(portNumber));
    }

    public void disconnect() {
        try {
            this.getParentUsbPortImp().detachUsbDeviceImp(this);
        }
        catch (IllegalArgumentException iaE) {
            // empty catch block
        }
        Iterator i = this.getUsbConfigurations().iterator();
        while (i.hasNext()) {
            ((UsbConfigurationImp)i.next()).disconnect();
        }
        this.disconnected = true;
        this.listenerImp.usbDeviceDetached(new UsbDeviceEvent(this));
        if (this.queueSubmissions) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    UsbDeviceImp.this.listenerImp.clear();
                }
            };
            this.addRunnable(r);
            this.queueManager.stop();
        } else {
            this.listenerImp.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncSubmit(UsbControlIrp irp) throws UsbException, IllegalArgumentException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkDisconnected();
            UsbControlIrpImp usbControlIrpImp = this.usbControlIrpToUsbControlIrpImp(irp);
            if (this.queueSubmissions) {
                this.queueUsbControlIrpImp(usbControlIrpImp);
                usbControlIrpImp.waitUntilComplete();
                if (usbControlIrpImp.isUsbException()) {
                    throw usbControlIrpImp.getUsbException();
                }
            } else {
                ++this.submissionCount;
                this.getUsbDeviceOsImp().syncSubmit(usbControlIrpImp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncSubmit(UsbControlIrp irp) throws UsbException, IllegalArgumentException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkDisconnected();
            UsbControlIrpImp usbControlIrpImp = this.usbControlIrpToUsbControlIrpImp(irp);
            if (this.queueSubmissions) {
                this.queueUsbControlIrpImp(usbControlIrpImp);
            } else {
                ++this.submissionCount;
                this.getUsbDeviceOsImp().asyncSubmit(usbControlIrpImp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncSubmit(List list) throws UsbException, IllegalArgumentException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkDisconnected();
            if (list.isEmpty()) {
                return;
            }
            List usbControlIrpImpList = this.usbControlIrpListToUsbControlIrpImpList(list);
            if (this.queueSubmissions) {
                this.queueList(usbControlIrpImpList);
                ((UsbControlIrp)usbControlIrpImpList.get(usbControlIrpImpList.size() - 1)).waitUntilComplete();
            } else {
                this.submissionCount += usbControlIrpImpList.size();
                this.getUsbDeviceOsImp().syncSubmit(usbControlIrpImpList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncSubmit(List list) throws UsbException, IllegalArgumentException, UsbDisconnectedException {
        Object object = this.submitLock;
        synchronized (object) {
            this.checkDisconnected();
            if (list.isEmpty()) {
                return;
            }
            List usbControlIrpImpList = this.usbControlIrpListToUsbControlIrpImpList(list);
            if (this.queueSubmissions) {
                this.queueList(usbControlIrpImpList);
            } else {
                this.submissionCount += usbControlIrpImpList.size();
                this.getUsbDeviceOsImp().asyncSubmit(usbControlIrpImpList);
            }
        }
    }

    protected void fireEvent(UsbControlIrpImp usbControlIrpImp) {
        UsbControlIrp irp = (UsbControlIrp)usbControlIrpImp.getUsbIrp();
        if (null == irp) {
            irp = usbControlIrpImp;
        }
        if (irp.isUsbException()) {
            if (this.isDisconnected()) {
                irp.setUsbException(new UsbAbortException("The device was disconnected"));
            }
            this.listenerImp.errorEventOccurred(new UsbDeviceErrorEvent(this, irp));
        } else {
            this.listenerImp.dataEventOccurred(new UsbDeviceDataEvent(this, irp));
        }
    }

    protected synchronized short getLangId() throws UsbException {
        if (0 == this.langId) {
            byte[] data = new byte[256];
            int len = StandardRequest.getDescriptor(this, (byte)3, (byte)0, (short)0, data);
            if (4 > len || 4 > UsbUtil.unsignedInt(data[0])) {
                throw new UsbException("Strings not supported by device");
            }
            this.langId = (short)(data[3] << 8 | data[2]);
        }
        return this.langId;
    }

    protected void requestUsbStringDescriptor(byte index) throws UsbException {
        byte[] data = new byte[256];
        int len = StandardRequest.getDescriptor(this, (byte)3, index, this.getLangId(), data);
        if (2 > len || 2 > UsbUtil.unsignedInt(data[0])) {
            return;
        }
        if (UsbUtil.unsignedInt(data[0]) > len) {
            throw new UsbException("String Descriptor length byte is longer than Descriptor data");
        }
        int strLen = UsbUtil.unsignedInt(data[0]) - 2;
        byte[] bString = new byte[strLen];
        System.arraycopy(data, 2, bString, 0, strLen);
        this.setCachedUsbStringDescriptor(index, new UsbStringDescriptorImp(data[0], data[1], bString));
    }

    protected void setupUsbControlIrpImp(UsbControlIrpImp irp) {
        irp.setUsbIrpImpListener(this);
        irp.setUsbDeviceImp(this);
        boolean inDirection = -128 == (byte)(0xFFFFFF80 & irp.bmRequestType());
        irp.setCreateShortPacketException(this.createShortPacketException && inDirection);
    }

    protected UsbControlIrpImp usbControlIrpToUsbControlIrpImp(UsbControlIrp usbControlIrp) throws UsbException, IllegalArgumentException {
        UsbControlIrpImp.checkUsbControlIrp(usbControlIrp);
        UsbControlIrpImp usbControlIrpImp = null;
        try {
            usbControlIrpImp = (UsbControlIrpImp)usbControlIrp;
        }
        catch (ClassCastException ccE) {
            usbControlIrpImp = new UsbControlIrpImp(usbControlIrp);
        }
        this.setupUsbControlIrpImp(usbControlIrpImp);
        return usbControlIrpImp;
    }

    protected List usbControlIrpListToUsbControlIrpImpList(List list) throws IllegalArgumentException, UsbException {
        ArrayList<UsbControlIrpImp> newList = new ArrayList<UsbControlIrpImp>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                newList.add(this.usbControlIrpToUsbControlIrpImp((UsbControlIrp)list.get(i)));
            }
        }
        catch (ClassCastException ccE) {
            throw new IllegalArgumentException("The List contains a non-UsbIrp object.");
        }
        ArrayList delayEventList = (ArrayList)newList.clone();
        for (int i = 0; i < delayEventList.size(); ++i) {
            this.listTable.put(delayEventList.get(i), delayEventList);
        }
        return newList;
    }

    protected void addRunnable(Runnable r) {
        if (!this.queueManager.isRunning()) {
            this.queueManager.setName(this.getName() + " RunnableManager");
            this.queueManager.setMaxSize(Long.MAX_VALUE);
            this.queueManager.start();
        }
        this.queueManager.add(r);
    }

    protected void submitUsbControlIrpImpFromQueue(UsbControlIrpImp usbControlIrpImp) {
        try {
            ++this.submissionCount;
            this.getUsbDeviceOsImp().syncSubmit(usbControlIrpImp);
        }
        catch (UsbException usbException) {
            // empty catch block
        }
    }

    protected void queueUsbControlIrpImp(final UsbControlIrpImp usbControlIrpImp) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                UsbDeviceImp.this.submitUsbControlIrpImpFromQueue(usbControlIrpImp);
            }
        };
        this.addRunnable(r);
    }

    protected void queueList(final List list) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < list.size(); ++i) {
                    UsbDeviceImp.this.submitUsbControlIrpImpFromQueue((UsbControlIrpImp)list.get(i));
                }
            }
        };
        this.addRunnable(r);
    }

    protected void setPolicies() {
        Properties p = null;
        try {
            p = UsbHostManager.getProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected Exception while calling UsbHostManager.getProperties() : " + e.getMessage());
        }
        String policy = p.getProperty(DCP_QUEUE_POLICY_KEY);
        if (null != policy) {
            this.queueSubmissions = Boolean.valueOf(policy.trim());
        }
        if (null != (policy = p.getProperty(CREATE_SHORT_PACKET_EXCEPTION_POLICY_KEY))) {
            this.createShortPacketException = Boolean.valueOf(policy.trim());
        }
    }

    String getName() {
        String vendor = "";
        String product = "";
        if (null == this.getUsbDeviceDescriptor()) {
            vendor = "????";
            product = "????";
        } else {
            vendor = UsbUtil.toHexString(this.getUsbDeviceDescriptor().idVendor());
            product = UsbUtil.toHexString(this.getUsbDeviceDescriptor().idProduct());
        }
        return "UsbDeviceImp <" + vendor + ":" + product + ">";
    }

    void checkDisconnected() throws UsbDisconnectedException {
        if (this.isDisconnected()) {
            throw new UsbDisconnectedException("This device has been disconnected");
        }
    }

    boolean isDisconnected() {
        return this.disconnected;
    }
}

