/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbIrpImp;
import javax.usb.UsbControlIrp;
import javax.usb.UsbException;

public class UsbControlIrpImp
extends UsbIrpImp
implements UsbControlIrp {
    protected byte bmRequestType = 0;
    protected byte bRequest = 0;
    protected short wValue = 0;
    protected short wIndex = 0;
    protected UsbDeviceImp usbDeviceImp = null;
    private static final byte REQUESTTYPE_SET_CONFIGURATION = 0;
    private static final byte REQUESTTYPE_SET_INTERFACE = 1;

    public UsbControlIrpImp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
        this.bmRequestType = bmRequestType;
        this.bRequest = bRequest;
        this.wValue = wValue;
        this.wIndex = wIndex;
    }

    public UsbControlIrpImp(UsbControlIrp controlUsbIrp) {
        super(controlUsbIrp);
        this.bmRequestType = controlUsbIrp.bmRequestType();
        this.bRequest = controlUsbIrp.bRequest();
        this.wValue = controlUsbIrp.wValue();
        this.wIndex = controlUsbIrp.wIndex();
    }

    @Override
    public byte bmRequestType() {
        return this.bmRequestType;
    }

    @Override
    public byte bRequest() {
        return this.bRequest;
    }

    @Override
    public short wValue() {
        return this.wValue;
    }

    @Override
    public short wIndex() {
        return this.wIndex;
    }

    public short wLength() {
        return (short)this.getLength();
    }

    @Override
    public void complete() {
        if (!this.isUsbException()) {
            if (this.isSetConfiguration()) {
                try {
                    this.getUsbDeviceImp().setActiveUsbConfigurationNumber((byte)this.wValue());
                }
                catch (Exception e) {}
            } else if (this.isSetInterface()) {
                try {
                    this.getUsbDeviceImp().getActiveUsbConfigurationImp().getUsbInterfaceImp((byte)this.wIndex()).setActiveSettingNumber((byte)this.wValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.complete();
    }

    public boolean isSetConfiguration() {
        return this.bmRequestType() == 0 && this.bRequest() == 9;
    }

    public boolean isSetInterface() {
        return this.bmRequestType() == 1 && this.bRequest() == 11;
    }

    public byte[] getSetupPacket() {
        byte[] setupPacket = new byte[]{this.bmRequestType(), this.bRequest(), (byte)this.wValue(), (byte)(this.wValue() >> 8), (byte)this.wIndex(), (byte)(this.wIndex() >> 8), (byte)this.wLength(), (byte)(this.wLength() >> 8)};
        return setupPacket;
    }

    public UsbDeviceImp getUsbDeviceImp() {
        return this.usbDeviceImp;
    }

    public void setUsbDeviceImp(UsbDeviceImp device) {
        this.usbDeviceImp = device;
    }

    public static void checkUsbControlIrp(UsbControlIrp irp) throws IllegalArgumentException, UsbException {
        UsbIrpImp.checkUsbIrp(irp);
    }
}

