/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.util.ArrayList;
import org.lsst.ccs.shell.CommandTable;
import org.lsst.ccs.shell.ConsoleIO;
import org.lsst.ccs.shell.DashJoinedNamer;
import org.lsst.ccs.shell.HelpCommandHandler;
import org.lsst.ccs.shell.Shell;
import org.lsst.ccs.shell.util.ArrayHashMultiMap;
import org.lsst.ccs.shell.util.EmptyMultiMap;
import org.lsst.ccs.shell.util.MultiMap;

public class ShellFactory {
    private ShellFactory() {
    }

    public static Shell createConsoleShell(String prompt, String appName, Object ... handlers) {
        ConsoleIO io = new ConsoleIO();
        ArrayList<String> path = new ArrayList<String>(1);
        path.add(prompt);
        ArrayHashMultiMap<String, ConsoleIO> modifAuxHandlers = new ArrayHashMultiMap<String, ConsoleIO>();
        modifAuxHandlers.put("", io);
        Shell theShell = new Shell(new Shell.Settings(io, io, modifAuxHandlers, false), new CommandTable(new DashJoinedNamer(true)), path);
        theShell.setAppName(appName);
        theShell.addMainHandler(theShell, "");
        theShell.addMainHandler(new HelpCommandHandler(), "");
        Object[] objectArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Object h = objectArray[n2];
            theShell.addMainHandler(h, "");
            ++n2;
        }
        return theShell;
    }

    public static Shell createConsoleShell(String prompt, String appName, Object mainHandler, MultiMap<String, Object> auxHandlers) {
        ConsoleIO io = new ConsoleIO();
        ArrayList<String> path = new ArrayList<String>(1);
        path.add(prompt);
        ArrayHashMultiMap<String, Object> modifAuxHandlers = new ArrayHashMultiMap<String, Object>(auxHandlers);
        modifAuxHandlers.put("", io);
        Shell theShell = new Shell(new Shell.Settings(io, io, modifAuxHandlers, false), new CommandTable(new DashJoinedNamer(true)), path);
        theShell.setAppName(appName);
        theShell.addMainHandler(theShell, "");
        theShell.addMainHandler(new HelpCommandHandler(), "");
        theShell.addMainHandler(mainHandler, "");
        return theShell;
    }

    public static Shell createConsoleShell(String prompt, String appName, Object mainHandler) {
        return ShellFactory.createConsoleShell(prompt, appName, mainHandler, new EmptyMultiMap<String, Object>());
    }

    public static Shell createSubshell(String pathElement, Shell parent, String appName, Object mainHandler, MultiMap<String, Object> auxHandlers) {
        ArrayList<String> newPath = new ArrayList<String>(parent.getPath());
        newPath.add(pathElement);
        Shell subshell = new Shell(parent.getSettings().createWithAddedAuxHandlers(auxHandlers), new CommandTable(parent.getCommandTable().getNamer()), newPath);
        subshell.setAppName(appName);
        subshell.addMainHandler(subshell, "");
        subshell.addMainHandler(new HelpCommandHandler(), "");
        subshell.addMainHandler(mainHandler, "");
        return subshell;
    }

    public static Shell createSubshell(String pathElement, Shell parent, String appName, Object mainHandler) {
        return ShellFactory.createSubshell(pathElement, parent, appName, mainHandler, new EmptyMultiMap<String, Object>());
    }
}

