/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConfigurationDescriptor;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfaceDescriptor;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.usb.UsbComm;
import org.lsst.ccs.drivers.usb.UsbCommPipe;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestUsbComm
implements CmndProcess.Dispatch {
    private static final int CMD_FIND = 0;
    private static final int CMD_OPEN = 1;
    private static final int CMD_CLOSE = 2;
    private static final int CMD_FLUSH = 3;
    private static final int CMD_READ = 4;
    private static final int CMD_WRITE = 5;
    private static final int CMD_SHOWDEV = 6;
    private static final int CMD_SHOWCFG = 7;
    private static final int CMD_SHOWIF = 8;
    private static final int CMD_SHOWEP = 9;
    private static final int CMD_SHOWBUS = 10;
    private static final int CMD_SHOWOPEN = 11;
    private static final int CMD_RCNTRL = 12;
    private static final int CMD_WCNTRL = 13;
    private static final int CMD_SETCFG = 14;
    private static final int CMD_SETIF = 15;
    private static final int CMD_CLAIM = 16;
    private static final int CMD_RELEASE = 17;
    private static final int NUM_CMDS = 18;
    private static final String[] helpFind = new String[]{"Find a device", "find <vendId> <devId> [<serial>]", "vendId  The vendor ID of the device", "devId   The device ID of the device", "serial  The serial number of the device (default any)"};
    private static final String[] helpOpen = new String[]{"Open a pipe to a device endpoint", "open <iface> <epaddr>", "iface   The number of the interface to use", "epaddr  The address of the endpoint to open"};
    private static final String[] helpClose = new String[]{"Close a pipe", "close <pipe>", "pipe  The number of the pipe (reported at open time) to close"};
    private static final String[] helpFlush = new String[]{"Flush any unread data from an input pipe", "flush <pipe>", "pipe  The number of the pipe (reported at open time) to flush"};
    private static final String[] helpRead = new String[]{"Read data from an input pipe and display it", "read <pipe> <count> [<timeout>]", "pipe     The number of the pipe (reported at open time) to read from", "count    The number of bytes to read", "timeout  The timeout in seconds (default 1)"};
    private static final String[] helpWrite = new String[]{"Write data to an output pipe", "write <pipe> [<data1>]... [<datan>]", "pipe   The number of the pipe (reported at open time) to write to", "datan  Up to 8 hexadecimal strings"};
    private static final String[] helpRcntrl = new String[]{"Read data from the control endpoint and display it", "rcntrl  <type> <rqst> <value> <index> <count> [<timeout>]", "type     The request type", "rqst     The request", "value    The associated value", "index    The associated index", "count    The number of bytes to read", "timeout  The timeout in seconds (default 1)"};
    private static final String[] helpWcntrl = new String[]{"Write data to the control endpoint", "wcntrl <type> <rqst> <value> <index> [<data1>]... [<datan>]", "type   The request type", "rqst   The request", "value  The associated value", "index  The associated index", "datan  Up to 8 hexadecimal strings"};
    private static final String[] helpClaim = new String[]{"Claim an interface", "claim <iface> [<force>]", "iface  The interface number", "force  If present and non-zero, force the claim"};
    private static final String[] helpRelease = new String[]{"Release an interface", "release <iface>", "iface  The interface number"};
    private static final String[] helpSetcfg = new String[]{"Set the current configuration", "setcfg <number>", "number  The number of the configuration to set"};
    private static final String[] helpSetif = new String[]{"Set the alternate setting for an interface", "setif <iface> <altnum>", "iface   The interface number", "altnum  The alternate setting number"};
    private static final String[] helpShowopen = new String[]{"Show all the open pipes", "showopen"};
    private static final String[] helpShowbus = new String[]{"Show all devices on the USB bus", "showbus"};
    private static final String[] helpShowdev = new String[]{"Show device information", "showdev [<devnum>]", "devnum  Device number from showbus list (default: current device)"};
    private static final String[] helpShowcfg = new String[]{"Show configuration information", "showcfg [<cfgnum>] [<devnum>]", "cfgnum  Configuration number (default: active configuration)", "devnum  Device number from showbus list (default: current device)"};
    private static final String[] helpShowif = new String[]{"Show interface information", "showif <iface> [<altnum>] [<cfgnum>] [<devnum>]", "iface   The interface number", "altnum  The alternate setting number (default: active one)", "cfgnum  Configuration number (default: active configuration)", "devnum  Device number from showbus list (default: current device)"};
    private static final String[] helpShowep = new String[]{"Show endpoint information", "showep <epaddr> <iface> [<altnum>] [<cfgnum>] [<devnum>]", "epaddr  The endpoint address", "iface   The interface number", "altnum  The alternate setting number (default: active one)", "cfgnum  Configuration number (default: active configuration)", "devnum  Device number from showbus list (default: current device)"};
    private static final CmndProcess.Command cmnd = new CmndProcess.Command(18);
    private static final CmndProcess.Lookup speedNames;
    private static final CmndProcess.Lookup devcNames;
    private static final CmndProcess.Lookup cfgaNames;
    private static final CmndProcess.Lookup ifccNames;
    private static final CmndProcess.Lookup epaNames;
    private final Output out = new ConsOut();
    private final CmndProcess proc = new CmndProcess();
    private final boolean debug;
    private UsbComm com;
    private ArrayList<Integer> openEps = new ArrayList();
    private ArrayList<UsbCommPipe> openPipes = new ArrayList();

    static {
        cmnd.add("find", 0, helpFind, "IIs", new CmndProcess.Lookup[0]);
        cmnd.add("open", 1, helpOpen, "II", new CmndProcess.Lookup[0]);
        cmnd.add("close", 2, helpClose, "I", new CmndProcess.Lookup[0]);
        cmnd.add("flush", 3, helpFlush, "I", new CmndProcess.Lookup[0]);
        cmnd.add("read", 4, helpRead, "IIf", new CmndProcess.Lookup[0]);
        cmnd.add("write", 5, helpWrite, "Issssssss", new CmndProcess.Lookup[0]);
        cmnd.add("rcntrl", 12, helpRcntrl, "IIIIIf", new CmndProcess.Lookup[0]);
        cmnd.add("wcntrl", 13, helpWcntrl, "IIIIssssssss", new CmndProcess.Lookup[0]);
        cmnd.add("claim", 16, helpClaim, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("release", 17, helpRelease, "I", new CmndProcess.Lookup[0]);
        cmnd.add("setcfg", 14, helpSetcfg, "I", new CmndProcess.Lookup[0]);
        cmnd.add("setif", 15, helpSetif, "II", new CmndProcess.Lookup[0]);
        cmnd.add("showdev", 6, helpShowdev, "i", new CmndProcess.Lookup[0]);
        cmnd.add("showcfg", 7, helpShowcfg, "ii", new CmndProcess.Lookup[0]);
        cmnd.add("showif", 8, helpShowif, "Iiii", new CmndProcess.Lookup[0]);
        cmnd.add("showep", 9, helpShowep, "IIiii", new CmndProcess.Lookup[0]);
        cmnd.add("showbus", 10, helpShowbus, "", new CmndProcess.Lookup[0]);
        cmnd.add("showopen", 11, helpShowopen, "", new CmndProcess.Lookup[0]);
        speedNames = new CmndProcess.Lookup(4);
        speedNames.add("Undefined", 0);
        speedNames.add("Low", 2);
        speedNames.add("Full", 3);
        speedNames.add("Unknown", 1);
        devcNames = new CmndProcess.Lookup(6);
        devcNames.add("See interface", 0);
        devcNames.add("Comm control", 2);
        devcNames.add("Hub", 9);
        devcNames.add("Diagnostic", 220);
        devcNames.add("Miscellaneous", 239);
        devcNames.add("Vendor spec", 255);
        cfgaNames = new CmndProcess.Lookup(2);
        cfgaNames.add("Self-powered", 64);
        cfgaNames.add("Remote wakeup", 32);
        ifccNames = new CmndProcess.Lookup(17);
        ifccNames.add("Audio", 1);
        ifccNames.add("Comm control", 2);
        ifccNames.add("Human intface", 3);
        ifccNames.add("Physical", 5);
        ifccNames.add("Still image", 6);
        ifccNames.add("Printer", 7);
        ifccNames.add("Mass storage", 8);
        ifccNames.add("Comm data", 10);
        ifccNames.add("Smart card", 11);
        ifccNames.add("Content secty", 13);
        ifccNames.add("Video", 14);
        ifccNames.add("Healthcare", 15);
        ifccNames.add("Diagnostic", 220);
        ifccNames.add("Wireless", 224);
        ifccNames.add("Miscellaneous", 239);
        ifccNames.add("App specific", 254);
        ifccNames.add("Vendor spec", 255);
        epaNames = new CmndProcess.Lookup(4);
        epaNames.add("Control", 0);
        epaNames.add("Isochronous", 1);
        epaNames.add("Bulk", 2);
        epaNames.add("Interrupt", 3);
    }

    public TestUsbComm(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) {
        new TestUsbComm(args.length > 0).run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            this.com = new UsbComm();
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (Exception e) {
            this.out.println((Object)e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 0: {
                    this.procFind(found, args);
                    break;
                }
                case 12: {
                    this.procRcntrl(found, args);
                    break;
                }
                case 13: {
                    this.procWcntrl(found, args);
                    break;
                }
                case 1: {
                    this.procOpen(found, args);
                    break;
                }
                case 2: {
                    this.procClose(found, args);
                    break;
                }
                case 3: {
                    this.procFlush(found, args);
                    break;
                }
                case 4: {
                    this.procRead(found, args);
                    break;
                }
                case 5: {
                    this.procWrite(found, args);
                    break;
                }
                case 16: {
                    this.procClaim(found, args);
                    break;
                }
                case 17: {
                    this.procRelease(found, args);
                    break;
                }
                case 14: {
                    this.procSetCfg(found, args);
                    break;
                }
                case 15: {
                    this.procSetIf(found, args);
                    break;
                }
                case 11: {
                    this.procShowOpen(found, args);
                    break;
                }
                case 10: {
                    this.procShowBus(found, args);
                    break;
                }
                case 6: {
                    this.procShowDev(found, args);
                    break;
                }
                case 7: {
                    this.procShowCfg(found, args);
                    break;
                }
                case 8: {
                    this.procShowIf(found, args);
                    break;
                }
                case 9: {
                    this.procShowEp(found, args);
                    break;
                }
                default: {
                    this.out.println((Object)"Command not fully implemented");
                    break;
                }
            }
        }
        catch (UsbException e) {
            this.out.println((Object)e.toString());
        }
        return true;
    }

    private void procFind(int found, Object[] args) throws UsbException {
        String serial;
        String string = serial = (found & 4) != 0 ? (String)args[2] : null;
        if (this.com.findDevice((int)((Integer)args[0]), (int)((Integer)args[1]), serial) == null) {
            this.out.println((Object)"Device not found");
        }
    }

    private void procRcntrl(int found, Object[] args) throws UsbException {
        float timeout = (found & 0x20) != 0 ? ((Float)args[5]).floatValue() : 1.0f;
        byte[] data = new byte[((Integer)args[4]).intValue()];
        int nRead = this.com.read((Integer)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3], data, (int)(1000.0f * timeout));
        this.dispData(data, nRead);
    }

    private void procWcntrl(int found, Object[] args) throws UsbException {
        byte[] data = this.genData(found & 0xFF0, args);
        if (data == null) {
            return;
        }
        int nWrite = this.com.write((Integer)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3], data);
        this.out.println((Object)(String.valueOf(nWrite) + " bytes written"));
    }

    private void procOpen(int found, Object[] args) throws UsbException {
        UsbCommPipe pipe = this.com.open((Integer)args[0], (Integer)args[1]);
        int pnum = this.openEps.size();
        int j = 0;
        while (j < pnum) {
            int ep = this.openEps.get(j);
            if (ep < 0) {
                pnum = j;
                break;
            }
            ++j;
        }
        if (pnum < this.openEps.size()) {
            this.openEps.set(pnum, (Integer)args[1]);
            this.openPipes.set(pnum, pipe);
        } else {
            this.openEps.add((Integer)args[1]);
            this.openPipes.add(pipe);
        }
        this.out.println((Object)("Pipe number = " + pnum));
    }

    private void procClose(int found, Object[] args) throws UsbException {
        int pnum = (Integer)args[0];
        if (pnum >= this.openEps.size()) {
            this.out.println((Object)"Invalid pipe number");
        } else {
            UsbCommPipe pipe = this.openPipes.get(pnum);
            this.openPipes.set(pnum, null);
            this.openEps.set(pnum, -1);
            pipe.close();
        }
    }

    private void procFlush(int found, Object[] args) throws UsbException {
        int pnum = (Integer)args[0];
        if (pnum >= this.openEps.size()) {
            this.out.println((Object)"Invalid pipe number");
        } else {
            UsbCommPipe pipe = this.openPipes.get(pnum);
            this.out.println((Object)(String.valueOf(pipe.flush()) + " bytes flushed"));
        }
    }

    private void procRead(int found, Object[] args) throws UsbException {
        int pnum = (Integer)args[0];
        int count = (Integer)args[1];
        float timeout = 1.0f;
        if ((found & 4) != 0) {
            timeout = ((Float)args[2]).floatValue();
        }
        if (pnum >= this.openEps.size()) {
            this.out.println((Object)"Invalid pipe number");
        } else {
            UsbCommPipe pipe = this.openPipes.get(pnum);
            byte[] data = new byte[count];
            int nRead = pipe.read(data, (int)(1000.0f * timeout));
            this.dispData(data, nRead);
        }
    }

    private void procWrite(int found, Object[] args) throws UsbException {
        int pnum = (Integer)args[0];
        byte[] data = this.genData(found & 0x1FE, args);
        if (data == null) {
            return;
        }
        if (pnum >= this.openEps.size()) {
            this.out.println((Object)"Invalid pipe number");
        } else {
            UsbCommPipe pipe = this.openPipes.get(pnum);
            this.out.println((Object)(String.valueOf(pipe.write(data)) + " bytes written"));
        }
    }

    private void procClaim(int found, Object[] args) throws UsbException {
        this.com.claim((Integer)args[0], (found & 2) != 0 && (Integer)args[1] != 0);
    }

    private void procRelease(int found, Object[] args) throws UsbException {
        this.com.release((Integer)args[0]);
    }

    private void procSetCfg(int found, Object[] args) throws UsbException {
        this.com.setConfiguration((Integer)args[0]);
    }

    private void procSetIf(int found, Object[] args) throws UsbException {
        this.com.setInterface((Integer)args[0], (Integer)args[1]);
    }

    private void procShowOpen(int found, Object[] args) throws UsbException {
        int nOpen = 0;
        int j = 0;
        while (j < this.openEps.size()) {
            int epAddr = this.openEps.get(j);
            if (epAddr >= 0) {
                ++nOpen;
                this.out.format("Pipe %s: address 0x%02x (%s)\n", new Object[]{j, epAddr, (epAddr & 0x80) != 0 ? "in" : "out"});
            }
            ++j;
        }
        if (nOpen == 0) {
            this.out.println((Object)"No pipes open");
        }
    }

    private void procShowBus(int found, Object[] args) throws UsbException {
        List devs = UsbComm.findDevices(-1, -1, null);
        if (!devs.isEmpty()) {
            int j = 0;
            while (j < devs.size()) {
                UsbDevice dev = (UsbDevice)devs.get(j);
                if (j > 0) {
                    this.out.println();
                }
                this.out.println((Object)("Device " + j + ":"));
                this.showDevice(dev);
                ++j;
            }
        } else {
            this.out.println((Object)"No devices found");
        }
    }

    private void procShowDev(int found, Object[] args) throws UsbException {
        int devNum = (found & 1) != 0 ? (Integer)args[0] : -1;
        UsbDevice dev = this.getDevice(devNum);
        if (dev != null) {
            this.showDevice(dev);
        }
    }

    private void procShowCfg(int found, Object[] args) throws UsbException {
        int devNum = (found & 2) != 0 ? (Integer)args[1] : -1;
        UsbDevice dev = this.getDevice(devNum);
        if (dev == null) {
            return;
        }
        int cfgNum = (found & 1) != 0 ? (Integer)args[0] : -1;
        UsbConfiguration cfg = this.getConfiguration(dev, cfgNum);
        if (cfg == null) {
            return;
        }
        UsbConfigurationDescriptor desc = cfg.getUsbConfigurationDescriptor();
        this.out.format("ConfigNum (name) : %s (%s)\n", new Object[]{desc.bConfigurationValue(), cfg.getConfigurationString()});
        int attr = desc.bmAttributes() & 0xFF;
        String sAttr = "";
        int j = 0;
        while (j < cfgaNames.count()) {
            int code = cfgaNames.code(j);
            if ((attr & code) != 0) {
                if (!sAttr.equals("")) {
                    sAttr = String.valueOf(sAttr) + ", ";
                }
                sAttr = String.valueOf(sAttr) + cfgaNames.name(j);
            }
            ++j;
        }
        this.out.format("Attributes       : 0x%02x (%s)\n", new Object[]{attr, sAttr});
        this.out.format("Maximum power    : %s mA\n", new Object[]{2 * (desc.bMaxPower() & 0xFF)});
        this.out.println((Object)("Number interfaces: " + desc.bNumInterfaces()));
    }

    private void procShowIf(int found, Object[] args) throws UsbException {
        int devNum = (found & 8) != 0 ? (Integer)args[3] : -1;
        UsbDevice dev = this.getDevice(devNum);
        if (dev == null) {
            return;
        }
        int cfgNum = (found & 4) != 0 ? (Integer)args[2] : -1;
        UsbConfiguration cfg = this.getConfiguration(dev, cfgNum);
        if (cfg == null) {
            return;
        }
        int setNum = (found & 2) != 0 ? (Integer)args[1] : -1;
        UsbInterface ifc = this.getInterface(cfg, (Integer)args[0], setNum);
        if (ifc == null) {
            return;
        }
        UsbInterfaceDescriptor desc = ifc.getUsbInterfaceDescriptor();
        this.out.format("Interface no. (name): %s (%s)\n", new Object[]{desc.bInterfaceNumber(), ifc.getInterfaceString()});
        this.out.println((Object)("Setting number      : " + desc.bAlternateSetting()));
        this.out.println((Object)("Active setting no.  : " + ifc.getActiveSettingNumber()));
        this.out.println((Object)("Number of settings  : " + ifc.getNumSettings()));
        int cls = desc.bInterfaceClass() & 0xFF;
        this.out.format("Interface class     : %s (%s)\n", new Object[]{cls, ifccNames.decode(cls)});
        this.out.println((Object)("Interface subclass  : " + (desc.bInterfaceSubClass() & 0xFF)));
        this.out.println((Object)("Interface protocol  : " + (desc.bInterfaceProtocol() & 0xFF)));
        this.out.println((Object)("Number of endpoints : " + desc.bNumEndpoints()));
        this.out.print((Object)"Endpoint addressess :");
        List eps = ifc.getUsbEndpoints();
        int j = 0;
        while (j < eps.size()) {
            UsbEndpoint ep = (UsbEndpoint)eps.get(j);
            UsbEndpointDescriptor epDesc = ep.getUsbEndpointDescriptor();
            this.out.format(" 0x%02x", new Object[]{epDesc.bEndpointAddress()});
            ++j;
        }
        this.out.println();
    }

    private void procShowEp(int found, Object[] args) throws UsbException {
        int devNum = (found & 0x10) != 0 ? (Integer)args[4] : -1;
        UsbDevice dev = this.getDevice(devNum);
        if (dev == null) {
            return;
        }
        int cfgNum = (found & 8) != 0 ? (Integer)args[3] : -1;
        UsbConfiguration cfg = this.getConfiguration(dev, cfgNum);
        if (cfg == null) {
            return;
        }
        int setNum = (found & 4) != 0 ? (Integer)args[2] : -1;
        UsbInterface ifc = this.getInterface(cfg, (Integer)args[1], setNum);
        if (ifc == null) {
            return;
        }
        UsbEndpoint ep = ifc.getUsbEndpoint((byte)((Integer)args[0]).intValue());
        if (ep == null) {
            this.out.println((Object)"Endpoint not found");
            return;
        }
        UsbEndpointDescriptor desc = ep.getUsbEndpointDescriptor();
        this.out.format("Address          : 0x%02x\n", new Object[]{desc.bEndpointAddress()});
        int attr = desc.bmAttributes() & 0xFF;
        this.out.format("Attributes       : 0x%02x (%s)\n", new Object[]{attr, epaNames.decode(attr & 3)});
        this.out.format("Interval         : %s msec\n", new Object[]{desc.bInterval()});
        this.out.println((Object)("Maxm packet size : " + desc.wMaxPacketSize()));
    }

    private UsbDevice getDevice(int index) throws UsbException {
        if (index < 0) {
            UsbDevice dev = this.com.getDevice();
            if (dev == null) {
                this.out.println((Object)"No device active");
            }
            return dev;
        }
        List devs = UsbComm.findDevices(-1, -1, null);
        if (index < devs.size()) {
            return (UsbDevice)devs.get(index);
        }
        this.out.println((Object)"Device not found");
        return null;
    }

    private UsbConfiguration getConfiguration(UsbDevice dev, int cfgNum) {
        UsbConfiguration cfg;
        if (cfgNum < 0) {
            cfg = dev.getActiveUsbConfiguration();
            if (cfg == null) {
                this.out.println((Object)"No configuration active");
            }
        } else {
            cfg = dev.getUsbConfiguration((byte)cfgNum);
            if (cfg == null) {
                this.out.println((Object)"Configuration not found");
            }
        }
        return cfg;
    }

    private UsbInterface getInterface(UsbConfiguration cfg, int ifNum, int setNum) throws UsbException {
        UsbInterface ifc = cfg.getUsbInterface((byte)ifNum);
        if (ifc != null) {
            ifc = setNum < 0 ? ifc.getActiveSetting() : ifc.getSetting((byte)setNum);
        }
        if (ifc == null) {
            this.out.println((Object)"Interface not found");
        }
        return ifc;
    }

    private void dispData(byte[] data, int count) {
        String cnt = String.valueOf(count) + " bytes read";
        String pad = String.format("%24s", "").substring(0, cnt.length() + 1);
        this.out.print((Object)cnt);
        int j = 0;
        while (j < count) {
            if ((j & 0xF) == 0) {
                if (j == 0) {
                    this.out.print((Object)":");
                } else {
                    this.out.println();
                    this.out.print((Object)pad);
                }
            }
            this.out.format(" %02x", new Object[]{data[j] & 0xFF});
            ++j;
        }
        this.out.println();
    }

    private byte[] genData(int found, Object[] args) {
        int k;
        byte[] sData;
        int count = 0;
        int mask = found;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int j = 0;
        while (found != 0) {
            if ((found & 1) != 0) {
                String hex = (String)args[j];
                int leng = hex.length();
                if ((leng & 1) != 0) break;
                sData = new byte[leng / 2];
                try {
                    k = 0;
                    while (k < leng) {
                        String num = hex.substring(k, k + 2);
                        sData[k / 2] = (byte)Integer.parseInt(num, 16);
                        k += 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                count += leng / 2;
                list.add(sData);
                mask ^= 1 << j;
            }
            found >>= 1;
            ++j;
        }
        if (mask != 0) {
            this.out.println((Object)"Invalid hexadecimal string");
            return null;
        }
        byte[] data = new byte[count];
        int l = 0;
        int j2 = 0;
        while (j2 < list.size()) {
            sData = (byte[])list.get(j2);
            k = 0;
            while (k < sData.length) {
                data[l++] = sData[k];
                ++k;
            }
            ++j2;
        }
        return data;
    }

    private void showDevice(UsbDevice dev) throws UsbException {
        UsbDeviceDescriptor desc = dev.getUsbDeviceDescriptor();
        this.out.format("Vendor ID (name)    : 0x%04x (%s)\n", new Object[]{desc.idVendor(), dev.getManufacturerString()});
        this.out.format("Product ID (name)   : 0x%04x (%s)\n", new Object[]{desc.idProduct(), dev.getProductString()});
        this.out.println((Object)("Serial number       : " + dev.getSerialNumberString()));
        this.out.println((Object)("Device speed        : " + speedNames.decode(UsbComm.getSpeed(dev))));
        int cls = desc.bDeviceClass() & 0xFF;
        this.out.format("Device class        : %s (%s)\n", new Object[]{cls, devcNames.decode(cls)});
        this.out.println((Object)("Device subclass     : " + (desc.bDeviceSubClass() & 0xFF)));
        this.out.println((Object)("Device protocol     : " + (desc.bDeviceProtocol() & 0xFF)));
        this.out.format("USB release         : %04x\n", new Object[]{desc.bcdUSB()});
        this.out.println((Object)("Number of configs   : " + desc.bNumConfigurations()));
        this.out.println((Object)("Active config number: " + dev.getActiveUsbConfigurationNumber()));
        this.out.println((Object)("Maximum packet size : " + (desc.bMaxPacketSize0() & 0xFF)));
    }
}

