/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConfigurationDescriptor;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfaceDescriptor;
import jline.ConsoleReader;
import org.lsst.ccs.drivers.usb.UsbComm;
import org.lsst.ccs.drivers.usb.UsbCommPipe;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestUsbComm
implements CmndProc.Dispatch {
    private static final int CMD_FIND = 0;
    private static final int CMD_OPEN = 1;
    private static final int CMD_CLOSE = 2;
    private static final int CMD_FLUSH = 3;
    private static final int CMD_READ = 4;
    private static final int CMD_WRITE = 5;
    private static final int CMD_SHOWDEV = 6;
    private static final int CMD_SHOWCFG = 7;
    private static final int CMD_SHOWIF = 8;
    private static final int CMD_SHOWEP = 9;
    private static final int CMD_SHOWBUS = 10;
    private static final int CMD_SHOWOPEN = 11;
    private static final int CMD_RCNTRL = 12;
    private static final int CMD_WCNTRL = 13;
    private static final int CMD_SETCFG = 14;
    private static final int CMD_SETIF = 15;
    private static final int CMD_CLAIM = 16;
    private static final int CMD_RELEASE = 17;
    private static final int NUM_CMDS = 18;
    private static final String[] helpFind = new String[]{"Find a device", "find <vendId> <devId> [<serial>]", "vendId  The vendor ID of the device", "devId   The device ID of the device", "serial  The serial number of the device (default any)"};
    private static final String[] helpOpen = new String[]{"Open a pipe to a device endpoint", "open <iface> <epaddr>", "iface   The number of the interface to use", "epaddr  The address of the endpoint to open"};
    private static final String[] helpClose = new String[]{"Close a pipe", "close <pipe>", "pipe  The number of the pipe (reported at open time) to close"};
    private static final String[] helpFlush = new String[]{"Flush any unread data from an input pipe", "flush <pipe>", "pipe  The number of the pipe (reported at open time) to flush"};
    private static final String[] helpRead = new String[]{"Read data from an input pipe and display it", "read <pipe> <count> [<timeout>]", "pipe     The number of the pipe (reported at open time) to read from", "count    The number of bytes to read", "timeout  The timeout in seconds (default 1)"};
    private static final String[] helpWrite = new String[]{"Write data to an output pipe", "write <pipe> [<data1>]... [<datan>]", "pipe   The number of the pipe (reported at open time) to write to", "datan  Up to 8 hexadecimal strings"};
    private static final String[] helpRcntrl = new String[]{"Read data from the control endpoint and display it", "rcntrl  <type> <rqst> <value> <index> <count> [<timeout>]", "type     The request type", "rqst     The request", "value    The associated value", "index    The associated index", "count    The number of bytes to read", "timeout  The timeout in seconds (default 1)"};
    private static final String[] helpWcntrl = new String[]{"Write data to the control endpoint", "wcntrl <type> <rqst> <value> <index> [<data1>]... [<datan>]", "type   The request type", "rqst   The request", "value  The associated value", "index  The associated index", "datan  Up to 8 hexadecimal strings"};
    private static final String[] helpClaim = new String[]{"Claim an interface", "claim <iface> [<force>]", "iface  The interface number", "force  If present and non-zero, force the claim"};
    private static final String[] helpRelease = new String[]{"Release an interface", "release <iface>", "iface  The interface number"};
    private static final String[] helpSetcfg = new String[]{"Set the current configuration", "setcfg <number>", "number  The number of the configuration to set"};
    private static final String[] helpSetif = new String[]{"Set the alternate setting for an interface", "setif <iface> <altnum>", "iface   The interface number", "altnum  The alternate setting number"};
    private static final String[] helpShowopen = new String[]{"Show all the open pipes", "showopen"};
    private static final String[] helpShowbus = new String[]{"Show all devices on the USB bus", "showbus"};
    private static final String[] helpShowdev = new String[]{"Show device information", "showdev [<devnum>]", "devnum  Device number from showbus list (default: current device)"};
    private static final String[] helpShowcfg = new String[]{"Show configuration information", "showcfg [<cfgnum>] [<devnum>]", "cfgnum  Configuration number (default: active configuration)", "devnum  Device number from showbus list (default: current device)"};
    private static final String[] helpShowif = new String[]{"Show interface information", "showif <iface> [<altnum>] [<cfgnum>] [<devnum>]", "iface   The interface number", "altnum  The alternate setting number (default: active one)", "cfgnum  Configuration number (default: active configuration)", "devnum  Device number from showbus list (default: current device)"};
    private static final String[] helpShowep = new String[]{"Show endpoint information", "showep <epaddr> <iface> [<altnum>] [<cfgnum>] [<devnum>]", "epaddr  The endpoint address", "iface   The interface number", "altnum  The alternate setting number (default: active one)", "cfgnum  Configuration number (default: active configuration)", "devnum  Device number from showbus list (default: current device)"};
    private static final CmndProc.Command cmnd = new CmndProc.Command(18);
    private static final CmndProc.Lookup speedNames;
    private static final CmndProc.Lookup devcNames;
    private static final CmndProc.Lookup cfgaNames;
    private static final CmndProc.Lookup ifccNames;
    private static final CmndProc.Lookup epaNames;
    private final Output out = new ConsOut();
    private final ConsoleReader reader = new ConsoleReader();
    private final CmndProc proc = new CmndProc();
    private final UsbComm com = new UsbComm();
    private final boolean debug;
    private ArrayList<Integer> openEps = new ArrayList();
    private ArrayList<UsbCommPipe> openPipes = new ArrayList();

    static {
        cmnd.add("find", 0, helpFind);
        cmnd.add("open", 1, helpOpen);
        cmnd.add("close", 2, helpClose);
        cmnd.add("flush", 3, helpFlush);
        cmnd.add("read", 4, helpRead);
        cmnd.add("write", 5, helpWrite);
        cmnd.add("rcntrl", 12, helpRcntrl);
        cmnd.add("wcntrl", 13, helpWcntrl);
        cmnd.add("claim", 16, helpClaim);
        cmnd.add("release", 17, helpRelease);
        cmnd.add("setcfg", 14, helpSetcfg);
        cmnd.add("setif", 15, helpSetif);
        cmnd.add("showdev", 6, helpShowdev);
        cmnd.add("showcfg", 7, helpShowcfg);
        cmnd.add("showif", 8, helpShowif);
        cmnd.add("showep", 9, helpShowep);
        cmnd.add("showbus", 10, helpShowbus);
        cmnd.add("showopen", 11, helpShowopen);
        speedNames = new CmndProc.Lookup(4);
        speedNames.add("Undefined", 0);
        speedNames.add("Low", 2);
        speedNames.add("Full", 3);
        speedNames.add("Unknown", 1);
        devcNames = new CmndProc.Lookup(6);
        devcNames.add("See interface", 0);
        devcNames.add("Comm control", 2);
        devcNames.add("Hub", 9);
        devcNames.add("Diagnostic", 220);
        devcNames.add("Miscellaneous", 239);
        devcNames.add("Vendor spec", 255);
        cfgaNames = new CmndProc.Lookup(2);
        cfgaNames.add("Self-powered", 64);
        cfgaNames.add("Remote wakeup", 32);
        ifccNames = new CmndProc.Lookup(17);
        ifccNames.add("Audio", 1);
        ifccNames.add("Comm control", 2);
        ifccNames.add("Human intface", 3);
        ifccNames.add("Physical", 5);
        ifccNames.add("Still image", 6);
        ifccNames.add("Printer", 7);
        ifccNames.add("Mass storage", 8);
        ifccNames.add("Comm data", 10);
        ifccNames.add("Smart card", 11);
        ifccNames.add("Content secty", 13);
        ifccNames.add("Video", 14);
        ifccNames.add("Healthcare", 15);
        ifccNames.add("Diagnostic", 220);
        ifccNames.add("Wireless", 224);
        ifccNames.add("Miscellaneous", 239);
        ifccNames.add("App specific", 254);
        ifccNames.add("Vendor spec", 255);
        epaNames = new CmndProc.Lookup(4);
        epaNames.add("Control", 0);
        epaNames.add("Isochronous", 1);
        epaNames.add("Bulk", 2);
        epaNames.add("Interrupt", 3);
    }

    public TestUsbComm(boolean dbg) throws UsbException, IOException {
        this.debug = dbg;
        this.proc.add((CmndProc.Dispatch)this, cmnd);
    }

    public static void main(String[] args) {
        try {
            TestUsbComm tcom = new TestUsbComm(args.length > 0);
            tcom.run();
        }
        catch (UsbException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        while ((line = this.reader.readLine(">> ")) != null) {
            try {
                if (this.proc.process(line)) continue;
                break;
            }
            catch (RuntimeException e) {
                if (this.debug) {
                    e.printStackTrace(System.out);
                    continue;
                }
                this.out.println((Object)e);
            }
        }
    }

    public boolean dispatch(int code, Scanner scan) {
        try {
            return this.dispatchCmnd(code, scan);
        }
        catch (UsbException e) {
            this.out.println((Object)e.toString());
            return true;
        }
    }

    private boolean dispatchCmnd(int code, Scanner scan) throws UsbException {
        Object[] args = new Object[16];
        switch (code) {
            case 0: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIs", (Object[])args);
                if (found < 0) break;
                String serial = null;
                if ((found & 4) != 0) {
                    serial = (String)args[2];
                }
                if (this.com.findDevice((int)((Integer)args[0]), (int)((Integer)args[1]), serial) != null) break;
                this.out.println((Object)"Device not found");
                break;
            }
            case 12: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIIIIf", (Object[])args);
                if (found < 0) break;
                float timeout = (found & 0x20) != 0 ? ((Float)args[5]).floatValue() : 1.0f;
                byte[] data = new byte[((Integer)args[4]).intValue()];
                int nRead = this.com.read((Integer)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3], data, (int)(1000.0f * timeout));
                this.dispData(data, nRead);
                break;
            }
            case 13: {
                byte[] data;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIIIssssssss", (Object[])args);
                if (found < 0 || (data = this.genData(found & 0xFF0, args)) == null) break;
                int nWrite = this.com.write((Integer)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3], data);
                this.out.println((Object)(String.valueOf(nWrite) + " bytes written"));
                break;
            }
            case 1: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"II", (Object[])args) < 0) break;
                UsbCommPipe pipe = this.com.open((Integer)args[0], (Integer)args[1]);
                int pnum = this.openEps.size();
                int j = 0;
                while (j < pnum) {
                    int ep = this.openEps.get(j);
                    if (ep < 0) {
                        pnum = j;
                        break;
                    }
                    ++j;
                }
                if (pnum < this.openEps.size()) {
                    this.openEps.set(pnum, (Integer)args[1]);
                    this.openPipes.set(pnum, pipe);
                } else {
                    this.openEps.add((Integer)args[1]);
                    this.openPipes.add(pipe);
                }
                this.out.println((Object)("Pipe number = " + pnum));
                break;
            }
            case 2: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args) < 0) break;
                int pnum = (Integer)args[0];
                if (pnum >= this.openEps.size()) {
                    this.out.println((Object)"Invalid pipe number");
                    break;
                }
                UsbCommPipe pipe = this.openPipes.get(pnum);
                this.openPipes.set(pnum, null);
                this.openEps.set(pnum, -1);
                pipe.close();
                break;
            }
            case 3: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args) < 0) break;
                int pnum = (Integer)args[0];
                if (pnum >= this.openEps.size()) {
                    this.out.println((Object)"Invalid pipe number");
                    break;
                }
                UsbCommPipe pipe = this.openPipes.get(pnum);
                this.out.println((Object)(String.valueOf(pipe.flush()) + " bytes flushed"));
                break;
            }
            case 4: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIf", (Object[])args);
                if (found < 0) break;
                int pnum = (Integer)args[0];
                int count = (Integer)args[1];
                float timeout = 1.0f;
                if ((found & 4) != 0) {
                    timeout = ((Float)args[2]).floatValue();
                }
                if (pnum >= this.openEps.size()) {
                    this.out.println((Object)"Invalid pipe number");
                    break;
                }
                UsbCommPipe pipe = this.openPipes.get(pnum);
                byte[] data = new byte[count];
                int nRead = pipe.read(data, (int)(1000.0f * timeout));
                this.dispData(data, nRead);
                break;
            }
            case 5: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Issssssss", (Object[])args);
                if (found < 0) break;
                int pnum = (Integer)args[0];
                byte[] data = this.genData(found & 0x1FE, args);
                if (data == null) break;
                if (pnum >= this.openEps.size()) {
                    this.out.println((Object)"Invalid pipe number");
                    break;
                }
                UsbCommPipe pipe = this.openPipes.get(pnum);
                this.out.println((Object)(String.valueOf(pipe.write(data)) + " bytes written"));
                break;
            }
            case 16: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.com.claim((Integer)args[0], (found & 2) != 0 && (Integer)args[1] != 0);
                break;
            }
            case 17: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args) < 0) break;
                this.com.release((Integer)args[0]);
                break;
            }
            case 14: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args) < 0) break;
                this.com.setConfiguration((Integer)args[0]);
                break;
            }
            case 15: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"II", (Object[])args) < 0) break;
                this.com.setInterface((Integer)args[0], (Integer)args[1]);
                break;
            }
            case 11: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args) < 0) break;
                int nOpen = 0;
                int j = 0;
                while (j < this.openEps.size()) {
                    int epAddr = this.openEps.get(j);
                    if (epAddr >= 0) {
                        ++nOpen;
                        this.out.format("Pipe %s: address 0x%02x (%s)\n", new Object[]{j, epAddr, (epAddr & 0x80) != 0 ? "in" : "out"});
                    }
                    ++j;
                }
                if (nOpen != 0) break;
                this.out.println((Object)"No pipes open");
                break;
            }
            case 10: {
                if (CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args) < 0) break;
                List devs = UsbComm.findDevices(-1, -1, null);
                if (!devs.isEmpty()) {
                    int j = 0;
                    while (j < devs.size()) {
                        UsbDevice dev = (UsbDevice)devs.get(j);
                        if (j > 0) {
                            this.out.println();
                        }
                        this.out.println((Object)("Device " + j + ":"));
                        this.showDevice(dev);
                        ++j;
                    }
                    break;
                }
                this.out.println((Object)"No devices found");
                break;
            }
            case 6: {
                int devNum;
                UsbDevice dev;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0 || (dev = this.getDevice(devNum = (found & 1) != 0 ? (Integer)args[0] : -1)) == null) break;
                this.showDevice(dev);
                break;
            }
            case 7: {
                int cfgNum;
                UsbConfiguration cfg;
                int devNum;
                UsbDevice dev;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0 || (dev = this.getDevice(devNum = (found & 2) != 0 ? (Integer)args[1] : -1)) == null || (cfg = this.getConfiguration(dev, cfgNum = (found & 1) != 0 ? (Integer)args[0] : -1)) == null) break;
                this.showConfiguration(cfg);
                break;
            }
            case 8: {
                int cfgNum;
                UsbConfiguration cfg;
                int devNum;
                UsbDevice dev;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Iiii", (Object[])args);
                if (found < 0 || (dev = this.getDevice(devNum = (found & 8) != 0 ? (Integer)args[3] : -1)) == null || (cfg = this.getConfiguration(dev, cfgNum = (found & 4) != 0 ? (Integer)args[2] : -1)) == null) break;
                int setNum = (found & 2) != 0 ? (Integer)args[1] : -1;
                UsbInterface ifc = this.getInterface(cfg, (Integer)args[0], setNum);
                if (ifc == null) break;
                this.showInterface(ifc);
                break;
            }
            case 9: {
                int cfgNum;
                UsbConfiguration cfg;
                int devNum;
                UsbDevice dev;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIiii", (Object[])args);
                if (found < 0 || (dev = this.getDevice(devNum = (found & 0x10) != 0 ? (Integer)args[4] : -1)) == null || (cfg = this.getConfiguration(dev, cfgNum = (found & 8) != 0 ? (Integer)args[3] : -1)) == null) break;
                int setNum = (found & 4) != 0 ? (Integer)args[2] : -1;
                UsbInterface ifc = this.getInterface(cfg, (Integer)args[1], setNum);
                if (ifc == null) break;
                UsbEndpoint ep = ifc.getUsbEndpoint((byte)((Integer)args[0]).intValue());
                if (ep != null) {
                    this.showEndpoint(ep);
                    break;
                }
                this.out.println((Object)"Endpoint not found");
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private UsbDevice getDevice(int index) throws UsbException {
        if (index < 0) {
            UsbDevice dev = this.com.getDevice();
            if (dev == null) {
                this.out.println((Object)"No device active");
            }
            return dev;
        }
        List devs = UsbComm.findDevices(-1, -1, null);
        if (index < devs.size()) {
            return (UsbDevice)devs.get(index);
        }
        this.out.println((Object)"Device not found");
        return null;
    }

    private UsbConfiguration getConfiguration(UsbDevice dev, int cfgNum) {
        UsbConfiguration cfg;
        if (cfgNum < 0) {
            cfg = dev.getActiveUsbConfiguration();
            if (cfg == null) {
                this.out.println((Object)"No configuration active");
            }
        } else {
            cfg = dev.getUsbConfiguration((byte)cfgNum);
            if (cfg == null) {
                this.out.println((Object)"Configuration not found");
            }
        }
        return cfg;
    }

    private UsbInterface getInterface(UsbConfiguration cfg, int ifNum, int setNum) throws UsbException {
        UsbInterface ifc = cfg.getUsbInterface((byte)ifNum);
        if (ifc != null) {
            ifc = setNum < 0 ? ifc.getActiveSetting() : ifc.getSetting((byte)setNum);
        }
        if (ifc == null) {
            this.out.println((Object)"Interface not found");
        }
        return ifc;
    }

    private void dispData(byte[] data, int count) {
        String cnt = String.valueOf(count) + " bytes read";
        String pad = String.format("%24s", "").substring(0, cnt.length() + 1);
        this.out.print((Object)cnt);
        int j = 0;
        while (j < count) {
            if ((j & 0xF) == 0) {
                if (j == 0) {
                    this.out.print((Object)":");
                } else {
                    this.out.println();
                    this.out.print((Object)pad);
                }
            }
            this.out.format(" %02x", new Object[]{data[j] & 0xFF});
            ++j;
        }
        this.out.println();
    }

    private byte[] genData(int found, Object[] args) {
        int k;
        byte[] sData;
        int count = 0;
        int mask = found;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int j = 0;
        while (found != 0) {
            if ((found & 1) != 0) {
                String hex = (String)args[j];
                int leng = hex.length();
                if ((leng & 1) != 0) break;
                sData = new byte[leng / 2];
                try {
                    k = 0;
                    while (k < leng) {
                        String num = hex.substring(k, k + 2);
                        sData[k / 2] = (byte)Integer.parseInt(num, 16);
                        k += 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                count += leng / 2;
                list.add(sData);
                mask ^= 1 << j;
            }
            found >>= 1;
            ++j;
        }
        if (mask != 0) {
            this.out.println((Object)"Invalid hexadecimal string");
            return null;
        }
        byte[] data = new byte[count];
        int l = 0;
        int j2 = 0;
        while (j2 < list.size()) {
            sData = (byte[])list.get(j2);
            k = 0;
            while (k < sData.length) {
                data[l++] = sData[k];
                ++k;
            }
            ++j2;
        }
        return data;
    }

    private void showDevice(UsbDevice dev) throws UsbException {
        UsbDeviceDescriptor desc = dev.getUsbDeviceDescriptor();
        this.out.format("Vendor ID (name)    : 0x%04x (%s)\n", new Object[]{desc.idVendor(), dev.getManufacturerString()});
        this.out.format("Product ID (name)   : 0x%04x (%s)\n", new Object[]{desc.idProduct(), dev.getProductString()});
        this.out.println((Object)("Serial number       : " + dev.getSerialNumberString()));
        this.out.println((Object)("Device speed        : " + speedNames.decode(UsbComm.getSpeed(dev))));
        int cls = desc.bDeviceClass() & 0xFF;
        this.out.format("Device class        : %s (%s)\n", new Object[]{cls, devcNames.decode(cls)});
        this.out.println((Object)("Device subclass     : " + (desc.bDeviceSubClass() & 0xFF)));
        this.out.println((Object)("Device protocol     : " + (desc.bDeviceProtocol() & 0xFF)));
        this.out.format("USB release         : %04x\n", new Object[]{desc.bcdUSB()});
        this.out.println((Object)("Number of configs   : " + desc.bNumConfigurations()));
        this.out.println((Object)("Active config number: " + dev.getActiveUsbConfigurationNumber()));
        this.out.println((Object)("Maximum packet size : " + (desc.bMaxPacketSize0() & 0xFF)));
    }

    private void showConfiguration(UsbConfiguration cfg) throws UsbException {
        UsbConfigurationDescriptor desc = cfg.getUsbConfigurationDescriptor();
        this.out.format("ConfigNum (name) : %s (%s)\n", new Object[]{desc.bConfigurationValue(), cfg.getConfigurationString()});
        int attr = desc.bmAttributes() & 0xFF;
        String sAttr = "";
        int j = 0;
        while (j < cfgaNames.count()) {
            int code = cfgaNames.code(j);
            if ((attr & code) != 0) {
                if (!sAttr.equals("")) {
                    sAttr = String.valueOf(sAttr) + ", ";
                }
                sAttr = String.valueOf(sAttr) + cfgaNames.name(j);
            }
            ++j;
        }
        this.out.format("Attributes       : 0x%02x (%s)\n", new Object[]{attr, sAttr});
        this.out.format("Maximum power    : %s mA\n", new Object[]{2 * (desc.bMaxPower() & 0xFF)});
        this.out.println((Object)("Number interfaces: " + desc.bNumInterfaces()));
    }

    private void showInterface(UsbInterface ifc) throws UsbException {
        UsbInterfaceDescriptor desc = ifc.getUsbInterfaceDescriptor();
        this.out.format("Interface no. (name): %s (%s)\n", new Object[]{desc.bInterfaceNumber(), ifc.getInterfaceString()});
        this.out.println((Object)("Setting number      : " + desc.bAlternateSetting()));
        this.out.println((Object)("Active setting no.  : " + ifc.getActiveSettingNumber()));
        this.out.println((Object)("Number of settings  : " + ifc.getNumSettings()));
        int cls = desc.bInterfaceClass() & 0xFF;
        this.out.format("Interface class     : %s (%s)\n", new Object[]{cls, ifccNames.decode(cls)});
        this.out.println((Object)("Interface subclass  : " + (desc.bInterfaceSubClass() & 0xFF)));
        this.out.println((Object)("Interface protocol  : " + (desc.bInterfaceProtocol() & 0xFF)));
        this.out.println((Object)("Number of endpoints : " + desc.bNumEndpoints()));
        this.out.print((Object)"Endpoint addressess :");
        List eps = ifc.getUsbEndpoints();
        int j = 0;
        while (j < eps.size()) {
            UsbEndpoint ep = (UsbEndpoint)eps.get(j);
            UsbEndpointDescriptor epDesc = ep.getUsbEndpointDescriptor();
            this.out.format(" 0x%02x", new Object[]{epDesc.bEndpointAddress()});
            ++j;
        }
        this.out.println();
    }

    private void showEndpoint(UsbEndpoint ep) {
        UsbEndpointDescriptor desc = ep.getUsbEndpointDescriptor();
        this.out.format("Address          : 0x%02x\n", new Object[]{desc.bEndpointAddress()});
        int attr = desc.bmAttributes() & 0xFF;
        this.out.format("Attributes       : 0x%02x (%s)\n", new Object[]{attr, epaNames.decode(attr & 3)});
        this.out.format("Interval         : %s msec\n", new Object[]{desc.bInterval()});
        this.out.println((Object)("Maxm packet size : " + desc.wMaxPacketSize()));
    }
}

