/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.examples;

import java.util.List;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfaceDescriptor;
import javax.usb.UsbPipe;
import javax.usb.examples.FindUsbInterface;
import javax.usb.examples.ShowTopology;
import javax.usb.util.UsbUtil;

public class MouseDriver {
    public static final byte HID_CLASS = 3;
    public static final byte HID_SUBCLASS_BOOT_INTERFACE = 1;
    public static final byte HID_PROTOCOL_MOUSE = 2;
    public static final short HID_MOUSE_USAGE_PAGE = 1281;
    public static final short HID_MOUSE_USAGE_ID = 2306;
    public static final byte HID_DESCRIPTOR_TYPE_REPORT = 34;
    public static final byte GET_REPORT_DESCRIPTOR_REQUESTTYPE = -127;
    public static final byte GET_REPORT_DESCRIPTOR_REQUEST = 6;
    public static final short GET_REPORT_DESCRIPTOR_VALUE = 8704;

    public static void main(String[] argv) {
        UsbHub virtualRootUsbHub = ShowTopology.getVirtualRootUsbHub();
        List usbInterfaces = FindUsbInterface.getUsbInterfacesWithInterfaceClass(virtualRootUsbHub, (byte)3);
        System.out.println("Found " + usbInterfaces.size() + " HID-type interfaces.");
        int i = 0;
        while (i < usbInterfaces.size()) {
            UsbInterface usbInterface = (UsbInterface)usbInterfaces.get(i);
            boolean isMouse = false;
            if (MouseDriver.checkUsbInterfaceIsMouse(usbInterface)) {
                System.out.println("Found mouse by SubClass/Protocol");
                isMouse = true;
            }
            if (MouseDriver.checkHidInterface(usbInterface, (short)1281, (short)2306)) {
                System.out.println("Found mouse by Usage Page/Usage ID");
                isMouse = true;
            }
            if (isMouse) {
                System.out.println("Found HID mouse.");
                MouseDriver.driveHidMouse(usbInterface);
            }
            ++i;
        }
    }

    public static void driveHidMouse(UsbInterface usbInterface) {
        try {
            usbInterface.claim();
        }
        catch (UsbException uE) {
            System.out.println("Could not claim interface to drive HID mouse : " + uE.getMessage());
            return;
        }
        List usbEndpoints = usbInterface.getUsbEndpoints();
        UsbEndpoint usbEndpoint = null;
        int i = 0;
        while (i < usbEndpoints.size()) {
            usbEndpoint = (UsbEndpoint)usbEndpoints.get(i);
            if (3 == usbEndpoint.getType() && -128 == usbEndpoint.getDirection()) break;
            usbEndpoint = null;
            ++i;
        }
        if (usbEndpoint == null) {
            System.out.println("This HID interface does not have the required interrupt-in endpoint.");
            return;
        }
        UsbPipe usbPipe = usbEndpoint.getUsbPipe();
        try {
            usbPipe.open();
        }
        catch (UsbException uE) {
            System.out.println("Could not open endpoint to communicate with HID mouse : " + uE.getMessage());
            try {
                usbInterface.release();
            }
            catch (UsbException usbException) {}
            return;
        }
        HidMouseRunnable hmR = new HidMouseRunnable(usbPipe);
        Thread t = new Thread(hmR);
        System.out.println("Driving HID mouse, move mouse to see movement events.");
        System.out.println("Press Enter when done.");
        t.start();
        try {
            System.in.read();
        }
        catch (Exception e) {
            System.out.println("Exception while waiting for Enter : " + e.getMessage());
        }
        hmR.stop();
        try {
            usbPipe.close();
            usbInterface.release();
        }
        catch (UsbException usbException) {}
        System.out.println("Done driving HID mouse.");
    }

    public static boolean checkUsbInterfaceIsMouse(UsbInterface usbInterface) {
        UsbInterfaceDescriptor desc = usbInterface.getUsbInterfaceDescriptor();
        return 1 == desc.bInterfaceSubClass() && 2 == desc.bInterfaceProtocol();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkHidInterface(UsbInterface usbInterface, short usagePage, short usageID) {
        block16: {
            try {
                usbInterface.claim();
            }
            catch (UsbException v0) {}
            usbDevice = usbInterface.getUsbConfiguration().getUsbDevice();
            bmRequestType = -127;
            bRequest = 6;
            wValue = 8704;
            wIndex = UsbUtil.unsignedShort(usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber());
            getUsageIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
            data = new byte[256];
            getUsageIrp.setData(data);
            usbDevice.syncSubmit(getUsageIrp);
            if (4 <= getUsageIrp.getActualLength()) break block16;
            while (true) {
                try {
                    usbInterface.release();
                }
                catch (UsbException v1) {}
                return false;
            }
        }
        if (UsbUtil.toInt(data[0], data[1], data[2], data[3]) != UsbUtil.toInt(usagePage, usageID)) ** continue;
        try {
            usbInterface.release();
        }
        catch (UsbException v2) {}
        return true;
        catch (UsbException v3) {
            try {}
            catch (Throwable var10_10) {
                try {
                    usbInterface.release();
                }
                catch (UsbException v4) {}
                throw var10_10;
            }
            try {
                usbInterface.release();
            }
            catch (UsbException v5) {}
            return false;
        }
    }

    public static class HidMouseRunnable
    implements Runnable {
        public boolean running = true;
        public UsbPipe usbPipe = null;

        public HidMouseRunnable(UsbPipe pipe) {
            this.usbPipe = pipe;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[UsbUtil.unsignedInt(this.usbPipe.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize())];
            int length = 0;
            while (this.running) {
                block4: {
                    try {
                        length = this.usbPipe.syncSubmit(buffer);
                    }
                    catch (UsbException uE) {
                        if (!this.running) break block4;
                        System.out.println("Unable to submit data buffer to HID mouse : " + uE.getMessage());
                        break;
                    }
                }
                if (!this.running) continue;
                System.out.print("Got " + length + " bytes of data from HID mouse :");
                int i = 0;
                while (i < length) {
                    System.out.print(" 0x" + UsbUtil.toHexString(buffer[i]));
                    ++i;
                }
                System.out.println("");
            }
        }

        public void stop() {
            this.running = false;
            this.usbPipe.abortAllSubmissions();
        }
    }
}

