/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbDescriptorImp;
import java.io.UnsupportedEncodingException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbStringDescriptor;

public class UsbStringDescriptorImp
extends UsbDescriptorImp
implements UsbStringDescriptor {
    private byte[] bString = null;
    private String string = null;
    public static final String[] ENCODING = new String[]{"UnicodeLittleUnmarked", "UnicodeLittle", "UTF-16LE"};
    public static final String ENCODING_8BIT = "ASCII";

    public UsbStringDescriptorImp(byte bLength, byte bDescriptorType, byte[] bString) {
        super(bLength, bDescriptorType);
        this.bString = bString;
    }

    @Override
    public byte[] bString() {
        try {
            byte[] bStringCopy = new byte[this.bString.length];
            System.arraycopy(this.bString, 0, bStringCopy, 0, this.bString.length);
            return bStringCopy;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public String getString() throws UsbEncodingException {
        if (this.string == null) {
            this.string = this.createString();
        }
        return this.string;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        UsbStringDescriptorImp desc = null;
        try {
            desc = (UsbStringDescriptorImp)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        try {
            if (this.getString() != desc.getString()) {
                return false;
            }
        }
        catch (UsbEncodingException usbEncodingException) {}
        return this.bString() == desc.bString();
    }

    private String createString() throws UsbEncodingException {
        if (this.bString() == null) {
            return null;
        }
        byte[] s16 = this.bString();
        int i = 0;
        while (i < ENCODING.length) {
            try {
                return new String(s16, 0, s16.length, ENCODING[i]);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ++i;
            }
        }
        byte[] s8 = new byte[s16.length / 2];
        int i8 = 0;
        int i16 = 0;
        while (i8 < s8.length && i16 + 1 < s16.length) {
            s8[i8] = s16[i16];
            if (s16[i16 + 1] != 0) {
                throw new UsbEncodingException("No 16-bit encoding available for 16-bit string");
            }
            ++i8;
            ++i16;
            ++i16;
        }
        try {
            return new String(s8, ENCODING_8BIT);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UsbEncodingException("8-bit encoding not available");
        }
    }
}

