/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.DefaultUsbInterfacePolicy;
import com.ibm.jusb.UsbConfigurationImp;
import com.ibm.jusb.UsbEndpointImp;
import com.ibm.jusb.os.DefaultUsbInterfaceOsImp;
import com.ibm.jusb.os.UsbInterfaceOsImp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.usb.UsbClaimException;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfaceDescriptor;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNotActiveException;
import javax.usb.util.UsbUtil;

public class UsbInterfaceImp
implements UsbInterface {
    private UsbConfigurationImp usbConfigurationImp = null;
    private UsbInterfaceOsImp usbInterfaceOsImp = new DefaultUsbInterfaceOsImp();
    private UsbInterfaceDescriptor usbInterfaceDescriptor = null;
    private List endpoints = new ArrayList();
    protected UsbInterfacePolicy usbClaimPolicy = null;
    protected UsbInterfacePolicy defaultUsbInterfacePolicy = new DefaultUsbInterfacePolicy();
    protected boolean disconnected = false;

    public UsbInterfaceImp(UsbConfigurationImp config, UsbInterfaceDescriptor desc) {
        this.setUsbInterfaceDescriptor(desc);
        this.setUsbConfigurationImp(config);
    }

    public UsbInterfaceImp(UsbConfigurationImp config, UsbInterfaceDescriptor desc, UsbInterfaceOsImp osImp) {
        this.setUsbInterfaceDescriptor(desc);
        this.setUsbConfigurationImp(config);
        this.setUsbInterfaceOsImp(osImp);
    }

    @Override
    public void claim() throws UsbClaimException, UsbException, UsbNotActiveException, UsbDisconnectedException {
        this.claim(this.defaultUsbInterfacePolicy);
    }

    @Override
    public synchronized void claim(UsbInterfacePolicy policy) throws UsbClaimException, UsbException, UsbNotActiveException, UsbDisconnectedException {
        this.checkDisconnected();
        this.checkSettingActive();
        if (this.isJavaClaimed()) {
            throw new UsbClaimException("UsbInterface is already claimed");
        }
        this.getUsbInterfaceOsImp().claim(policy);
        this.setClaimed(policy);
    }

    @Override
    public void release() throws UsbClaimException, UsbException, UsbNotActiveException, UsbDisconnectedException {
        this.checkDisconnected();
        this.checkSettingActive();
        if (!this.isJavaClaimed()) {
            throw new UsbClaimException("UsbInterface is not claimed");
        }
        int i = 0;
        while (i < this.endpoints.size()) {
            if (((UsbEndpoint)this.endpoints.get(i)).getUsbPipe().isOpen()) {
                throw new UsbException("Cannot release UsbInterface with any open UsbPipe");
            }
            ++i;
        }
        this.getUsbInterfaceOsImp().release();
        this.setClaimed(null);
    }

    @Override
    public boolean isClaimed() {
        try {
            this.checkSettingActive();
        }
        catch (UsbNotActiveException usbNotActiveException) {
            return false;
        }
        if (this.isJavaClaimed()) {
            return true;
        }
        return this.getUsbInterfaceOsImp().isClaimed();
    }

    public boolean isJavaClaimed() {
        try {
            this.checkSettingActive();
        }
        catch (UsbNotActiveException usbNotActiveException) {
            return false;
        }
        return this.hasUsbInterfacePolicy();
    }

    @Override
    public boolean isActive() {
        try {
            return this.getUsbInterfaceDescriptor().bAlternateSetting() == this.getActiveSettingNumber();
        }
        catch (UsbNotActiveException usbNotActiveException) {
            return false;
        }
    }

    @Override
    public List getUsbEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    @Override
    public UsbEndpoint getUsbEndpoint(byte address) {
        return this.getUsbEndpointImp(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbEndpointImp getUsbEndpointImp(byte address) {
        List list = this.endpoints;
        synchronized (list) {
            int i = 0;
            while (i < this.endpoints.size()) {
                UsbEndpointImp ep = (UsbEndpointImp)this.endpoints.get(i);
                if (address == ep.getUsbEndpointDescriptor().bEndpointAddress()) {
                    return ep;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean containsUsbEndpoint(byte address) {
        return this.getUsbEndpoint(address) != null;
    }

    @Override
    public UsbConfiguration getUsbConfiguration() {
        return this.getUsbConfigurationImp();
    }

    public UsbConfigurationImp getUsbConfigurationImp() {
        return this.usbConfigurationImp;
    }

    public void setUsbConfigurationImp(UsbConfigurationImp config) {
        this.usbConfigurationImp = config;
        if (config != null) {
            config.addUsbInterfaceImp(this);
        }
    }

    @Override
    public int getNumSettings() {
        return this.getSettings().size();
    }

    @Override
    public byte getActiveSettingNumber() throws UsbNotActiveException {
        this.checkActive();
        return ((UsbInterfaceImp)this.getUsbConfigurationImp().getUsbInterfaceSettingList(this.getUsbInterfaceDescriptor().bInterfaceNumber()).get(0)).getUsbInterfaceDescriptor().bAlternateSetting();
    }

    @Override
    public UsbInterface getActiveSetting() throws UsbNotActiveException {
        return this.getActiveSettingImp();
    }

    public UsbInterfaceImp getActiveSettingImp() throws UsbNotActiveException {
        return this.getSettingImp(this.getActiveSettingNumber());
    }

    @Override
    public UsbInterface getSetting(byte number) {
        return this.getSettingImp(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbInterfaceImp getSettingImp(byte number) {
        List list;
        List list2 = list = this.getUsbConfigurationImp().getUsbInterfaceSettingList(this.getUsbInterfaceDescriptor().bInterfaceNumber());
        synchronized (list2) {
            int i = 0;
            while (i < list.size()) {
                UsbInterfaceImp setting = (UsbInterfaceImp)list.get(i);
                if (number == setting.getUsbInterfaceDescriptor().bAlternateSetting()) {
                    return setting;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean containsSetting(byte number) {
        return this.getSetting(number) != null;
    }

    @Override
    public List getSettings() {
        return Collections.unmodifiableList(this.getUsbConfigurationImp().getUsbInterfaceSettingList(this.getUsbInterfaceDescriptor().bInterfaceNumber()));
    }

    @Override
    public UsbInterfaceDescriptor getUsbInterfaceDescriptor() {
        return this.usbInterfaceDescriptor;
    }

    @Override
    public String getInterfaceString() throws UsbException, UsbEncodingException, UsbDisconnectedException {
        return this.getUsbConfigurationImp().getUsbDeviceImp().getString(this.getUsbInterfaceDescriptor().iInterface());
    }

    public UsbInterfaceOsImp getUsbInterfaceOsImp() {
        return this.usbInterfaceOsImp;
    }

    public void setUsbInterfaceOsImp(UsbInterfaceOsImp iface) {
        this.usbInterfaceOsImp = iface == null ? new DefaultUsbInterfaceOsImp() : iface;
    }

    public void setUsbInterfaceDescriptor(UsbInterfaceDescriptor desc) {
        this.usbInterfaceDescriptor = desc;
    }

    public void setActiveSettingNumber(byte number) throws IllegalArgumentException {
        this.getUsbConfigurationImp().setActiveUsbInterfaceImpSetting(this.getSettingImp(number));
    }

    public void addUsbEndpointImp(UsbEndpointImp ep) {
        if (!this.endpoints.contains(ep)) {
            this.endpoints.add(ep);
        }
    }

    void disconnect() {
        Iterator i = this.getUsbEndpoints().iterator();
        while (i.hasNext()) {
            ((UsbEndpointImp)i.next()).disconnect();
        }
    }

    void checkDisconnected() throws UsbDisconnectedException {
        this.getUsbConfigurationImp().checkDisconnected();
    }

    boolean isDisconnected() {
        return this.getUsbConfigurationImp().isDisconnected();
    }

    protected UsbInterfacePolicy getUsbInterfacePolicy() {
        return this.usbClaimPolicy;
    }

    protected boolean hasUsbInterfacePolicy() {
        return this.usbClaimPolicy != null;
    }

    private void checkActive() throws UsbNotActiveException {
        if (!this.getUsbConfiguration().isActive()) {
            throw new UsbNotActiveException("Configuration " + this.getUsbConfiguration().getUsbConfigurationDescriptor().bConfigurationValue() + " is not active");
        }
    }

    private void checkSettingActive() throws UsbNotActiveException {
        this.checkActive();
        if (!this.isActive()) {
            String i = UsbUtil.toHexString(this.getUsbInterfaceDescriptor().bInterfaceNumber());
            String a = UsbUtil.toHexString(this.getUsbInterfaceDescriptor().bAlternateSetting());
            throw new UsbNotActiveException("UsbInterface 0x" + i + " setting 0x" + a + " is not active");
        }
    }

    private void setClaimed(UsbInterfacePolicy policy) {
        List list = this.getUsbConfigurationImp().getUsbInterfaceSettingList(this.getUsbInterfaceDescriptor().bInterfaceNumber());
        int i = 0;
        while (i < list.size()) {
            ((UsbInterfaceImp)list.get((int)i)).usbClaimPolicy = policy;
            ++i;
        }
    }
}

