/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbInterfaceImp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConfigurationDescriptor;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEncodingException;
import javax.usb.UsbException;
import javax.usb.UsbInterface;

public class UsbConfigurationImp
implements UsbConfiguration {
    private UsbDeviceImp usbDeviceImp = null;
    private UsbConfigurationDescriptor usbConfigurationDescriptor = null;
    private HashMap interfaces = new HashMap();

    public UsbConfigurationImp(UsbDeviceImp device, UsbConfigurationDescriptor desc) {
        this.setUsbDeviceImp(device);
        this.setUsbConfigurationDescriptor(desc);
    }

    @Override
    public boolean isActive() {
        return this.getUsbDevice().getActiveUsbConfigurationNumber() == this.getUsbConfigurationDescriptor().bConfigurationValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getUsbInterfaces() {
        HashMap hashMap = this.interfaces;
        synchronized (hashMap) {
            LinkedList list = new LinkedList();
            Iterator iterator = this.interfaces.values().iterator();
            while (iterator.hasNext()) {
                list.add(0, ((List)iterator.next()).get(0));
            }
            return Collections.unmodifiableList(list);
        }
    }

    @Override
    public UsbInterface getUsbInterface(byte number) {
        return this.getUsbInterfaceImp(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbInterfaceImp getUsbInterfaceImp(byte number) {
        HashMap hashMap = this.interfaces;
        synchronized (hashMap) {
            String key;
            block4: {
                key = new Byte(number).toString();
                if (this.interfaces.containsKey(key)) break block4;
                return null;
            }
            return (UsbInterfaceImp)((List)this.interfaces.get(key)).get(0);
        }
    }

    @Override
    public boolean containsUsbInterface(byte number) {
        return this.getUsbInterface(number) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsbInterfaceImp(UsbInterfaceImp setting) {
        HashMap hashMap = this.interfaces;
        synchronized (hashMap) {
            List list;
            String key = Byte.toString(setting.getUsbInterfaceDescriptor().bInterfaceNumber());
            if (!this.interfaces.containsKey(key)) {
                this.interfaces.put(key, new ArrayList());
            }
            List list2 = list = (List)this.interfaces.get(key);
            synchronized (list2) {
                if (list.contains(setting)) {
                    list.remove(setting);
                    list.add(0, setting);
                } else {
                    list.add(setting);
                }
            }
        }
    }

    public void setActiveUsbInterfaceImpSetting(UsbInterfaceImp setting) {
        this.addUsbInterfaceImp(setting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUsbInterfaceSettingList(byte number) {
        HashMap hashMap = this.interfaces;
        synchronized (hashMap) {
            return (List)this.interfaces.get(new Byte(number).toString());
        }
    }

    @Override
    public UsbDevice getUsbDevice() {
        return this.getUsbDeviceImp();
    }

    public UsbDeviceImp getUsbDeviceImp() {
        return this.usbDeviceImp;
    }

    public void setUsbDeviceImp(UsbDeviceImp device) {
        this.usbDeviceImp = device;
        if (device != null) {
            device.addUsbConfigurationImp(this);
        }
    }

    @Override
    public UsbConfigurationDescriptor getUsbConfigurationDescriptor() {
        return this.usbConfigurationDescriptor;
    }

    @Override
    public String getConfigurationString() throws UsbException, UsbEncodingException, UsbDisconnectedException {
        return this.getUsbDeviceImp().getString(this.getUsbConfigurationDescriptor().iConfiguration());
    }

    public void setUsbConfigurationDescriptor(UsbConfigurationDescriptor desc) {
        this.usbConfigurationDescriptor = desc;
    }

    void disconnect() {
        Iterator i = this.getUsbInterfaces().iterator();
        while (i.hasNext()) {
            Iterator as = ((UsbInterfaceImp)i.next()).getSettings().iterator();
            while (as.hasNext()) {
                ((UsbInterfaceImp)as.next()).disconnect();
            }
        }
    }

    void checkDisconnected() {
        this.getUsbDeviceImp().checkDisconnected();
    }

    boolean isDisconnected() {
        return this.getUsbDeviceImp().isDisconnected();
    }
}

