/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.util.ArrayList;
import java.util.List;
import javax.usb.UsbBabbleException;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbIrp;
import javax.usb.UsbPipe;
import javax.usb.event.UsbPipeDataEvent;
import javax.usb.event.UsbPipeErrorEvent;
import javax.usb.event.UsbPipeListener;
import org.lsst.ccs.drivers.usb.UsbTimeoutException;

public class UsbComm {
    public static final int DEV_SPEED_UNDEFINED = 0;
    public static final int DEV_SPEED_UNKNOWN = 1;
    public static final int DEV_SPEED_LOW = 2;
    public static final int DEV_SPEED_FULL = 3;
    public static final int DEV_CLASS_INTERFACE = 0;
    public static final int DEV_CLASS_CDC_CTRL = 2;
    public static final int DEV_CLASS_HUB = 9;
    public static final int DEV_CLASS_DIAGNOSTIC = 220;
    public static final int DEV_CLASS_MISC = 239;
    public static final int DEV_CLASS_VENDOR_SPEC = 255;
    public static final int CFG_ATTR_SELF_POWER = 64;
    public static final int CFG_ATTR_REMOTE_WAKE = 32;
    public static final int IFC_CLASS_AUDIO = 1;
    public static final int IFC_CLASS_CDC_CTRL = 2;
    public static final int IFC_CLASS_HID = 3;
    public static final int IFC_CLASS_PHYSICAL = 5;
    public static final int IFC_CLASS_IMAGE = 6;
    public static final int IFC_CLASS_PRINTER = 7;
    public static final int IFC_CLASS_MASS_STORE = 8;
    public static final int IFC_CLASS_CDC_DATA = 10;
    public static final int IFC_CLASS_SMART_CARD = 11;
    public static final int IFC_CLASS_CONTENT_SEC = 13;
    public static final int IFC_CLASS_VIDEO = 14;
    public static final int IFC_CLASS_HEALTHCARE = 15;
    public static final int IFC_CLASS_DIAGNOSTIC = 220;
    public static final int IFC_CLASS_WIRELESS = 224;
    public static final int IFC_CLASS_MISC = 239;
    public static final int IFC_CLASS_APP_SPEC = 254;
    public static final int IFC_CLASS_VENDOR_SPEC = 255;
    public static final int EP_ATTR_CONTROL = 0;
    public static final int EP_ATTR_ISOCHRONOUS = 1;
    public static final int EP_ATTR_BULK = 2;
    public static final int EP_ATTR_INTERRUPT = 3;
    private static UsbHub rootHub;
    private final Listener listener = new Listener();
    private UsbDevice dev;
    private UsbConfiguration conf;
    private UsbInterface ifc;
    private UsbEndpoint iEp;
    private UsbEndpoint oEp;
    private UsbPipe iPipe;
    private UsbPipe oPipe;

    public UsbComm() throws UsbException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    UsbComm.this.close();
                }
                catch (Exception exception) {}
            }
        });
        if (rootHub == null) {
            rootHub = UsbHostManager.getUsbServices().getRootUsbHub();
        }
    }

    public static List findDevices(int vid, int pid, String serial) throws UsbException {
        if (rootHub == null) {
            rootHub = UsbHostManager.getUsbServices().getRootUsbHub();
        }
        ArrayList list = new ArrayList();
        UsbComm.find(rootHub, vid, pid, serial, list);
        return list;
    }

    public UsbDevice findDevice(int vid, int pid, String serial) throws UsbException {
        UsbDevice devc = null;
        if (vid != -1 && pid != -1) {
            ArrayList list = new ArrayList();
            UsbComm.find(rootHub, vid, pid, serial, list);
            devc = list.isEmpty() ? null : (UsbDevice)list.get(0);
        }
        this.setDevice(devc);
        return this.dev;
    }

    public UsbDevice getDevice() {
        return this.dev;
    }

    public void setDevice(UsbDevice device) throws UsbException {
        if (this.iPipe != null || this.oPipe != null) {
            throw new UsbException("Device is open");
        }
        this.dev = device;
        this.conf = this.dev != null ? this.dev.getActiveUsbConfiguration() : null;
        this.ifc = null;
        this.iEp = null;
        this.oEp = null;
    }

    public UsbConfiguration getConfiguration() {
        return this.conf;
    }

    public UsbInterface getInterface() {
        return this.ifc;
    }

    public UsbInterface getInterface(int iface) {
        if (this.conf != null) {
            return this.conf.getUsbInterface((byte)iface);
        }
        return null;
    }

    public static UsbInterface getInterface(UsbDevice device, int iface) {
        UsbConfiguration cfg = device.getActiveUsbConfiguration();
        return cfg.getUsbInterface((byte)iface);
    }

    public UsbEndpoint getEndpoint(int epnum) {
        return epnum == 0 ? this.iEp : this.oEp;
    }

    public static UsbEndpoint getEndpoint(UsbInterface iface, int epnum) {
        List eps = iface.getUsbEndpoints();
        int j = 0;
        while (j < eps.size()) {
            UsbEndpoint ep;
            if (epnum == 0 ^ (ep = (UsbEndpoint)eps.get(j)).getDirection() == 0) {
                return ep;
            }
            ++j;
        }
        return null;
    }

    public int getSpeed() {
        return UsbComm.getSpeed(this.dev);
    }

    public static int getSpeed(UsbDevice devc) {
        Object speed = devc.getSpeed();
        if (speed.equals(UsbConst.DEVICE_SPEED_UNKNOWN)) {
            return 1;
        }
        if (speed.equals(UsbConst.DEVICE_SPEED_LOW)) {
            return 2;
        }
        if (speed.equals(UsbConst.DEVICE_SPEED_FULL)) {
            return 3;
        }
        return 0;
    }

    public void open(int iface, int ends, boolean force) throws UsbException {
        if (this.dev == null) {
            throw new UsbException("No device set");
        }
        if (this.iPipe != null || this.oPipe != null) {
            throw new UsbException("Device is open");
        }
        this.ifc = this.conf.getUsbInterface((byte)iface);
        if (this.ifc == null) {
            throw new UsbException("Interface not found");
        }
        this.ifc.claim(new Policy(force));
        List eps = this.ifc.getUsbEndpoints();
        this.oEp = null;
        this.iEp = null;
        int j = 0;
        while (j < eps.size()) {
            UsbEndpoint ep = (UsbEndpoint)eps.get(j);
            if (ep.getDirection() == 0) {
                if (this.oEp == null) {
                    this.oEp = ep;
                }
            } else if (this.iEp == null) {
                this.iEp = ep;
            }
            ++j;
        }
        if (this.iEp == null && ends != 2 || this.oEp == null && ends != 1) {
            this.ifc.release();
            throw new UsbException("Endpoint(s) not found");
        }
        if (ends != 2) {
            this.iPipe = this.iEp.getUsbPipe();
            this.iPipe.addUsbPipeListener(this.listener);
        }
        if (ends != 1) {
            this.oPipe = this.oEp.getUsbPipe();
        }
        try {
            if (this.iPipe != null) {
                this.iPipe.open();
            }
            if (this.oPipe != null) {
                this.oPipe.open();
            }
        }
        catch (UsbException e) {
            this.close();
            throw e;
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    public void close() throws UsbException {
        RuntimeException re;
        UsbException ue;
        block21: {
            ue = null;
            re = null;
            if (this.iPipe == null && this.oPipe == null) {
                throw new UsbException("Device is not open");
            }
            if (this.iPipe != null) {
                block19: {
                    try {
                        this.iPipe.abortAllSubmissions();
                        if (this.iPipe.isOpen()) {
                            this.iPipe.close();
                        }
                    }
                    catch (UsbException e) {
                        if (ue == null) {
                            ue = e;
                        }
                    }
                    catch (RuntimeException e) {
                        if (re != null) break block19;
                        re = e;
                    }
                }
                this.iPipe = null;
            }
            if (this.oPipe != null) {
                block20: {
                    try {
                        if (this.oPipe.isOpen()) {
                            this.oPipe.close();
                        }
                    }
                    catch (UsbException e) {
                        if (ue == null) {
                            ue = e;
                        }
                    }
                    catch (RuntimeException e) {
                        if (re != null) break block20;
                        re = e;
                    }
                }
                this.oPipe = null;
            }
            try {
                this.ifc.release();
            }
            catch (UsbException e) {
                if (ue == null) {
                    ue = e;
                }
            }
            catch (RuntimeException e) {
                if (re != null) break block21;
                re = e;
            }
        }
        if (re != null) {
            throw re;
        }
        if (ue != null) {
            throw ue;
        }
    }

    public int write(byte[] data) throws UsbException {
        return this.write(data, 0, data.length);
    }

    public int write(byte[] data, int offs, int leng) throws UsbException {
        if (this.oPipe == null) {
            throw new UsbException("Out endpoint is not open");
        }
        UsbIrp irp = this.oPipe.createUsbIrp();
        irp.setComplete(false);
        irp.setUsbException(null);
        irp.setData(data, offs, leng);
        this.oPipe.syncSubmit(irp);
        return irp.getActualLength();
    }

    public int read(byte[] data, int timeout) throws UsbException, UsbTimeoutException {
        return this.read(data, 0, data.length, timeout);
    }

    public synchronized int read(byte[] data, int offs, int leng, int timeout) throws UsbException, UsbTimeoutException {
        if (this.iPipe == null) {
            throw new UsbException("In endpoint is not open");
        }
        UsbIrp irp = this.iPipe.createUsbIrp();
        irp.setComplete(false);
        irp.setUsbException(null);
        irp.setData(data, offs, leng);
        this.listener.mainThread = Thread.currentThread();
        if (timeout == 0) {
            this.iPipe.syncSubmit(irp);
        } else {
            Thread.interrupted();
            this.iPipe.asyncSubmit(irp);
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
        UsbException re = irp.getUsbException();
        if (re != null) {
            throw re;
        }
        if (!irp.isComplete()) {
            try {
                this.iPipe.abortAllSubmissions();
            }
            catch (Exception exception) {}
            throw new UsbTimeoutException();
        }
        return irp.getActualLength();
    }

    public int flush() throws UsbException {
        int leng = 0;
        byte[] data = new byte[64];
        while (true) {
            try {
                while (true) {
                    leng += this.read(data, 100);
                }
            }
            catch (UsbTimeoutException usbTimeoutException) {
            }
            catch (UsbBabbleException usbBabbleException) {
                data = new byte[2 * data.length];
                continue;
            }
            break;
        }
        return leng;
    }

    private static void find(UsbHub hub, int vid, int pid, String serial, List list) throws UsbException {
        int nPort = hub.getNumberOfPorts() & 0xFF;
        int j = 1;
        while (j <= nPort) {
            UsbDevice dev = hub.getUsbPort((byte)j).getUsbDevice();
            if (dev != null) {
                if (dev.isUsbHub()) {
                    UsbComm.find((UsbHub)dev, vid, pid, serial, list);
                } else {
                    UsbDeviceDescriptor desc = dev.getUsbDeviceDescriptor();
                    if (!(vid != -1 && (short)vid != desc.idVendor() || pid != -1 && (short)pid != desc.idProduct())) {
                        if (serial == null) {
                            list.add(dev);
                        } else {
                            String serno = dev.getSerialNumberString();
                            if (serno != null && serno.equals(serial)) {
                                list.add(dev);
                            }
                        }
                    }
                }
            }
            ++j;
        }
    }

    static class Listener
    implements UsbPipeListener {
        private Thread mainThread;

        Listener() {
        }

        @Override
        public void dataEventOccurred(UsbPipeDataEvent event) {
            this.mainThread.interrupt();
        }

        @Override
        public void errorEventOccurred(UsbPipeErrorEvent event) {
            this.mainThread.interrupt();
        }
    }

    static class Policy
    implements UsbInterfacePolicy {
        private final boolean force;

        public Policy(boolean force) {
            this.force = force;
        }

        @Override
        public boolean forceClaim(UsbInterface iface) {
            return this.force;
        }
    }
}

