/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConfigurationDescriptor;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfaceDescriptor;
import jline.ConsoleReader;
import org.lsst.ccs.drivers.usb.UsbComm;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestUsbComm
implements CmndProc.Dispatch {
    private static final int CMD_FIND = 0;
    private static final int CMD_OPEN = 1;
    private static final int CMD_CLOSE = 2;
    private static final int CMD_FLUSH = 3;
    private static final int CMD_READ = 4;
    private static final int CMD_WRITE = 5;
    private static final int CMD_SHOWDEV = 6;
    private static final int CMD_SHOWCFG = 7;
    private static final int CMD_SHOWIF = 8;
    private static final int CMD_SHOWEP = 9;
    private static final int CMD_SHOWBUS = 10;
    private static final int NUM_CMDS = 11;
    private static final String[] helpFind = new String[]{"Find a device", "find <vendId> <devId> [<serial>]", "vendId  The vendor ID of the device", "devId   The device ID of the device", "serial  The serial number of the device (default any)"};
    private static final String[] helpOpen = new String[]{"Open device connection", "open [<iface>] [<ends>] [<force>]", "iface  The number of the interface to open (default 0)", "ends   The endpoints to open (default 0)", "force  If present and non-zero, force the interface claim"};
    private static final String[] helpClose = new String[]{"Close device connection", "close"};
    private static final String[] helpFlush = new String[]{"Flush any unread data", "flush"};
    private static final String[] helpRead = new String[]{"Read data from the device and display it", "read <count> [<timeout>]", "count    The number of bytes to read", "timeout  The timeout in seconds (default 1)"};
    private static final String[] helpWrite = new String[]{"Write data to the device", "write [<data1>]... [<datan>]", "datan  Up to 8 hexadecimal strings"};
    private static final String[] helpShowdev = new String[]{"Show device information", "showdev"};
    private static final String[] helpShowcfg = new String[]{"Show configuration information", "showcfg [<device>]", "device  Device number from showbus list (default: current device)"};
    private static final String[] helpShowif = new String[]{"Show interface information", "showif [<iface>] [<device>]", "iface   The interface number (default: the current open one)", "device  Device number from showbus list (default: current device)"};
    private static final String[] helpShowep = new String[]{"Show endpoint information", "showep <epnum> [<iface>] [<device>]", "epnum   The number of the endpoint to show: 0 = in, 1 = out", "iface   The interface number (default: the current open one)", "device  Device number from showbus list (default: current device)"};
    private static final String[] helpShowbus = new String[]{"Show all devices on the USB bus", "showbus"};
    private static final CmndProc.Command cmnd = new CmndProc.Command(11);
    private static final CmndProc.Lookup speedNames;
    private static final CmndProc.Lookup devcNames;
    private static final CmndProc.Lookup cfgaNames;
    private static final CmndProc.Lookup ifccNames;
    private static final CmndProc.Lookup epaNames;
    private final Output out = new ConsOut();
    private final ConsoleReader reader = new ConsoleReader();
    private final CmndProc proc = new CmndProc();
    private final UsbComm com = new UsbComm();
    private final boolean debug;

    static {
        cmnd.add("find", 0, helpFind);
        cmnd.add("open", 1, helpOpen);
        cmnd.add("close", 2, helpClose);
        cmnd.add("flush", 3, helpFlush);
        cmnd.add("read", 4, helpRead);
        cmnd.add("write", 5, helpWrite);
        cmnd.add("showdev", 6, helpShowdev);
        cmnd.add("showcfg", 7, helpShowcfg);
        cmnd.add("showif", 8, helpShowif);
        cmnd.add("showep", 9, helpShowep);
        cmnd.add("showbus", 10, helpShowbus);
        speedNames = new CmndProc.Lookup(4);
        speedNames.add("Undefined", 0);
        speedNames.add("Low", 2);
        speedNames.add("Full", 3);
        speedNames.add("Unknown", 1);
        devcNames = new CmndProc.Lookup(6);
        devcNames.add("See interface", 0);
        devcNames.add("Comm control", 2);
        devcNames.add("Hub", 9);
        devcNames.add("Diagnostic", 220);
        devcNames.add("Miscellaneous", 239);
        devcNames.add("Vendor spec", 255);
        cfgaNames = new CmndProc.Lookup(2);
        cfgaNames.add("Self-powered", 64);
        cfgaNames.add("Remote wakeup", 32);
        ifccNames = new CmndProc.Lookup(17);
        ifccNames.add("Audio", 1);
        ifccNames.add("Comm control", 2);
        ifccNames.add("Human intface", 3);
        ifccNames.add("Physical", 5);
        ifccNames.add("Still image", 6);
        ifccNames.add("Printer", 7);
        ifccNames.add("Mass storage", 8);
        ifccNames.add("Comm data", 10);
        ifccNames.add("Smart card", 11);
        ifccNames.add("Content secty", 13);
        ifccNames.add("Video", 14);
        ifccNames.add("Healthcare", 15);
        ifccNames.add("Diagnostic", 220);
        ifccNames.add("Wireless", 224);
        ifccNames.add("Miscellaneous", 239);
        ifccNames.add("App specific", 254);
        ifccNames.add("Vendor spec", 255);
        epaNames = new CmndProc.Lookup(4);
        epaNames.add("Control", 0);
        epaNames.add("Isochronous", 1);
        epaNames.add("Bulk", 2);
        epaNames.add("Interrupt", 3);
    }

    public TestUsbComm(boolean dbg) throws UsbException, IOException {
        this.debug = dbg;
        this.proc.add((CmndProc.Dispatch)this, cmnd);
    }

    public static void main(String[] args) {
        TestUsbComm tcom = null;
        try {
            tcom = new TestUsbComm(args.length > 0);
            tcom.run();
        }
        catch (UsbException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        while ((line = this.reader.readLine(">> ")) != null) {
            try {
                if (this.proc.process(line)) continue;
                break;
            }
            catch (RuntimeException e) {
                if (this.debug) {
                    e.printStackTrace(System.out);
                    continue;
                }
                this.out.println((Object)e);
            }
        }
    }

    public boolean dispatch(int code, Scanner scan) {
        try {
            return this.dispatchCmnd(code, scan);
        }
        catch (UsbException e) {
            this.out.println((Object)e.toString());
            return true;
        }
    }

    private boolean dispatchCmnd(int code, Scanner scan) throws UsbException {
        Object[] args = new Object[16];
        switch (code) {
            case 0: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIs", (Object[])args);
                if (found < 0) break;
                String serial = null;
                if ((found & 4) != 0) {
                    serial = (String)args[2];
                }
                if (this.com.findDevice((Integer)args[0], (Integer)args[1], serial) != null) break;
                this.out.println((Object)"Device not found");
                break;
            }
            case 1: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"iii", (Object[])args);
                if (found < 0) break;
                this.com.open((found & 1) != 0 ? (Integer)args[0] : 0, (found & 2) != 0 ? (Integer)args[1] : 0, (found & 4) != 0 && (Integer)args[2] != 0);
                break;
            }
            case 2: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.com.close();
                break;
            }
            case 3: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)(String.valueOf(this.com.flush()) + " bytes flushed"));
                break;
            }
            case 4: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"If", (Object[])args);
                if (found < 0) break;
                int count = (Integer)args[0];
                float timeout = 1.0f;
                if ((found & 2) != 0) {
                    timeout = ((Float)args[1]).floatValue();
                }
                byte[] data = new byte[count];
                int nRead = this.com.read(data, (int)(1000.0f * timeout));
                this.dispData(data, nRead);
                break;
            }
            case 5: {
                int k;
                byte[] sData;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ssssssss", (Object[])args);
                if (found < 0) break;
                int count = 0;
                int mask = 0;
                ArrayList<byte[]> list = new ArrayList<byte[]>();
                int j = 0;
                while (j < 8) {
                    if ((found & 1 << j) != 0) {
                        String hex = (String)args[j];
                        int leng = hex.length();
                        if ((leng & 1) != 0) break;
                        sData = new byte[leng / 2];
                        try {
                            k = 0;
                            while (k < leng) {
                                String num = hex.substring(k, k + 2);
                                sData[k / 2] = (byte)Integer.parseInt(num, 16);
                                k += 2;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            break;
                        }
                        count += leng / 2;
                        list.add(sData);
                        mask |= 1 << j;
                    }
                    ++j;
                }
                if (mask != found) {
                    this.out.println((Object)"Invalid hexadecimal string");
                    break;
                }
                byte[] data = new byte[count];
                int l = 0;
                int j2 = 0;
                while (j2 < list.size()) {
                    sData = (byte[])list.get(j2);
                    k = 0;
                    while (k < sData.length) {
                        data[l++] = sData[k];
                        ++k;
                    }
                    ++j2;
                }
                this.com.write(data);
                break;
            }
            case 6: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                UsbDevice dev = this.com.getDevice();
                if (dev != null) {
                    this.showDevice(dev);
                    break;
                }
                this.out.println((Object)"No device active");
                break;
            }
            case 10: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                List devs = UsbComm.findDevices(-1, -1, null);
                if (!devs.isEmpty()) {
                    int j = 0;
                    while (j < devs.size()) {
                        UsbDevice dev = (UsbDevice)devs.get(j);
                        if (j > 0) {
                            this.out.println();
                        }
                        this.out.println((Object)("Device " + j + ":"));
                        this.showDevice(dev);
                        ++j;
                    }
                    break;
                }
                this.out.println((Object)"No devices found");
                break;
            }
            case 7: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                if ((found & 1) == 0) {
                    UsbConfiguration cfg = this.com.getConfiguration();
                    if (cfg != null) {
                        this.showConfiguration(cfg);
                        break;
                    }
                    this.out.println((Object)"No device active");
                    break;
                }
                UsbDevice dev = this.getDevice((Integer)args[0]);
                if (dev != null) {
                    this.showConfiguration(dev.getActiveUsbConfiguration());
                    break;
                }
                this.out.println((Object)"Device not found");
                break;
            }
            case 8: {
                int dnum;
                int inum;
                UsbInterface ifc;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0 || (ifc = this.getInterface(found, inum = (found & 1) != 0 ? (Integer)args[0] : 0, dnum = (found & 2) != 0 ? (Integer)args[1] : 0)) == null) break;
                this.showInterface(ifc);
                break;
            }
            case 9: {
                int dnum;
                int inum;
                UsbInterface ifc;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Iii", (Object[])args);
                if (found < 0 || (ifc = this.getInterface(found >> 1, inum = (found & 2) != 0 ? (Integer)args[1] : 0, dnum = (found & 4) != 0 ? (Integer)args[2] : 0)) == null) break;
                UsbEndpoint ep = UsbComm.getEndpoint(ifc, (Integer)args[0]);
                if (ep != null) {
                    this.showEndpoint(ep);
                    break;
                }
                this.out.println((Object)"Endpoint not found");
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private UsbDevice getDevice(int index) throws UsbException {
        List devs = UsbComm.findDevices(-1, -1, null);
        if (index >= 0 && index < devs.size()) {
            return (UsbDevice)devs.get(index);
        }
        return null;
    }

    private UsbInterface getInterface(int mask, int inum, int dnum) throws UsbException {
        UsbInterface ifc = null;
        if ((mask & 2) == 0) {
            if ((mask & 1) == 0) {
                ifc = this.com.getInterface();
                if (ifc == null) {
                    this.out.println((Object)"Device not open");
                }
            } else {
                ifc = this.com.getInterface(inum);
                if (ifc == null) {
                    this.out.println((Object)"Interface not found");
                }
            }
        } else {
            UsbDevice dev = this.getDevice(dnum);
            if (dev != null) {
                int iface = (mask & 1) != 0 ? inum : 0;
                ifc = UsbComm.getInterface(dev, iface);
                if (ifc == null) {
                    this.out.println((Object)"Interface not found");
                }
            } else {
                this.out.println((Object)"Device not found");
            }
        }
        return ifc;
    }

    private void dispData(byte[] data, int count) {
        String cnt = String.valueOf(count) + " bytes read";
        String pad = String.format("%24s", "").substring(0, cnt.length() + 1);
        this.out.print((Object)cnt);
        int j = 0;
        while (j < count) {
            if ((j & 0xF) == 0) {
                if (j == 0) {
                    this.out.print((Object)":");
                } else {
                    this.out.println();
                    this.out.print((Object)pad);
                }
            }
            this.out.format(" %02x", new Object[]{data[j] & 0xFF});
            ++j;
        }
        this.out.println();
    }

    private void showDevice(UsbDevice dev) throws UsbException {
        UsbDeviceDescriptor desc = dev.getUsbDeviceDescriptor();
        this.out.format("Vendor ID (name) : 0x%04x (%s)\n", new Object[]{desc.idVendor(), dev.getManufacturerString()});
        this.out.format("Product ID (name): 0x%04x (%s)\n", new Object[]{desc.idProduct(), dev.getProductString()});
        this.out.println((Object)("Serial Number    : " + dev.getSerialNumberString()));
        this.out.println((Object)("Device Speed     : " + speedNames.decode(UsbComm.getSpeed(dev))));
        int cls = desc.bDeviceClass() & 0xFF;
        this.out.format("Device class     : %s (%s)\n", new Object[]{cls, devcNames.decode(cls)});
        this.out.println((Object)("Device Subclass  : " + desc.bDeviceSubClass()));
        this.out.println((Object)("Device Protocol  : " + desc.bDeviceProtocol()));
        this.out.format("USB Release      : %04x\n", new Object[]{desc.bcdUSB()});
        this.out.println((Object)("Number Configs   : " + desc.bNumConfigurations()));
        this.out.println((Object)("Maxm packet size : " + desc.bMaxPacketSize0()));
    }

    private void showConfiguration(UsbConfiguration cfg) throws UsbException {
        UsbConfigurationDescriptor desc = cfg.getUsbConfigurationDescriptor();
        this.out.format("ConfigNum (name) : %s (%s)\n", new Object[]{desc.bConfigurationValue(), cfg.getConfigurationString()});
        int attr = desc.bmAttributes() & 0xFF;
        String sAttr = "";
        int j = 0;
        while (j < cfgaNames.count()) {
            int code = cfgaNames.code(j);
            if ((attr & code) != 0) {
                if (!sAttr.equals("")) {
                    sAttr = String.valueOf(sAttr) + ", ";
                }
                sAttr = String.valueOf(sAttr) + cfgaNames.name(j);
            }
            ++j;
        }
        this.out.format("Attributes       : 0x%02x (%s)\n", new Object[]{attr, sAttr});
        this.out.format("Maximum power    : %s mA\n", new Object[]{desc.bMaxPower()});
        this.out.println((Object)("Number interfaces: " + desc.bNumInterfaces()));
    }

    private void showInterface(UsbInterface ifc) throws UsbException {
        UsbInterfaceDescriptor desc = ifc.getUsbInterfaceDescriptor();
        this.out.format("Interface (name) : %s (%s)\n", new Object[]{desc.bInterfaceNumber(), ifc.getInterfaceString()});
        this.out.println((Object)("Alt. setting     : " + desc.bAlternateSetting()));
        int cls = desc.bInterfaceClass() & 0xFF;
        this.out.format("Interface class  : %s (%s)\n", new Object[]{cls, ifccNames.decode(cls)});
        this.out.println((Object)("Intface subclass : " + desc.bInterfaceSubClass()));
        this.out.println((Object)("Intface protocol : " + desc.bInterfaceProtocol()));
        this.out.println((Object)("Number endpoints : " + desc.bNumEndpoints()));
    }

    private void showEndpoint(UsbEndpoint ep) {
        UsbEndpointDescriptor desc = ep.getUsbEndpointDescriptor();
        this.out.format("Address          : 0x%02x\n", new Object[]{desc.bEndpointAddress()});
        int attr = desc.bmAttributes() & 0xFF;
        this.out.format("Attributes       : 0x%02x (%s)\n", new Object[]{attr, epaNames.decode(attr & 3)});
        this.out.format("Interval         : %s msec\n", new Object[]{desc.bInterval()});
        this.out.println((Object)("Maxm packet size : " + desc.wMaxPacketSize()));
    }
}

