/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.util;

import javax.usb.UsbException;
import javax.usb.UsbIrp;

public class DefaultUsbIrp
implements UsbIrp {
    protected byte[] data = new byte[0];
    protected boolean complete = false;
    protected boolean acceptShortPacket = true;
    protected int offset = 0;
    protected int length = 0;
    protected int actualLength = 0;
    protected UsbException usbException = null;
    private Object waitLock = new Object();

    public DefaultUsbIrp() {
    }

    public DefaultUsbIrp(byte[] data) {
        this.setData(data);
    }

    public DefaultUsbIrp(byte[] data, int offset, int length, boolean shortPacket) {
        this.setData(data, offset, length);
        this.setAcceptShortPacket(shortPacket);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getActualLength() {
        return this.actualLength;
    }

    @Override
    public void setData(byte[] d, int o, int l) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        this.data = d;
        this.setOffset(o);
        this.setLength(l);
    }

    @Override
    public void setData(byte[] d) throws IllegalArgumentException {
        if (d == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        this.setData(d, 0, d.length);
    }

    @Override
    public void setOffset(int o) throws IllegalArgumentException {
        if (o < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        this.offset = o;
    }

    @Override
    public void setLength(int l) throws IllegalArgumentException {
        if (l < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        this.length = l;
    }

    @Override
    public void setActualLength(int l) throws IllegalArgumentException {
        if (l < 0) {
            throw new IllegalArgumentException("Actual length cannot be negative");
        }
        this.actualLength = l;
    }

    @Override
    public boolean isUsbException() {
        return this.getUsbException() != null;
    }

    @Override
    public UsbException getUsbException() {
        return this.usbException;
    }

    @Override
    public void setUsbException(UsbException exception) {
        this.usbException = exception;
    }

    @Override
    public boolean getAcceptShortPacket() {
        return this.acceptShortPacket;
    }

    @Override
    public void setAcceptShortPacket(boolean accept) {
        this.acceptShortPacket = accept;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean b) {
        this.complete = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        this.setComplete(true);
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitUntilComplete() {
        Object object = this.waitLock;
        synchronized (object) {
            while (true) {
                if (this.isComplete()) {
                    return;
                }
                try {
                    this.waitLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilComplete(long timeout) {
        if (0L >= timeout) {
            this.waitUntilComplete();
            return;
        }
        long startTime = System.currentTimeMillis();
        Object object = this.waitLock;
        synchronized (object) {
            if (!this.isComplete() && System.currentTimeMillis() - startTime < timeout) {
                try {
                    this.waitLock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

