/*
 * Decompiled with CFR 0.152.
 */
package javax.usb.examples;

import java.util.List;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.examples.FindUsbDevice;
import javax.usb.examples.ShowTopology;
import javax.usb.util.StandardRequest;
import javax.usb.util.UsbUtil;

public class DefaultControlPipe {
    public static void main(String[] argv) {
        UsbHub virtualRootUsbHub = ShowTopology.getVirtualRootUsbHub();
        List allUsbDevices = FindUsbDevice.getAllUsbDevices(virtualRootUsbHub);
        List usbHubs = FindUsbDevice.getUsbDevicesWithDeviceClass(virtualRootUsbHub, (byte)9);
        System.out.println("Found " + allUsbDevices.size() + " devices total.");
        System.out.println("Found " + usbHubs.size() + " hubs.");
        allUsbDevices.removeAll(usbHubs);
        System.out.println("Found " + allUsbDevices.size() + " non-hub devices.");
        if (allUsbDevices.size() > 0) {
            UsbDevice usbDevice = (UsbDevice)allUsbDevices.get(0);
            DefaultControlPipe.showStandardRequestCommunication(usbDevice);
            DefaultControlPipe.showUsbControlIrpCommunication(usbDevice);
        } else {
            System.out.println("No non-hub devices were found.");
        }
    }

    public static void showUsbControlIrpCommunication(UsbDevice usbDevice) {
        byte bmRequestType = -128;
        byte bRequest = 6;
        short wValue = 256;
        short wIndex = 0;
        byte[] buffer = new byte[256];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(buffer);
        if (!DefaultControlPipe.sendUsbControlIrp(usbDevice, usbControlIrp)) {
            return;
        }
        int length = usbControlIrp.getActualLength();
        System.out.println("Got device descriptor (length " + length + ") :");
        System.out.println(UsbUtil.toHexString(" 0x", buffer, length));
        bmRequestType = -128;
        bRequest = 8;
        wValue = 0;
        wIndex = 0;
        buffer = new byte[1];
        usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(buffer);
        if (!DefaultControlPipe.sendUsbControlIrp(usbDevice, usbControlIrp)) {
            return;
        }
        length = usbControlIrp.getActualLength();
        if (1 > length) {
            System.out.println("Got no data during submission!");
        } else {
            System.out.println("Got current configuration number : " + UsbUtil.unsignedInt(buffer[0]));
        }
    }

    public static boolean sendUsbControlIrp(UsbDevice usbDevice, UsbControlIrp usbControlIrp) {
        try {
            usbDevice.syncSubmit(usbControlIrp);
            return true;
        }
        catch (UsbException uE) {
            System.out.println("DCP submission failed : " + uE.getMessage());
            return false;
        }
    }

    public static void showStandardRequestCommunication(UsbDevice usbDevice) {
        byte type = 1;
        byte index = 0;
        short langid = 0;
        byte[] buffer = new byte[256];
        try {
            int length = StandardRequest.getDescriptor(usbDevice, type, index, langid, buffer);
            System.out.println("Got device descriptor (length " + length + ") :");
            System.out.println(UsbUtil.toHexString(" 0x", buffer, length));
        }
        catch (UsbException uE) {
            System.out.println("Couldn't get device descriptor : " + uE.getMessage());
        }
        try {
            byte configuration = StandardRequest.getConfiguration(usbDevice);
            System.out.println("Got current configuration number : " + UsbUtil.unsignedInt(configuration));
        }
        catch (UsbException uE) {
            System.out.println("Couldn't get current configuration number : " + uE.getMessage());
        }
    }
}

