/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.linux;

import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.UsbPortImp;
import com.ibm.jusb.os.AbstractUsbServices;
import com.ibm.jusb.os.linux.JavaxUsb;
import com.ibm.jusb.os.linux.LinuxDeviceOsImp;
import com.ibm.jusb.util.RunnableManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;
import javax.usb.event.UsbServicesEvent;
import javax.usb.util.UsbUtil;

public class LinuxUsbServices
extends AbstractUsbServices
implements UsbServices {
    private RunnableManager topologyUpdateManager = new RunnableManager();
    private Thread topologyListener = null;
    private Object topologyLock = new Object();
    private boolean firstUpdateDone = false;
    private int topologyListenerError = 0;
    private int topologyUpdateResult = 0;
    protected boolean topologyUpdateUsePolling = true;
    protected int topologyUpdateDelay = 5000;
    protected int topologyUpdateNewDeviceDelay = 500;
    public static final int MAX_FIRST_UPDATE_DELAY = 10000;
    public static final int TOPOLOGY_UPDATE_DELAY = 5000;
    public static final String TOPOLOGY_UPDATE_DELAY_KEY = "com.ibm.jusb.os.linux.LinuxUsbServices.topologyUpdateDelay";
    public static final int TOPOLOGY_UPDATE_NEW_DEVICE_DELAY = 500;
    public static final String TOPOLOGY_UPDATE_NEW_DEVICE_DELAY_KEY = "com.ibm.jusb.os.linux.LinuxUsbServices.topologyUpdateNewDeviceDelay";
    public static final boolean TOPOLOGY_UPDATE_USE_POLLING = true;
    public static final String TOPOLOGY_UPDATE_USE_POLLING_KEY = "com.ibm.jusb.os.linux.LinuxUsbServices.topologyUpdateUsePolling";
    public static final String TRACING = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.tracing";
    public static final String TRACE_OUTPUT = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.trace_output";
    public static final String TRACE_FILENAME = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.trace_filename";
    public static final String TRACE_LEVEL = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.trace_level";
    public static final String TRACE_DEFAULT = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.trace_default";
    public static final String TRACE_HOTPLUG = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.trace_hotplug";
    public static final String TRACE_XFER = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.trace_xfer";
    public static final String TRACE_URB = "com.ibm.jusb.os.linux.LinuxUsbServices.JNI.trace_urb";

    public LinuxUsbServices() throws UsbException {
        JavaxUsb.loadLibrary();
        this.topologyUpdateManager.setMaxSize(Long.MAX_VALUE);
        this.checkProperties();
        this.startTopologyListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized UsbHub getRootUsbHub() throws UsbException {
        Object object = this.topologyLock;
        synchronized (object) {
            if (!this.firstUpdateDone) {
                try {
                    this.topologyLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.getRootUsbHubImp();
    }

    @Override
    public String getApiVersion() {
        return "1.0.0";
    }

    @Override
    public String getImpVersion() {
        return "1.0.2";
    }

    @Override
    public String getImpDescription() {
        return "JSR80 : javax.usb\n\nImplementation for the Linux kernel (2.4/2.6).\n\n\n*\n* Copyright (c) 1999 - 2001, International Business Machines Corporation.\n* All Rights Reserved.\n*\n* This software is provided and licensed under the terms and conditions\n* of the Common Public License:\n* http://oss.software.ibm.com/developerworks/opensource/license-cpl.html\n\nhttp://javax-usb.org/";
    }

    private void checkProperties() {
        Properties p = null;
        try {
            p = UsbHostManager.getProperties();
        }
        catch (Exception exception) {
            return;
        }
        try {
            if (p.containsKey(TOPOLOGY_UPDATE_DELAY_KEY)) {
                this.topologyUpdateDelay = Integer.decode(p.getProperty(TOPOLOGY_UPDATE_DELAY_KEY));
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TOPOLOGY_UPDATE_NEW_DEVICE_DELAY_KEY)) {
                this.topologyUpdateNewDeviceDelay = Integer.decode(p.getProperty(TOPOLOGY_UPDATE_NEW_DEVICE_DELAY_KEY));
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TOPOLOGY_UPDATE_USE_POLLING_KEY)) {
                this.topologyUpdateUsePolling = Boolean.valueOf(p.getProperty(TOPOLOGY_UPDATE_USE_POLLING_KEY));
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TRACING)) {
                JavaxUsb.nativeSetTracing(Boolean.valueOf(p.getProperty(TRACING)));
            }
        }
        catch (Exception exception) {}
        JavaxUsb.nativeSetTraceOutput(2, "");
        try {
            if (p.containsKey(TRACE_OUTPUT)) {
                int output = Integer.decode(p.getProperty(TRACE_OUTPUT));
                String traceFilename = "";
                if (!(3 != output && 4 != output || (traceFilename = p.getProperty(TRACE_FILENAME)) != null && !"".equals(traceFilename))) {
                    traceFilename = "";
                    output = 2;
                }
                JavaxUsb.nativeSetTraceOutput(output, traceFilename);
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TRACE_DEFAULT)) {
                JavaxUsb.nativeSetTraceType(Boolean.valueOf(p.getProperty(TRACE_DEFAULT)), "default");
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TRACE_HOTPLUG)) {
                JavaxUsb.nativeSetTraceType(Boolean.valueOf(p.getProperty(TRACE_HOTPLUG)), "hotplug");
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TRACE_XFER)) {
                JavaxUsb.nativeSetTraceType(Boolean.valueOf(p.getProperty(TRACE_XFER)), "xfer");
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TRACE_URB)) {
                JavaxUsb.nativeSetTraceType(Boolean.valueOf(p.getProperty(TRACE_URB)), "urb");
            }
        }
        catch (Exception exception) {}
        try {
            if (p.containsKey(TRACE_LEVEL)) {
                JavaxUsb.nativeSetTraceLevel(Integer.decode(p.getProperty(TRACE_LEVEL)));
            }
        }
        catch (Exception exception) {}
    }

    private boolean isListening() {
        try {
            return this.topologyListener.isAlive();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    private void startTopologyListener() {
        Runnable r = null;
        String threadName = null;
        if (this.topologyUpdateUsePolling) {
            threadName = "javax.usb Linux implementation Topology Poller";
            r = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(LinuxUsbServices.this.topologyUpdateDelay);
                        }
                        catch (InterruptedException interruptedException) {}
                        LinuxUsbServices.this.updateTopology();
                    }
                }
            };
        } else {
            threadName = "javax.usb Linux implementation Topology Listener";
            r = new Runnable(){

                @Override
                public void run() {
                    LinuxUsbServices.this.topologyListenerExit(JavaxUsb.nativeTopologyListener(LinuxUsbServices.this));
                }
            };
        }
        this.topologyListener = new Thread(r);
        this.topologyListener.setDaemon(true);
        this.topologyListener.setName(threadName);
        this.topologyListenerError = 0;
        this.topologyListener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topologyListenerExit(int error) {
        this.topologyListenerError = error;
        Object object = this.topologyLock;
        synchronized (object) {
            this.topologyLock.notifyAll();
        }
    }

    private void topologyChange() {
        try {
            Thread.sleep(this.topologyUpdateDelay);
        }
        catch (InterruptedException interruptedException) {}
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LinuxUsbServices.this.updateTopology();
            }
        };
        this.topologyUpdateManager.add(r);
    }

    private void fillDeviceList(UsbDeviceImp device, List list) {
        list.add(device);
        if (device.isUsbHub()) {
            UsbHubImp hub = (UsbHubImp)device;
            Iterator iterator = hub.getAttachedUsbDevices().iterator();
            while (iterator.hasNext()) {
                this.fillDeviceList((UsbDeviceImp)iterator.next(), list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTopology() {
        ArrayList connectedDevices = new ArrayList();
        ArrayList disconnectedDevices = new ArrayList();
        this.fillDeviceList(this.getRootUsbHubImp(), disconnectedDevices);
        disconnectedDevices.remove(this.getRootUsbHubImp());
        this.topologyUpdateResult = JavaxUsb.nativeTopologyUpdater(this, connectedDevices, disconnectedDevices);
        int i = 0;
        while (i < disconnectedDevices.size()) {
            ((UsbDeviceImp)disconnectedDevices.get(i)).disconnect();
            ++i;
        }
        i = 0;
        while (i < connectedDevices.size()) {
            UsbDeviceImp device = (UsbDeviceImp)connectedDevices.get(i);
            this.setActiveConfigAndInterfaceSettings(device);
            device.getParentUsbPortImp().attachUsbDeviceImp(device);
            ++i;
        }
        i = 0;
        while (i < disconnectedDevices.size()) {
            this.listenerImp.usbDeviceDetached(new UsbServicesEvent(this, (UsbDevice)disconnectedDevices.get(i)));
            ++i;
        }
        i = 0;
        while (i < connectedDevices.size()) {
            try {
                Thread.sleep(this.topologyUpdateNewDeviceDelay);
            }
            catch (InterruptedException interruptedException) {}
            this.listenerImp.usbDeviceAttached(new UsbServicesEvent(this, (UsbDevice)connectedDevices.get(i)));
            ++i;
        }
        Object object = this.topologyLock;
        synchronized (object) {
            this.firstUpdateDone = true;
            this.topologyLock.notifyAll();
        }
    }

    private UsbDeviceImp checkUsbDeviceImp(UsbHubImp hub, int p, UsbDeviceImp device, List connected, List disconnected) {
        byte port = (byte)p;
        UsbPortImp usbPortImp = hub.getUsbPortImp(port);
        if (usbPortImp == null) {
            hub.resize(port);
            usbPortImp = hub.getUsbPortImp(port);
        }
        if (!usbPortImp.isUsbDeviceAttached()) {
            connected.add(device);
            device.setParentUsbPortImp(usbPortImp);
            return device;
        }
        UsbDeviceImp existingDevice = usbPortImp.getUsbDeviceImp();
        if (this.isUsbDevicesEqual(existingDevice, device)) {
            disconnected.remove(existingDevice);
            return existingDevice;
        }
        connected.add(device);
        device.setParentUsbPortImp(usbPortImp);
        return device;
    }

    protected boolean isUsbDevicesEqual(UsbDeviceImp dev1, UsbDeviceImp dev2) {
        try {
            UsbDeviceDescriptor desc1 = dev1.getUsbDeviceDescriptor();
            UsbDeviceDescriptor desc2 = dev2.getUsbDeviceDescriptor();
            String key1 = ((LinuxDeviceOsImp)dev1.getUsbDeviceOsImp()).getKey();
            String key2 = ((LinuxDeviceOsImp)dev2.getUsbDeviceOsImp()).getKey();
            return key1.equals(key2) && dev1.isUsbHub() == dev1.isUsbHub() && dev1.getSpeed() == dev2.getSpeed() && desc1.equals(desc2);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    protected void setActiveConfigAndInterfaceSettings(UsbDeviceImp device) {
        LinuxDeviceOsImp linuxDeviceOsImp = (LinuxDeviceOsImp)device.getUsbDeviceOsImp();
        int config = JavaxUsb.nativeGetActiveConfigurationNumber(linuxDeviceOsImp);
        if (config == 0) {
            device.setActiveUsbConfigurationNumber((byte)config);
        }
        if (config < 0) {
            return;
        }
        if (device.containsUsbConfiguration((byte)config)) {
            device.setActiveUsbConfigurationNumber((byte)config);
        } else if (1 == device.getUsbConfigurations().size()) {
            device.setActiveUsbConfigurationNumber(((UsbConfiguration)device.getUsbConfigurations().get(0)).getUsbConfigurationDescriptor().bConfigurationValue());
        } else {
            return;
        }
        for (UsbInterfaceImp usbInterfaceImp : device.getActiveUsbConfiguration().getUsbInterfaces()) {
            int setting = 0;
            if (1 < usbInterfaceImp.getNumSettings()) {
                byte interfaceNumber = usbInterfaceImp.getUsbInterfaceDescriptor().bInterfaceNumber();
                setting = JavaxUsb.nativeGetActiveInterfaceSettingNumber(linuxDeviceOsImp, UsbUtil.unsignedInt(interfaceNumber));
                if (setting < 0) continue;
                usbInterfaceImp.setActiveSettingNumber((byte)setting);
                continue;
            }
            usbInterfaceImp.setActiveSettingNumber(usbInterfaceImp.getUsbInterfaceDescriptor().bAlternateSetting());
        }
    }
}

