/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.linux;

import com.ibm.jusb.os.linux.JavaxUsb;
import com.ibm.jusb.os.linux.LinuxRequestProxy;
import javax.usb.UsbException;

class LinuxDeviceProxy
extends LinuxRequestProxy {
    private Thread thread = null;
    private String key = null;
    private Runnable proxyRunnable = new Runnable(){

        @Override
        public void run() {
            JavaxUsb.nativeDeviceProxy(LinuxDeviceProxy.this);
        }
    };
    private Object startLock = new Object();
    private int startError = -1;

    public LinuxDeviceProxy(String k) {
        this.key = k;
    }

    public boolean isRunning() {
        try {
            return this.thread.isAlive();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws UsbException {
        Thread t = new Thread(this.proxyRunnable);
        t.setDaemon(true);
        t.setName("LinuxDeviceProxy " + this.getKey());
        Object object = this.startLock;
        synchronized (object) {
            t.start();
            try {
                this.startLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.startError != 0) {
            throw JavaxUsb.errorToUsbException(this.startError, "Could not connect to USB device");
        }
        this.thread = t;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCompleted(int error) {
        Object object = this.startLock;
        synchronized (object) {
            this.startError = error;
            this.startLock.notifyAll();
        }
    }
}

