/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.twistorr;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class TwisTorr84
extends Ascii {
    private static final Logger LOG = Logger.getLogger(TwisTorr84.class.getName());
    private final int BAUD_RATE = 9600;
    private final int TIMEOUT = 500;
    private static final int ACK_RESP_LEN = 6;
    private static final int DATA_OFFSET = 6;
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final byte ADDR = (byte)-128;
    private static final String[] errtypes = new String[]{"no_connection", "pump_overTemp", "controller_overTemp", "unused", "unused", "overVoltage", "shortCircuit", "overload"};
    private static final String Lbl = "TwisTorr84:  ";

    public static String decodeError(int errcode) {
        if (errcode == 0) {
            return "  no error";
        }
        String result = "";
        int code = errcode;
        int i = 0;
        while (i < 8) {
            if ((code & 1) != 0) {
                result = result + "  " + errtypes[i];
            }
            ++i;
            code >>>= 1;
        }
        return result;
    }

    public TwisTorr84() {
        super(Ascii.Option.NO_NET);
    }

    @Override
    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, baudRate == 0 ? 9600 : baudRate, 0);
        this.setTimeout(500);
        try {
            this.writeAndVerifyBool(CmndBool.REMOTE, Boolean.FALSE);
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(String serialName) throws DriverException {
        this.openSerial(serialName, 9600);
    }

    public boolean readBool(CmndBool cmnd) throws DriverException {
        String cmndText;
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr84:  Read not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(0);
        byte[] response = this.respToCommand(cmndBody, cmndText = "Read " + cmnd.toString(), 10);
        String str = new String(response, 6, 1);
        int istr = Integer.parseInt(str);
        if (istr == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void writeBool(CmndBool cmnd, boolean bdata) throws DriverException {
        if (!cmnd.writeAllowed) {
            throw new DriverException("TwisTorr84:  Write not allowed for " + cmnd.toString());
        }
        int data = 0;
        if (bdata) {
            data = 1;
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(1) + String.valueOf(data);
        String cmndText = "Write " + cmnd.toString();
        this.respToCommand(cmndBody, cmndText, 6);
    }

    public void writeAndVerifyBool(CmndBool cmnd, boolean bdata) throws DriverException {
        this.writeBool(cmnd, bdata);
        boolean value = this.readBool(cmnd);
        if (value != bdata) {
            throw new DriverException("Value of " + (Object)((Object)cmnd) + " = " + Boolean.toString(value) + " does not match setting = " + Boolean.toString(bdata));
        }
    }

    public int readNumeric(CmndNumeric cmnd) throws DriverException {
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr84:  Read not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(0);
        String cmndText = "Read " + cmnd.toString();
        byte[] response = this.respToCommand(cmndBody, cmndText, 15);
        String str = new String(response, 6, 6);
        return Integer.parseInt(str);
    }

    public void writeNumeric(CmndNumeric cmnd, int ndata) throws DriverException {
        if (!cmnd.writeAllowed) {
            throw new DriverException("TwisTorr84:  Write not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(1) + String.format("%06d", ndata);
        String cmndText = "Write " + cmnd.toString();
        this.respToCommand(cmndBody, cmndText, 6);
    }

    public void writeAndVerifyNumeric(CmndNumeric cmnd, int ndata) throws DriverException {
        this.writeNumeric(cmnd, ndata);
        int value = this.readNumeric(cmnd);
        if (value != ndata) {
            throw new DriverException("Value of " + (Object)((Object)cmnd) + " = " + Integer.toString(value) + " does not match setting = " + Integer.toString(ndata));
        }
    }

    public String readAlpha(CmndAlpha cmnd) throws DriverException {
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr84:  Read not allowed for " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(0);
        String cmndText = "Read " + cmnd.toString();
        byte[] response = this.respToCommand(cmndBody, cmndText, 19);
        String str = new String(response, 6, 10);
        return str;
    }

    public void writeAlpha(CmndAlpha cmnd, String adata) throws DriverException {
        if (!cmnd.readAllowed) {
            throw new DriverException("TwisTorr84:  Write not allowed for " + cmnd.toString());
        }
        if (adata.length() > 10) {
            throw new DriverException("TwisTorr84:  String exceeds 10 characters " + cmnd.toString());
        }
        String cmndBody = cmnd.getWindow() + String.valueOf(1) + String.format("%-10s", adata);
        String cmndText = "Write " + cmnd.toString();
        this.respToCommand(cmndBody, cmndText, 6);
    }

    private synchronized byte[] respToCommand(String commandBody, String cmndText, int expRespLen) throws DriverException {
        String status;
        byte[] command = new byte[commandBody.length() + 5];
        System.arraycopy(commandBody.getBytes(), 0, command, 2, commandBody.length());
        command[0] = 2;
        command[1] = -128;
        command[command.length - 3] = 3;
        byte[] commandCRC = this.computeCRC(command, 1, 2);
        System.arraycopy(commandCRC, 0, command, command.length - 2, 2);
        this.flush();
        long startTime = System.currentTimeMillis();
        this.writeBytes(command);
        byte[] response = this.read(expRespLen);
        if ((response.length == 6 || response[3] == 3) && (status = ConResp.decode(response[2])) != ConResp.ACK.toString()) {
            throw new DriverException("TwisTorr84:  error response " + status + " to " + cmndText);
        }
        long dt = System.currentTimeMillis() - startTime;
        LOG.log(Level.FINER, "{0} took {1} ms", new Object[]{cmndText, dt});
        if (dt >= 50L) {
            // empty if block
        }
        return response;
    }

    private byte[] read(int respLen) throws DriverException {
        byte[] buff = new byte[respLen];
        int curr = 0;
        do {
            curr += this.readBytes(buff, curr);
            try {
                curr += this.readBytes(buff, curr);
            }
            catch (DriverTimeoutException e) {
                throw new DriverTimeoutException((Object)((Object)e) + String.format(" -- after %d bytes read", curr));
            }
            if (curr != respLen && curr != 6 || buff[curr - 3] != 3) continue;
            byte[] crcByte = this.computeCRC(buff, 1, respLen - curr + 2);
            if (crcByte[0] == buff[curr - 2] && crcByte[1] == buff[curr - 1]) {
                return buff;
            }
            throw new DriverException("TwisTorr84:  incorrect CRC");
        } while (curr < Math.max(respLen, 6));
        throw new DriverException("TwisTorr84:  response too long");
    }

    private byte[] computeCRC(byte[] array, int omitFirst, int omitLast) {
        byte CRC = 0;
        int length = array.length;
        if (length - omitFirst - omitLast > 0) {
            for (int i = omitFirst; i < array.length - omitLast; ++i) {
                CRC = (byte)(CRC ^ array[i]);
            }
        }
        String crcString = String.format("%02X", CRC);
        byte[] crcBytes = crcString.getBytes();
        return crcBytes;
    }

    public static enum PumpStatus {
        STOP(0),
        WAIT_INTLK(1),
        STARTING(2),
        AUTO_TUNING(3),
        BRAKING(4),
        NORMAL(5),
        FAIL(6);

        private int status;

        private PumpStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static String decode(int code) throws DriverException {
            return PumpStatus.decodeStatus(code).toString();
        }

        public static PumpStatus decodeStatus(int code) throws DriverException {
            PumpStatus[] stat = PumpStatus.values();
            int n = stat.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (stat[i].status != code) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("TwisTorr84:  invalid status code");
            }
            return stat[found];
        }
    }

    public static enum ConResp {
        ACK(6),
        NACK(21),
        BAD_WINDOW(50),
        BAD_DATA_TYPE(51),
        OUT_OF_RANGE(52),
        DISABLED(53);

        private byte response;

        private ConResp(byte response) {
            this.response = response;
        }

        public static String decode(byte code) throws DriverException {
            ConResp[] con = ConResp.values();
            int n = con.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (con[i].response != code) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("TwisTorr84:  invalid response code");
            }
            return con[found].toString();
        }
    }

    public static enum CmndAlpha {
        PRESSURE_SET("162", true, true),
        PRESSURE("224", true, false);

        public static final int DATA_LENGTH = 10;
        public static final int READ_RESP_LEN = 19;
        public static final int WRITE_RESP_LEN = 6;
        private String window;
        private boolean readAllowed;
        private boolean writeAllowed;

        private CmndAlpha(String window, boolean readAllowed, boolean writeAllowed) {
            this.window = window;
            this.readAllowed = readAllowed;
            this.writeAllowed = writeAllowed;
        }

        public String getWindow() {
            return this.window;
        }
    }

    public static enum CmndNumeric {
        SETPOINT_TYPE("101", true, true),
        SETPOINT_VALUE("102", true, true),
        SETPOINT_DELAY("103", true, true),
        SETPOINT_HYST("105", true, true),
        BAUD_RATE("108", true, true),
        ANALOG_OUTPUT("111", true, true),
        ROTFREQ_LOW("117", true, true),
        ROTFREQ_SET("120", true, true),
        VENT_DELAY("126", true, true),
        EXT_FAN_CONFIG("143", true, true),
        VENT_OPENTIME("147", true, true),
        GAS_TYPE("157", true, true),
        PRESSURE_FACTOR("161", true, true),
        PRESSURE_UNIT("163", true, true),
        RS485_ADDR("503", true, false),
        MAXPOWER("155", true, false),
        CURRENT("200", true, false),
        VOLTAGE("201", true, false),
        POWER("202", true, false),
        DRIVEFREQ("203", true, false),
        PUMP_TEMP("204", true, false),
        STATUS("205", true, false),
        ERRCODE("206", true, false),
        CONT_TEMP_SINK("211", true, false),
        CONT_TEMP_AIR("216", true, false),
        RPM("226", true, false),
        CYCLE_TIME("300", true, false),
        CYCLE_NUMBER("301", true, false),
        PUMP_HOURS("302", true, false);

        public static final int DATA_LENGTH = 6;
        public static final int READ_RESP_LEN = 15;
        public static final int WRITE_RESP_LEN = 6;
        private String window;
        private boolean readAllowed;
        private boolean writeAllowed;

        private CmndNumeric(String window, boolean readAllowed, boolean writeAllowed) {
            this.window = window;
            this.readAllowed = readAllowed;
            this.writeAllowed = writeAllowed;
        }

        public String getWindow() {
            return this.window;
        }
    }

    public static enum CmndBool {
        START_STOP("000", true, true),
        LOW_SPEED("001", true, true),
        REMOTE("008", true, true),
        SOFT_START("100", true, true),
        SETPOINT_LEVEL("104", true, true),
        WATER_COOLING("106", true, true),
        ACTIVE_STOP("107", true, true),
        INTERLOCK_TYPE("110", true, true),
        VENTVALVE_OPEN("122", true, true),
        VENTVALVE_BY_CMND("125", true, true),
        VENTVALVE_TYPE("140", true, true),
        EXT_FAN_SETTING("144", true, true),
        GAS_TYPE_ARGON("157", true, true),
        SPEED_READ_ACTIVATE("167", true, true),
        SERIAL_TYPE("504", true, false),
        RESET_CYCLE_TIME("109", false, true);

        public static final int DATA_LENGTH = 1;
        public static final int READ_RESP_LEN = 10;
        public static final int WRITE_RESP_LEN = 6;
        private String window;
        private boolean readAllowed;
        private boolean writeAllowed;

        private CmndBool(String window, boolean readAllowed, boolean writeAllowed) {
            this.window = window;
            this.readAllowed = readAllowed;
            this.writeAllowed = writeAllowed;
        }

        public String getWindow() {
            return this.window;
        }
    }
}

