/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.tripplitepdu;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.tripplitepdu.TrippLitePDU;

public class TestTrippLitePDU {
    protected TrippLitePDU mydev;
    private int last_state = -1;
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open;

    @Command(name="open", description="Open a serial cnx to the PDU")
    public void open(@Argument(name="devId", description="The device ID of the device to open") String MyDevId) throws DriverException {
        this.mydev = new TrippLitePDU();
        this.mydev.openserial(MyDevId, 9600);
    }

    @Command(name="openserial", description="Open a serial connection to the PDU using default addr")
    public void openserial() throws DriverException {
        this.openserial("/dev/ttyS1");
    }

    @Command(name="openserial", description="Open a serial connection to the PDU")
    public void openserial(@Argument(name="devId", description="The device ID of the device to open") String MyDevId) throws DriverException {
        this.mydev = new TrippLitePDU();
        this.mydev.openserial(MyDevId, 9600);
    }

    @Command(name="opennet", description="Open a network connection to the PDU using default addr")
    public void opennet() throws DriverException {
        try {
            this.opennet("130.199.47.27", 23);
        }
        catch (DriverException ex) {
            System.out.println("opennet: DriverException: " + ex);
        }
    }

    @Command(name="opennet", description="Open a network connection to the PDU")
    public void opennet(@Argument(name="netaddr", description="The netaddr of the device to open - 130.199.47.172") String MyNetAddr, @Argument(name="port", description="port - 23") int port) throws DriverException {
        this.mydev = new TrippLitePDU();
        this.mydev.opennet(MyNetAddr, port, 3);
        this.open = true;
    }

    @Command(name="close", description="Close the device")
    public void close() throws Exception {
        this.mydev.close();
    }

    @Command(name="ison", description="is the outlet on")
    public boolean ison(@Argument(name="outlet", description="outlet number") int outlet) throws Exception {
        return this.mydev.isOutletOn(outlet);
    }

    @Command(name="setoutlet", description="set state of outlet")
    public void setoutlet(@Argument(name="outlet", description="outlet number") int outlet, @Argument(name="state", description="state to set") boolean state) throws Exception {
        this.mydev.setOutletState(outlet, state);
    }
}

