package org.lsst.ccs.drivers.tripplitepdu;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 ***************************************************************************
 **
 ** Program to test the TrippLitePDU device driver * * @author Homer *
 **************************************************************************
 */
public class TestTrippLitePDU {

    protected TrippLitePDU mydev;
    //    private final Thread readW = new Thread(new Reader());
    private int last_state = -1; // last channel state seen
    private int nRead = 0, nByte = 0, nTimeout = 0;
    private boolean open;

    @Command(name = "open", description = "Open a serial cnx to the PDU")
    public void open(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
    ) throws DriverException {

        mydev = new TrippLitePDU();
        mydev.openserial(MyDevId, 9600);
    }

    /*
     Outlet - Setup - Device:
     1 - S1 - Vacuum Gauge
     2 - S1 - PD & Bias
     3 - S1 - Archon Controller
     4 - S2 - Vacuum Gauge
     5 - S2 - PD & Bias
     6 - S2 - Archon Controller
     7 - S1 - Computer
     8 - S2 - Computer
     */

    @Command(name = "openserial", description = "Open a serial connection to the PDU using default addr")
    public void openserial() throws DriverException {

        this.openserial("/dev/ttyS1");
    }

    @Command(name = "openserial", description = "Open a serial connection to the PDU")
    public void openserial(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
    ) throws DriverException {

        mydev = new TrippLitePDU();
        mydev.openserial(MyDevId, 9600);
    }

    @Command(name = "opennet", description = "Open a network connection to the PDU using default addr")
    public void opennet() throws DriverException {

	try {
	    this.opennet("130.199.47.27", 23);
	} catch (DriverException ex) {
	    System.out.println("opennet: DriverException: "+ex);
	}
    }

    @Command(name = "opennet", description = "Open a network connection to the PDU")
    public void opennet(
            @Argument(name = "netaddr", description = "The netaddr of the device to open - 130.199.47.172") String MyNetAddr,
            @Argument(name = "port", description = "port - 23") int port
    ) throws DriverException {

        mydev = new TrippLitePDU();
        mydev.opennet(MyNetAddr, port,3);
        open = true;
//        mydev.setTimeout(60);
	//	readW.setDaemon(true);
	//	readW.start();

    }

    @Command(name = "close", description = "Close the device")
    public void close() throws Exception {
        mydev.close();
    }

    @Command(name = "ison", description = "is the outlet on")
    public boolean ison(@Argument(name = "outlet", description = "outlet number") int outlet
    ) throws Exception {
        return mydev.isOutletOn(outlet);
    }

    @Command(name = "setoutlet", description = "set state of outlet")
    public void setoutlet(
            @Argument(name = "outlet", description = "outlet number") int outlet,
            @Argument(name = "state", description = "state to set") boolean state
    ) throws Exception {
        mydev.setOutletState(outlet, state);
    }

}
