/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.srp;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.srp.Srp;

public class TestSrp {
    protected final Srp srp;
    protected final ConsThread consThread = new ConsThread();

    public TestSrp() {
        this.srp = new Srp();
    }

    public TestSrp(Srp srp) {
        this.srp = srp;
    }

    @Command(name="setsrpversion", description="Set the SRP version")
    public void setSrpVersion(@Argument(description="Version number") int version) {
        this.srp.setSrpVersion(version);
    }

    @Command(name="setdebug", description="Set the debug state")
    public void setDebug(@Argument(description="The state (on or off)") OnOff state) {
        this.srp.setDebug(state == OnOff.ON);
    }

    @Command(name="connect", description="Open connection to device")
    public void connect(@Argument(name="ipaddr", description="IP address") String ipAddr, @Argument(name="port", description="Port number") int port) throws DriverException {
        this.srp.open(ipAddr, port);
    }

    @Command(name="disconnect", description="Close connection to device")
    public void disconnect() throws DriverException {
        this.srp.close();
    }

    @Command(name="read", description="Read a register")
    public String read(@Argument(name="addr", description="Register address") int addr) throws DriverException {
        return String.format("%08x", this.srp.readReg(addr));
    }

    @Command(name="read", description="Reads registers")
    public String read(@Argument(name="addr", description="Register address") int addr, @Argument(name="count", description="Register count") int count) throws DriverException {
        return TestSrp.formatHex(addr, this.srp.readRegs(addr, count));
    }

    @Command(name="write", description="Write a register")
    public void write(@Argument(name="addr", description="Register address") int addr, int ... value) throws DriverException {
        this.srp.writeRegs(addr, value);
    }

    @Command(name="update", description="Update a register")
    public void update(@Argument(name="addr", description="Register address") int addr, @Argument(name="mask", description="Mask of bits to change") int mask, @Argument(name="value", description="Register value") int value) throws DriverException {
        this.srp.updateReg(addr, mask, value);
    }

    @Command(name="contread", description="Continuously read a set of registers")
    public String contRead(@Argument(description="First register address") int addr, @Argument(description="Number of registers") int count) throws DriverException {
        System.out.println("Press any key to terminate...");
        boolean[] done = new boolean[]{false};
        this.consThread.start(done);
        int nRead = 0;
        long startTime = System.currentTimeMillis();
        while (!done[0]) {
            this.srp.readRegs(addr, count);
            nRead += count;
        }
        return TestSrp.formatRate(startTime, nRead);
    }

    protected static String formatHex(int addr, int[] data) {
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < data.length; ++j) {
            if ((j & 3) == 0) {
                if (j > 0) {
                    text.append('\n');
                }
                text.append(String.format("%06x:", addr + j));
            }
            text.append(String.format(" %08x", data[j]));
        }
        return text.toString();
    }

    protected static String formatRate(long start, int count) {
        long period = System.currentTimeMillis() - start;
        return String.format("Read rate (Hz) = %.4g", (double)count * 1000.0 / (double)(period == 0L ? 1L : period));
    }

    protected class ConsThread
    extends Thread {
        private final BlockingQueue<Integer> consQueue = new ArrayBlockingQueue<Integer>(1);
        private boolean[] consDone;
        private Thread mainThread;

        ConsThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                this.awaitStart();
                this.awaitTerminal();
                this.consDone[0] = true;
                if (this.mainThread == null) continue;
                this.mainThread.interrupt();
            }
        }

        public void start(boolean[] done, boolean wake) {
            if (this.getState() == Thread.State.NEW) {
                this.start();
            }
            this.consDone = done;
            this.consDone[0] = false;
            this.mainThread = wake ? Thread.currentThread() : null;
            this.consQueue.offer(0);
        }

        public void start(boolean[] done) {
            this.start(done, false);
        }

        private void awaitStart() {
            while (true) {
                try {
                    this.consQueue.take();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void awaitTerminal() {
            block6: while (true) {
                try {
                    while (System.in.available() <= 0) {
                        try {
                            Thread.sleep(50L);
                            continue block6;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
            try {
                while (System.in.available() > 0) {
                    System.in.read();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

