/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.ftdi.FtdiInterface;

public class FtdiLocal
implements FtdiInterface {
    private long handle;
    private long eventHandle;

    @Override
    public void open(int index, String serial) throws DriverException {
        if (this.handle != 0L) {
            throw new DriverException("Device is already open");
        }
        this.handle = FtdiLocal.openJNI(index, serial);
        FtdiLocal.setDtrJNI(this.handle);
        FtdiLocal.setRtsJNI(this.handle);
    }

    @Override
    public void open(String node, int index, String serial) throws DriverException {
        throw new DriverException("Invalid remote open call");
    }

    @Override
    public void close() throws DriverException {
        long hndl = this.getHandle();
        long eventHndl = this.eventHandle;
        this.handle = 0L;
        this.eventHandle = 0L;
        FtdiLocal.closeJNI(hndl, eventHndl);
    }

    @Override
    public void setBaudrate(int baudrate) throws DriverException {
        FtdiLocal.setBaudrateJNI(this.getHandle(), baudrate);
    }

    @Override
    public void setDataCharacteristics(int wordLength, int stopBits, int parity) throws DriverException {
        FtdiLocal.setDataCharacteristicsJNI(this.getHandle(), wordLength, stopBits, parity);
    }

    @Override
    public void setFlowControl(int flow) throws DriverException {
        FtdiLocal.setFlowControlJNI(this.getHandle(), flow);
    }

    @Override
    public void setTimeouts(int rcveTimeout, int xmitTimeout) throws DriverException {
        FtdiLocal.setTimeoutsJNI(this.getHandle(), rcveTimeout, xmitTimeout);
    }

    @Override
    public void setDtr(boolean set) throws DriverException {
        if (set) {
            FtdiLocal.setDtrJNI(this.getHandle());
        } else {
            FtdiLocal.clrDtrJNI(this.getHandle());
        }
    }

    @Override
    public void setRts(boolean set) throws DriverException {
        if (set) {
            FtdiLocal.setRtsJNI(this.getHandle());
        } else {
            FtdiLocal.clrRtsJNI(this.getHandle());
        }
    }

    @Override
    public void enableEvents(int mask) throws DriverException {
        this.eventHandle = FtdiLocal.enableEventsJNI(this.getHandle(), this.eventHandle, mask);
    }

    @Override
    public int awaitEvent(int timeout) throws DriverException {
        if (this.eventHandle == 0L) {
            throw new DriverException("Events have not been enabled");
        }
        return FtdiLocal.awaitEventJNI(this.getHandle(), this.eventHandle, timeout);
    }

    @Override
    public int read(byte[] data) throws DriverException {
        return FtdiLocal.readJNI(this.getHandle(), data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int count) throws DriverException {
        return FtdiLocal.readJNI(this.getHandle(), data, offset, count);
    }

    @Override
    public int write(byte[] data) throws DriverException {
        return FtdiLocal.writeJNI(this.getHandle(), data, 0, data.length);
    }

    @Override
    public int write(byte[] data, int offset, int count) throws DriverException {
        return FtdiLocal.writeJNI(this.getHandle(), data, offset, count);
    }

    @Override
    public int getQueueStatus() throws DriverException {
        return FtdiLocal.getQueueStatusJNI(this.getHandle());
    }

    @Override
    public int getModemStatus() throws DriverException {
        return FtdiLocal.getModemStatusJNI(this.getHandle());
    }

    private long getHandle() throws DriverException {
        long hndl = this.handle;
        if (hndl == 0L) {
            throw new DriverException("Device is not open");
        }
        return hndl;
    }

    private static synchronized native long openJNI(int var0, String var1) throws DriverException;

    private static native void closeJNI(long var0, long var2) throws DriverException;

    private static native void setBaudrateJNI(long var0, int var2) throws DriverException;

    private static native void setDataCharacteristicsJNI(long var0, int var2, int var3, int var4) throws DriverException;

    private static native void setFlowControlJNI(long var0, int var2) throws DriverException;

    private static native void setTimeoutsJNI(long var0, int var2, int var3) throws DriverException;

    private static native void setDtrJNI(long var0) throws DriverException;

    private static native void clrDtrJNI(long var0) throws DriverException;

    private static native void setRtsJNI(long var0) throws DriverException;

    private static native void clrRtsJNI(long var0) throws DriverException;

    private static native long enableEventsJNI(long var0, long var2, int var4) throws DriverException;

    private static native int awaitEventJNI(long var0, long var2, int var4) throws DriverException;

    private static native int readJNI(long var0, byte[] var2, int var3, int var4) throws DriverException;

    private static native int writeJNI(long var0, byte[] var2, int var3, int var4) throws DriverException;

    private static native int getQueueStatusJNI(long var0) throws DriverException;

    private static native int getModemStatusJNI(long var0) throws DriverException;

    static {
        System.loadLibrary("Ftdi");
    }
}

