/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.sorensen;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.TestScpi;
import org.lsst.ccs.drivers.sorensen.Dcs;

public class TestDcs
extends TestScpi {
    protected final Dcs dcs;

    public TestDcs() {
        super(new Dcs());
        this.dcs = (Dcs)this.scpi;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") Ascii.ConnType type, @Argument(name="ident", description="Device identifier") String ident) throws DriverException {
        this.dcs.open(type, ident);
    }

    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.dcs.setVoltage(value);
    }

    @Command(name="showvoltage", description="Show the set voltage")
    public double getVoltage() throws DriverException {
        return this.dcs.getVoltage();
    }

    @Command(name="readvoltage", description="Read the actual voltage")
    public double readVoltage() throws DriverException {
        return this.dcs.readVoltage();
    }

    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        this.dcs.setVoltageLimit(value);
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public double getVoltageLimit() throws DriverException {
        return this.dcs.getVoltageLimit();
    }

    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.dcs.setCurrent(value);
    }

    @Command(name="showcurrent", description="Show the set current")
    public double getCurrent() throws DriverException {
        return this.dcs.getCurrent();
    }

    @Command(name="readcurrent", description="Read the actual current")
    public double readCurrent() throws DriverException {
        return this.dcs.readCurrent();
    }

    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) throws DriverException {
        this.dcs.setCurrentLimit(value);
    }

    @Command(name="showcurrlim", description="Show the soft current limit")
    public double getCurrentLimit() throws DriverException {
        return this.dcs.getCurrentLimit();
    }

    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state", description="Output state: on or off") onOff state) throws DriverException {
        this.dcs.setOutput(state == onOff.ON);
    }

    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException {
        return this.dcs.getOutput() ? "on" : "off";
    }

    @Command(name="setlocal", description="Turn local mode on or off")
    public void setLocal(@Argument(name="mode", description="Local mode: on or off") onOff mode) throws DriverException {
        this.dcs.setLocal(mode == onOff.ON);
    }

    @Command(name="showlocal", description="Show the local mode")
    public String showLocal() throws DriverException {
        return this.dcs.getLocal() ? "on" : "off";
    }

    @Command(name="showstatusblock", description="Show the source status block")
    public Dcs.StatusBlock getStatusBlock() throws DriverException {
        return this.dcs.getStatusBlock();
    }

    protected static enum onOff {
        OFF,
        ON;

    }
}

