/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.command.DictionaryArgument;

class MethodBasedDictionaryArgument
implements DictionaryArgument {
    private String name;
    private String description;
    private String type;
    private String simpleType;
    private String[] values;

    MethodBasedDictionaryArgument(String name, Class type, String description) {
        this.name = name;
        this.type = type.getCanonicalName();
        this.simpleType = type.getSimpleName();
        if (type.isEnum()) {
            Enum[] enums = (Enum[])type.getEnumConstants();
            this.values = new String[enums.length];
            int i = 0;
            while (i < enums.length) {
                this.values[i] = enums[i].name().toLowerCase();
                ++i;
            }
        }
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getSimpleType() {
        return this.simpleType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getValues() {
        return this.values == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(this.values));
    }

    String getDefaultValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

