/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.DefaultDictionaryCompleter;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryUtils;

class MethodBasedCommandDictionary
extends ArrayList<DictionaryCommand>
implements Dictionary {
    private static final long serialVersionUID = 4401762766383746012L;
    private final DefaultDictionaryCompleter completer = new DefaultDictionaryCompleter(this);

    MethodBasedCommandDictionary() {
    }

    @Override
    public boolean containsCommand(BasicCommand tc) {
        return this.findCommand(tc) != null;
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) {
        String command = tc.getCommand();
        int argumentCount = tc.getArgumentCount();
        ArrayList<DictionaryCommand> matches = new ArrayList<DictionaryCommand>();
        for (DictionaryCommand def : this) {
            if (!DictionaryUtils.commandMatch(def, tc)) continue;
            matches.add(def);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return (DictionaryCommand)matches.get(0);
        }
        throw new AmbiguousCommandException("Error finding command " + command + " with " + argumentCount + " arguments: " + matches.size() + " matches found in MethodBasedCommandDictionary");
    }

    @Override
    public DictionaryCompleter getDictionaryCompleter() {
        return this.completer;
    }
}

