/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestAscii {
    protected final Ascii dev;

    public TestAscii() {
        this.dev = new Ascii();
    }

    public TestAscii(Ascii dev) {
        this.dev = dev;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        this.dev.open(type.getValue(), ident, param);
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param1", description="First device parameter") int param1, @Argument(name="param2", description="Second device parameter") int param2) throws DriverException {
        this.dev.open(type.getValue(), ident, param1, param2);
    }

    @Command(name="close", description="Close connection to device")
    public void close() throws DriverException {
        this.dev.close();
    }

    @Command(name="write", description="Write command to device")
    public void write(@Argument(name="command", description="Command to write") String command) throws DriverException {
        this.dev.write(command);
    }

    @Command(name="read", description="Read response from device")
    public String read() throws DriverException {
        return this.dev.read();
    }

    @Command(name="read", description="Write command and read response")
    public String read(@Argument(name="command", description="Command to write") String command) throws DriverException {
        return this.dev.read(command);
    }

    @Command(name="timeout", description="Set read response timeout")
    public void timeout(@Argument(name="time", description="Timeout value (sec)") double time) throws DriverException {
        this.dev.setTimeout(time);
    }

    @Command(name="setterm", description="Set command terminator")
    public void setTerm(@Argument(name="term", description="Terminator string") String term) {
        char[] cTerm = new char[term.length()];
        term.getChars(0, cTerm.length, cTerm, 0);
        int jout = 0;
        int jin = 0;
        while (jin < cTerm.length) {
            if (cTerm[jin] == '\\' && jin < cTerm.length - 1) {
                switch (cTerm[++jin]) {
                    case 'r': {
                        cTerm[jin] = 13;
                        break;
                    }
                    case 'n': {
                        cTerm[jin] = 10;
                        break;
                    }
                    case 't': {
                        cTerm[jin] = 9;
                        break;
                    }
                    case 'b': {
                        cTerm[jin] = 8;
                        break;
                    }
                    case 'f': {
                        cTerm[jin] = 12;
                    }
                }
            }
            cTerm[jout++] = cTerm[jin];
            ++jin;
        }
        this.dev.setTerminator(new String(cTerm, 0, jout));
    }

    protected static enum ConnType {
        NET(0),
        FTDI(1),
        SERIAL(2);

        int value;

        private ConnType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

