/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ftdi.Ftdi;

public class AsciiIOFtdi
implements AsciiIO {
    Ftdi ftdi = new Ftdi();

    @Override
    public void open(String serial, int baud, int index) throws DriverException {
        this.ftdi.open(index, serial);
        this.ftdi.setBaudrate(baud);
    }

    @Override
    public void close() throws DriverException {
        this.ftdi.close();
    }

    @Override
    public void write(byte[] command) throws DriverException {
        this.ftdi.write(command);
    }

    @Override
    public int read(byte[] buff, int offset) throws DriverException {
        int leng = 0;
        int count = this.ftdi.getQueueStatus();
        if (count == 0) {
            leng = this.ftdi.read(buff, offset, 1);
            if (leng == 0) {
                throw new DriverTimeoutException("Read timed out");
            }
            ++offset;
            count = this.ftdi.getQueueStatus();
        }
        if (offset + count > buff.length) {
            count = buff.length - offset;
        }
        if (count > 0) {
            leng += this.ftdi.read(buff, offset, count);
        }
        return leng;
    }

    @Override
    public void flush() throws DriverException {
        int count = this.ftdi.getQueueStatus();
        if (count > 0) {
            byte[] buff = new byte[count];
            this.ftdi.read(buff, 0, count);
        }
    }

    @Override
    public void setTimeout(int timeout) throws DriverException {
        this.ftdi.setTimeouts(timeout, 0);
    }
}

