/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;

class RoutingDictionary
implements Dictionary {
    private LinkedHashMap<String, DictionaryCommand> routeMap = new LinkedHashMap();

    RoutingDictionary() {
    }

    void add(String route, Dictionary dict) {
        this.routeMap.put(route, new RoutingCommand(route, dict));
    }

    void remove(String route) {
        this.routeMap.remove(route);
    }

    @Override
    public boolean containsCommand(BasicCommand tc) {
        return this.containsCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) {
        return this.findCommand(tc.getCommand(), tc.getArgumentCount());
    }

    @Override
    public boolean containsCommand(String command, int argumentCount) {
        return this.routeMap.containsKey(command);
    }

    @Override
    public DictionaryCommand findCommand(String command, int argumentCount) {
        return this.routeMap.get(command);
    }

    @Override
    public int size() {
        return this.routeMap.size();
    }

    @Override
    public Iterator<DictionaryCommand> iterator() {
        return this.routeMap.values().iterator();
    }

    private static class RoutingArgument
    implements DictionaryArgument {
        private RoutingArgument() {
        }

        @Override
        public String getDescription() {
            return "The command to execute";
        }

        @Override
        public String getName() {
            return "command...";
        }

        @Override
        public String getSimpleType() {
            return "String";
        }

        @Override
        public String getType() {
            return "java.lang.String";
        }

        @Override
        public List<String> getValues() {
            return Collections.emptyList();
        }
    }

    private static class RoutingCommand
    implements DictionaryCommand {
        private final String route;
        private final Dictionary dict;
        private static final DictionaryArgument[] THE_COMMAND = new DictionaryArgument[]{new RoutingArgument()};

        private RoutingCommand(String route, Dictionary dict) {
            this.route = route;
            this.dict = dict;
        }

        @Override
        public String[] getAliases() {
            return NO_ALIASES;
        }

        @Override
        public DictionaryArgument[] getArguments() {
            return THE_COMMAND;
        }

        @Override
        public String getCommandName() {
            return this.route;
        }

        @Override
        public String getDescription() {
            return "Route command to a different dictionary";
        }

        @Override
        public Command.CommandType getType() {
            return Command.CommandType.QUERY;
        }

        @Override
        public boolean isVarArgs() {
            return true;
        }

        @Override
        public boolean matchesCommandOrAlias(String value) {
            return this.route.equals(value);
        }
    }
}

