/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.sorensen;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.sorensen.Dcs;

public class MonitorDcs {
    private static final PrintStream out = System.out;
    private final Dcs dcs = new Dcs();
    private final Timer monTimer = new Timer();
    private double period = 5.0;
    private boolean running;
    private PrintStream log;

    public MonitorDcs() throws DriverException {
        this.dcs.open(2, "/dev/ttyUSB0", 19200);
    }

    @Command(name="voltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) throws DriverException {
        this.dcs.setVoltage(value);
    }

    @Command(name="voltage", description="Read the actual voltage")
    public double readVoltage() throws DriverException {
        return this.dcs.readVoltage();
    }

    @Command(name="current", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) throws DriverException {
        this.dcs.setCurrent(value);
    }

    @Command(name="current", description="Read the actual current")
    public double readCurrent() throws DriverException {
        return this.dcs.readCurrent();
    }

    @Command(name="period", description="Set the sampling period")
    public void setPeriod(@Argument(name="period", description="Sampling period") double period) {
        this.period = period;
    }

    @Command(name="period", description="Show the sampling period")
    public double showPeriod() {
        return this.period;
    }

    @Command(name="start", description="Start the monitoring")
    public void start() {
        this.running = true;
        this.monTimer.schedule((TimerTask)new Monitor(), 0L, (long)(1000.0 * this.period));
    }

    @Command(name="stop", description="Stop the monitoring")
    public void stop() {
        this.running = false;
    }

    @Command(name="open", description="Open the log file")
    public void open(@Argument(name="name", description="Log file name") String name) throws IOException {
        this.close();
        this.log = new PrintStream(name);
    }

    @Command(name="close", description="Close the log file")
    public void close() throws IOException {
        PrintStream logx = this.log;
        if (logx != null) {
            this.log = null;
            logx.close();
        }
    }

    class Monitor
    extends TimerTask {
        Monitor() {
        }

        @Override
        public void run() {
            if (!MonitorDcs.this.running) {
                this.cancel();
            } else {
                try {
                    double voltage = MonitorDcs.this.dcs.readVoltage();
                    double current = MonitorDcs.this.dcs.readCurrent();
                    out.print("\r");
                    out.format("%.3f  %.3f  ", voltage, current);
                    if (MonitorDcs.this.log != null) {
                        Date ts = new Date();
                        MonitorDcs.this.log.format("%tY-%<tm-%<td\t%<tH:%<tM:%<tS\t%.3f\t%.3f\n", ts, voltage, current);
                    }
                }
                catch (DriverException e) {
                    out.println("Cannot read data: " + (Object)((Object)e));
                    this.cancel();
                }
            }
        }
    }
}

