package org.lsst.ccs.drivers.sorensen;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.TestScpi;

/**
 *************************************************************************** 
 ** 
 **  Program to test the SCPI device driver
 ** 
 **  @author Owen Saxton
 ** 
 *************************************************************************** 
 */
public class TestDcs extends TestScpi {

    private Dcs dcs = new Dcs();

    public enum onOff {
        OFF, ON;
    }


   /**
    *************************************************************************** 
    ** 
    **  Constructor
    ** 
    *************************************************************************** 
    */
    public TestDcs()
    {
        scpi = dcs;
    }


   /**
    *************************************************************************** 
    ** 
    **  Opens connection to a device.
    ** 
    *************************************************************************** 
    */
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type",
                               description="Connection type: net, serial or ftdi")
                     ConnType type,
                     @Argument(name="ident", description="Device identifier")
                     String ident
                     ) throws DriverException
    {
        dcs.open(type.getValue(), ident);
    }


   /**
    *************************************************************************** 
    ** 
    **  Opens connection to a device.
    ** 
    *************************************************************************** 
    */
    @Override
    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type",
                               description="Connection type: net, serial or ftdi")
                     ConnType type,
                     @Argument(name="ident", description="Device identifier")
                     String ident,
                     @Argument(name="param", description="Device parameter")
                     int param
                     ) throws DriverException
    {
        dcs.open(type.getValue(), ident, param);
    }


   /**
    *************************************************************************** 
    ** 
    **  Sets the voltage.
    ** 
    *************************************************************************** 
    */
    @Command(name="setvoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set")
                           double value) throws DriverException
    {
        dcs.setVoltage(value);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the set voltage.
    ** 
    *************************************************************************** 
    */
    @Command(name="showvoltage", description="Show the set voltage")
    public double getVoltage() throws DriverException
    {
        return dcs.getVoltage();
    }


   /**
    *************************************************************************** 
    ** 
    **  Reads the actual voltage.
    ** 
    *************************************************************************** 
    */
    @Command(name="readvoltage", description="Read the actual voltage")
    public double readVoltage() throws DriverException
    {
        return dcs.readVoltage();
    }


   /**
    *************************************************************************** 
    ** 
    **  Sets the soft voltage limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="setvoltlim", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value",
                                          description="Voltage limit to set")
                           double value) throws DriverException
    {
        dcs.setVoltageLimit(value);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the soft voltage limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public double getVoltageLimit() throws DriverException
    {
        return dcs.getVoltageLimit();
    }


   /**
    *************************************************************************** 
    ** 
    **  Sets the current.
    ** 
    *************************************************************************** 
    */
    @Command(name="setcurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set")
                           double value) throws DriverException
    {
        dcs.setCurrent(value);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the set current.
    ** 
    *************************************************************************** 
    */
    @Command(name="showcurrent", description="Show the set current")
    public double getCurrent() throws DriverException
    {
        return dcs.getCurrent();
    }


   /**
    *************************************************************************** 
    ** 
    **  Reads the actual current.
    ** 
    *************************************************************************** 
    */
    @Command(name="readcurrent", description="Read the actual current")
    public double readCurrent() throws DriverException
    {
        return dcs.readCurrent();
    }


   /**
    *************************************************************************** 
    ** 
    **  Sets the soft current limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="setcurrlim", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value",
                                          description="Current limit to set")
                           double value) throws DriverException
    {
        dcs.setCurrentLimit(value);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the soft current limit.
    ** 
    *************************************************************************** 
    */
    @Command(name="showcurrlim", description="Show the soft current limit")
    public double getCurrentLimit() throws DriverException
    {
        return dcs.getCurrentLimit();
    }


   /**
    *************************************************************************** 
    ** 
    **  Turns the output on or off.
    ** 
    *************************************************************************** 
    */
    @Command(name="setoutput", description="Turn output on or off")
    public void setOutput(@Argument(name="state",
                                    description="Output state: on or off")
                          onOff state) throws DriverException
    {
        dcs.setOutput(state == onOff.ON);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the output state.
    ** 
    *************************************************************************** 
    */
    @Command(name="showoutput", description="Show the output state")
    public String showOutput() throws DriverException
    {
        return dcs.getOutput() ? "on" : "off";
    }


   /**
    *************************************************************************** 
    ** 
    **  Turns local mode on or off.
    ** 
    *************************************************************************** 
    */
    @Command(name="setlocal", description="Turn local mode on or off")
    public void setLocal(@Argument(name="mode",
                                   description="Local mode: on or off")
                         onOff mode) throws DriverException
    {
        dcs.setLocal(mode == onOff.ON);
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the local mode.
    ** 
    *************************************************************************** 
    */
    @Command(name="showlocal", description="Show the local mode")
    public String showLocal() throws DriverException
    {
        return dcs.getLocal() ? "on" : "off";
    }


   /**
    *************************************************************************** 
    ** 
    **  Shows the source status block.
    ** 
    *************************************************************************** 
    */
    @Command(name="showstatusblock", description="Show the source status block")
    public Dcs.StatusBlock getStatusBlock() throws DriverException
    {
        return dcs.getStatusBlock();
    }

}
