/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.MethodBasedCommandDictionary;
import org.lsst.ccs.command.MethodBasedDictionaryCommand;
import org.lsst.ccs.command.annotations.Command;

public class CommandDictionaryBuilder {
    private MethodBasedCommandDictionary dict;
    private final Map<DictionaryCommand, Method> methods = new HashMap<DictionaryCommand, Method>();

    public CommandDictionaryBuilder(Class klass) throws AmbiguousCommandException {
        this.init(klass);
    }

    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    Method getMethod(BasicCommand command) throws CommandArgumentMatchException {
        DictionaryCommand dc = this.dict.findCommand(command);
        if (dc == null) {
            return null;
        }
        return this.methods.get(dc);
    }

    private void init(Class targetClass) throws AmbiguousCommandException {
        this.dict = new MethodBasedCommandDictionary();
        for (Method targetMethod : targetClass.getMethods()) {
            DictionaryCommand dc = CommandDictionaryBuilder.getDictionaryCommandFromMethod(targetMethod);
            if (dc == null) continue;
            if (DictionaryUtils.containsDictionaryCommand(this.dict, dc)) {
                throw new AmbiguousCommandException(String.format("Ambiguous command with name %s and %d arguments in class %s", dc.getCommandName(), dc.getArguments().length, targetClass.getName()));
            }
            this.dict.add(dc);
            this.methods.put(dc, targetMethod);
        }
    }

    static DictionaryCommand getDictionaryCommandFromMethod(Method targetMethod) {
        Command annotation;
        Method annotatedMethod = CommandDictionaryBuilder.getAnnotationWithInheritance(targetMethod, Command.class);
        if (annotatedMethod != null && (annotation = annotatedMethod.getAnnotation(Command.class)) != null) {
            return new MethodBasedDictionaryCommand(annotatedMethod, annotation);
        }
        return null;
    }

    private static <T extends Annotation> Method getAnnotationWithInheritance(Method method, Class<T> annotationClass) {
        while (true) {
            T annotation;
            if ((annotation = method.getAnnotation(annotationClass)) != null) {
                return method;
            }
            Class<?> superClass = method.getDeclaringClass().getSuperclass();
            if (superClass == null) break;
            try {
                method = superClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException ex) {
                break;
            }
        }
        return null;
    }
}

