/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandDictionaryBuilder;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class CommandSetBuilder {
    private final InputConversionEngine engine = new InputConversionEngine();

    public CommandSet buildCommandSet(Object object) {
        Class<?> targetClass = object.getClass();
        CommandDictionaryBuilder dictionary = new CommandDictionaryBuilder(targetClass);
        CommandSetImplementation commandSet = new CommandSetImplementation(dictionary, object);
        return commandSet;
    }

    private class CommandSetImplementation
    implements CommandSet {
        private final CommandDictionaryBuilder dict;
        private final Object target;

        private CommandSetImplementation(CommandDictionaryBuilder dict, Object target) {
            this.dict = dict;
            this.target = target;
        }

        @Override
        public Dictionary getCommandDictionary() {
            return this.dict.getCommandDictionary();
        }

        @Override
        public Object invoke(BasicCommand command) throws CommandInvocationException, CommandArgumentMatchException {
            Method method = this.dict.getMethod(command);
            if (method == null) {
                throw new CommandInvocationException("Error: No handler found for command %s with %d arguments", command.getCommand(), command.getArgumentCount());
            }
            return this.invoke(this.target, method, command);
        }

        private Object invoke(Object target, Method method, BasicCommand command) throws CommandInvocationException {
            try {
                RawCommand raw = RawCommand.toRawCommand(command, method, CommandSetBuilder.this.engine);
                return method.invoke(target, raw.getArguments());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                int i;
                String msg = "Error: Can't invoke command " + command.prettyToString() + "\n";
                msg = msg + "Attempted to invoke it on method " + method.getName() + " on object " + target.getClass().getCanonicalName() + " (" + target + ")\n";
                int pars = method.getParameterCount();
                msg = msg + "Method " + method.getName() + " requires " + pars + " parameters of type: \n";
                for (i = 0; i < pars; ++i) {
                    Parameter p = method.getParameters()[i];
                    msg = msg + "-" + i + "- " + p.getName() + " " + p.getType().getCanonicalName() + "\n";
                }
                msg = msg + "Command " + command.getCommand() + " has " + command.getArgumentCount() + " arguments\n";
                for (i = 0; i < command.getArgumentCount(); ++i) {
                    Object a = command.getArguments()[i];
                    msg = msg + "-" + i + "i " + a + " " + a.getClass().getCanonicalName() + "\n";
                }
                throw new CommandInvocationException(msg, ex);
            }
            catch (InvocationTargetException ex) {
                throw new CommandInvocationException(ex);
            }
        }
    }
}

