/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import java.io.OutputStream;
import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class TalkScpi {
    private static final PrintStream out = System.out;
    private static final String[] terms = new String[]{"\r\n", "\r", "\n"};
    private final Scpi scpi = new Scpi();

    public static void main(String[] args) {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
            if (optns.showHelp) {
                TalkScpi.showHelp(parser);
            } else {
                new TalkScpi().run(optns);
            }
        }
        catch (CmdLineException e) {
            if (!optns.showHelp) {
                out.println(e.getMessage());
            }
            TalkScpi.showHelp(parser);
        }
        catch (Exception e) {
            out.println(e);
        }
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        String line;
        this.scpi.open(optns.type.getValue(), optns.ident, optns.parm, Scpi.makeDataCharacteristics((Ascii.DataBits)optns.dataBits, (Ascii.StopBits)optns.stopBits, (Ascii.Parity)optns.parity, (Ascii.FlowCtrl)optns.flowCtrl));
        this.scpi.setTimeout(optns.timeout);
        this.scpi.setTerminator(terms[optns.term.ordinal()]);
        ConsoleReader readC = new ConsoleReader();
        out.println("Connected. Type CTRL-D to exit.");
        while ((line = readC.readLine(">> ")) != null) {
            if (line.equals("")) continue;
            try {
                if (line.endsWith("?")) {
                    out.println(this.scpi.readString(line));
                    continue;
                }
                this.scpi.writeCommand(line);
            }
            catch (DriverException e) {
                out.println((Object)e);
            }
        }
        out.println();
        this.scpi.close();
    }

    private static void showHelp(CmdLineParser parser) {
        out.println("Usage: TalkScpi [options...] <ident> <parm>");
        out.println("Parameters & options:");
        parser.printUsage((OutputStream)out);
    }

    private static enum ConnType {
        NET(0),
        FTDI(1),
        SERIAL(2);

        int value;

        private ConnType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class Options {
        @Option(name="-c", metaVar="<connType>", usage="connection type: net (default), ftdi or serial")
        private ConnType type = ConnType.NET;
        @Option(name="-p", metaVar="<parity>", usage="Parity: none (default), odd, even, mark or space")
        private Ascii.Parity parity = Ascii.Parity.NONE;
        @Option(name="-d", metaVar="<dbits>", usage="No. data bits: eight (default) or seven")
        private Ascii.DataBits dataBits = Ascii.DataBits.EIGHT;
        @Option(name="-s", metaVar="<sbits>", usage="No. stop bits: one (default) or two")
        private Ascii.StopBits stopBits = Ascii.StopBits.ONE;
        @Option(name="-f", metaVar="<flow>", usage="Flow control: none (default), rts, dtr or xon")
        private Ascii.FlowCtrl flowCtrl = Ascii.FlowCtrl.NONE;
        @Option(name="-r", metaVar="<timeout>", usage="Read timeout (sec) (default = 1.0)")
        private double timeout = 1.0;
        @Option(name="-t", metaVar="<term>", usage="Command terminator: crlf (default), cr or lf")
        private Terminator term = Terminator.CRLF;
        @Option(name="-help", usage="Displays this help")
        private boolean showHelp;
        @Argument(index=0, required=true, metaVar="<ident>", usage="Device identifier (node, serial no. or device name)")
        private String ident;
        @Argument(index=1, required=true, metaVar="<parm>", usage="Device parameter (port number or baud rate)")
        private int parm;

        private Options() {
        }
    }

    private static enum Terminator {
        CRLF,
        CR,
        LF;

    }
}

