/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import java.io.OutputStream;
import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class TalkScpi {
    private static final PrintStream out = System.out;
    private static final String[] terms = new String[]{"\r\n", "\r", "\n"};
    private final Scpi scpi = new Scpi();

    public static void main(String[] args) {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
            new TalkScpi().run(optns);
        }
        catch (CmdLineException e) {
            out.println(e.getMessage());
            System.err.println("Usage: TalkScpi [options...] <ident> <parm>");
            parser.printUsage((OutputStream)System.err);
        }
        catch (Exception e) {
            out.println(e);
        }
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        String line;
        this.scpi.open(optns.type.getValue(), optns.ident, optns.parm, optns.index);
        this.scpi.setTimeout(optns.timeout);
        this.scpi.setTerminator(terms[optns.term.ordinal()]);
        ConsoleReader readC = new ConsoleReader();
        while ((line = readC.readLine("")) != null) {
            if (line.equals("")) continue;
            try {
                if (line.endsWith("?")) {
                    out.println(this.scpi.readString(line));
                    continue;
                }
                this.scpi.writeCommand(line);
            }
            catch (DriverException e) {
                out.println((Object)e);
            }
        }
        this.scpi.close();
    }

    private static enum ConnType {
        NET(0),
        FTDI(1),
        SERIAL(2);

        int value;

        private ConnType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class Options {
        @Option(name="-c", metaVar="<connType>", usage="connection type: NET (default), FTDI or SERIAL")
        private ConnType type = ConnType.NET;
        @Option(name="-r", metaVar="<timeout>", usage="read timeout (sec) (default = 1)")
        private double timeout = 1.0;
        @Option(name="-i", metaVar="<index>", usage="FTDI device index (default = 0)")
        private int index = 0;
        @Option(name="-t", metaVar="<term>", usage="command terminator: CRLF (default), CR or LF")
        private Terminator term = Terminator.CRLF;
        @Argument(index=0, required=true, metaVar="<ident>", usage="device identifier (node, serial or device)")
        private String ident;
        @Argument(index=1, required=true, metaVar="<parm>", usage="device parameter (port number or baud rate)")
        private int parm;

        private Options() {
        }
    }

    private static enum Terminator {
        CRLF,
        CR,
        LF;

    }
}

