/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.sa;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Scanner;

public class CmndProc {
    public static final int CMD_AMBIG = -2;
    public static final int CMD_UNKNOWN = -1;
    private static final PrintStream out = System.out;
    private LinkedList<Dispatch> disps = new LinkedList();
    private LinkedList<Command> cmnds = new LinkedList();
    private static final int CMD_HELPSUMM = 0;
    private static final int CMD_HELP = 1;
    private static final int CMD_EXIT = 2;
    private static final String[] helpHelp = new String[]{"Display help", "help  [<command>]", "command    Optional command for which help is wanted"};
    private static final String[] helpExit = new String[]{"Exit the program", "exit"};
    private static final String[] helpQuit = new String[]{"Exit the program", "quit"};
    private static final Command cmnd = new Command(4);
    private static final String[] typeDesc;

    static {
        cmnd.add("help", 1, helpHelp);
        cmnd.add("?", 0, null);
        cmnd.add("exit", 2, helpExit);
        cmnd.add("quit", 2, helpQuit);
        typeDesc = new String[]{"string", "byte", "short", "integer", "keywdint", "keyword", "float", "double"};
    }

    public CmndProc() {
        new Common();
    }

    public void add(Dispatch disp, Command cmnd) {
        int j = 0;
        while (j < cmnd.count()) {
            int code = this.findCmnd(cmnd.name(j));
            if (code >= 0) {
                cmnd.disable(j);
            }
            ++j;
        }
        this.disps.add(disp);
        this.cmnds.add(cmnd);
    }

    public boolean process(String line) {
        Scanner scan = new Scanner(line);
        if (!scan.hasNext()) {
            return true;
        }
        String command = scan.next().toLowerCase();
        int index = this.findCmnd(command);
        if (index < 0) {
            out.println(String.valueOf(index == -1 ? "Unknown" : "Ambiguous") + " command (" + command + ")");
            return true;
        }
        int code = this.cmnds.get(index >> 16).code(index & 0xFFFF);
        return this.disps.get(index >> 16).dispatch(code, scan);
    }

    public static int scanArgs(Scanner scan, String types, Object[] args, Lookup ... lookup) {
        int found = 0;
        int kInc = 0;
        int j = 0;
        int k = 0;
        while (j < types.length()) {
            String type = types.substring(j, j + 1);
            String upType = type.toUpperCase();
            boolean required = type.equals(upType);
            int iType = "SBWILKFD".indexOf(upType);
            if (iType < 0) {
                out.println("Invalid argument type specified (" + type + ")");
                return -1;
            }
            if (!scan.hasNext()) {
                if (required) {
                    out.println("Missing argument (" + (j + 1) + ")");
                    return -1;
                }
            } else {
                String arg = scan.next();
                int n = kInc = iType == 4 || iType == 5 ? 1 : 0;
                if (required || !arg.equals("*")) {
                    block18: {
                        try {
                            if (iType == 0) {
                                args[j] = arg;
                            } else if (iType < 5) {
                                long value = Long.decode(arg);
                                long sMask = -1L << (iType == 4 ? 32 : 1 << iType + 2);
                                long sBits = value & sMask;
                                if (value >= 0L && sBits != 0L || value < 0L && (sBits != sMask || value == sMask)) {
                                    throw new NumberFormatException();
                                }
                                args[j] = iType == 1 ? (Number)((byte)value) : (Number)(iType == 2 ? (Number)((short)value) : (Number)((int)value));
                            } else if (iType == 5) {
                                int value = lookup[k].encode(arg, false);
                                if (value < 0) {
                                    throw new NumberFormatException();
                                }
                                args[j] = value;
                            } else {
                                args[j] = iType == 6 ? (Number)Float.valueOf(arg) : (Number)Double.valueOf(arg);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            int value;
                            boolean okay = false;
                            if (iType == 4 && (value = lookup[k].encode(arg, false)) >= 0) {
                                args[j] = value;
                                okay = true;
                            }
                            if (okay) break block18;
                            out.println("Invalid " + typeDesc[iType] + " argument (" + arg + ")");
                            return -1;
                        }
                    }
                    found |= 1 << j;
                }
            }
            ++j;
            k += kInc;
        }
        if (scan.hasNext()) {
            out.println("Too many arguments");
            return -1;
        }
        return found;
    }

    private int findCmnd(String command) {
        int index = -1;
        int cIndx = 0;
        int j = 0;
        while (j < this.cmnds.size()) {
            int tIndex = this.cmnds.get(j).find(command);
            if (tIndex >= 0) {
                index = tIndex;
                cIndx = j;
                break;
            }
            if (tIndex == -2) {
                index = -2;
            }
            if (tIndex < -2) {
                if (index == -1) {
                    index = tIndex;
                    cIndx = j;
                } else {
                    index = -2;
                }
            }
            ++j;
        }
        if (index < -2) {
            index = -3 - index;
        }
        if (index >= 0) {
            index |= cIndx << 16;
        }
        return index;
    }

    private void showHelpSumm(String command) {
        int maxLeng = 0;
        int j = 0;
        while (j < this.cmnds.size()) {
            int leng = this.cmnds.get(j).getMaxLeng(command);
            if (leng > maxLeng) {
                maxLeng = leng;
            }
            ++j;
        }
        j = 0;
        while (j < this.cmnds.size()) {
            this.cmnds.get(j).showHelpSumm(command, maxLeng);
            ++j;
        }
    }

    public static class Command {
        private int nCmnd = 0;
        private int[] cmdCode;
        private String[] cmdName;
        private String[][] cmdHelp;

        public Command(int count) {
            this.cmdCode = new int[count];
            this.cmdName = new String[count];
            this.cmdHelp = new String[count][];
        }

        public void add(String command, int code, String[] help) {
            this.cmdName[this.nCmnd] = command;
            this.cmdCode[this.nCmnd] = code;
            this.cmdHelp[this.nCmnd] = help;
            ++this.nCmnd;
        }

        public int count() {
            return this.nCmnd;
        }

        public int find(String command) {
            int index = 0;
            int match = 0;
            int j = 0;
            while (j < this.nCmnd) {
                String name = this.cmdName[j];
                if (name != null && name.startsWith(command)) {
                    if (name.equals(command)) {
                        return j;
                    }
                    index = j;
                    ++match;
                }
                ++j;
            }
            if (match == 0) {
                return -1;
            }
            if (match > 1) {
                return -2;
            }
            return -3 - index;
        }

        public void disable(int index) {
            if (index >= 0) {
                this.cmdName[index] = null;
            }
        }

        public String name(int index) {
            return index >= 0 ? this.cmdName[index] : null;
        }

        public int code(int index) {
            return index >= 0 ? this.cmdCode[index] : index;
        }

        public String[] help(int index) {
            return index >= 0 ? this.cmdHelp[index] : null;
        }

        public void showHelp(int index) {
            String[] text = this.cmdHelp[index];
            if (text == null) {
                return;
            }
            out.println("Description:");
            out.println("  " + text[0]);
            out.println("Usage:");
            out.println("  " + text[1]);
            if (text.length > 2) {
                out.println("Parameters:");
            }
            int j = 2;
            while (j < text.length) {
                out.println("  " + text[j]);
                ++j;
            }
        }

        public int getMaxLeng(String command) {
            int maxLeng = 0;
            int j = 0;
            while (j < this.nCmnd) {
                String name = this.cmdName[j];
                if (name != null && (command == null || name.startsWith(command)) && name.length() > maxLeng) {
                    maxLeng = name.length();
                }
                ++j;
            }
            return maxLeng;
        }

        public void showHelpSumm(String command) {
            this.showHelpSumm(command, this.getMaxLeng(command));
        }

        public void showHelpSumm(String command, int maxLeng) {
            StringBuilder blanks = new StringBuilder(maxLeng + 2);
            int j = 0;
            while (j < blanks.capacity()) {
                blanks.append(" ");
                ++j;
            }
            j = 0;
            while (j < this.nCmnd) {
                String[] text;
                String name = this.cmdName[j];
                if (name != null && (command == null || name.startsWith(command)) && (text = this.cmdHelp[j]) != null) {
                    out.format("  %s%s%s\n", name, blanks.substring(name.length()), text[0]);
                }
                ++j;
            }
        }
    }

    private class Common
    implements Dispatch {
        public Common() {
            CmndProc.this.add(this, cmnd);
        }

        @Override
        public boolean dispatch(int code, Scanner scan) {
            boolean cont = true;
            Object[] args = new Object[1];
            switch (code) {
                case 1: {
                    int found = CmndProc.scanArgs(scan, "s", args, new Lookup[0]);
                    if (found == -1) break;
                    if (found != 0) {
                        String command = ((String)args[0]).toLowerCase();
                        int index = CmndProc.this.findCmnd(command);
                        if (index >= 0) {
                            ((Command)CmndProc.this.cmnds.get(index >> 16)).showHelp(index & 0xFFFF);
                            break;
                        }
                        if (index == -2) {
                            out.println("Matching commands are:");
                            CmndProc.this.showHelpSumm(command);
                            break;
                        }
                        out.println("No matching commands");
                        break;
                    }
                }
                case 0: {
                    out.println("Valid commands are:");
                    CmndProc.this.showHelpSumm(null);
                    break;
                }
                case 2: {
                    cont = false;
                }
            }
            return cont;
        }
    }

    public static interface Dispatch {
        public boolean dispatch(int var1, Scanner var2);
    }

    public static class Lookup {
        private int nItem = 0;
        private String[] names;
        private int[] codes;

        public Lookup(int count) {
            this.codes = new int[count];
            this.names = new String[count];
        }

        public void add(String name, int code) {
            this.names[this.nItem] = name;
            this.codes[this.nItem] = code;
            ++this.nItem;
        }

        public int encode(String name, boolean report) {
            int index = 0;
            int match = 0;
            String lcName = name.toLowerCase();
            int j = 0;
            while (j < this.names.length) {
                String tName = this.names[j].toLowerCase();
                if (tName.startsWith(lcName)) {
                    index = j;
                    ++match;
                    if (tName.equals(lcName)) {
                        match = 1;
                        break;
                    }
                }
                ++j;
            }
            if (match == 1) {
                return this.codes[index];
            }
            if (report) {
                out.println(String.valueOf(match == 0 ? "Unrecognized" : "Ambiguous") + " value: " + name);
            }
            return match == 0 ? -1 : -2;
        }

        public String decode(int code) {
            int j = 0;
            while (j < this.codes.length) {
                if (code == this.codes[j]) {
                    return this.names[j];
                }
                ++j;
            }
            return "Invalid";
        }

        public int count() {
            return this.nItem;
        }

        public int code(int index) {
            return this.codes[index];
        }

        public String name(int index) {
            return this.names[index];
        }
    }
}

