/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;
import org.lsst.ccs.drivers.scpi.ScpiComm;

public class ScpiCommFtdi
implements ScpiComm {
    Ftdi ftdi = new Ftdi();

    @Override
    public void open(String serial, int baud) throws DriverException {
        try {
            this.ftdi.open(0, serial);
            this.ftdi.setBaudrate(baud);
        }
        catch (FtdiException e) {
            throw new DriverException((Throwable)((Object)e));
        }
    }

    @Override
    public void close() throws DriverException {
        try {
            this.ftdi.close();
        }
        catch (FtdiException e) {
            throw new DriverException((Throwable)((Object)e));
        }
    }

    @Override
    public void write(byte[] command) throws DriverException {
        try {
            this.ftdi.write(command);
        }
        catch (FtdiException e) {
            throw new DriverException((Throwable)((Object)e));
        }
    }

    @Override
    public int read(byte[] buff, int offset) throws DriverException {
        try {
            int leng = 0;
            int count = this.ftdi.getQueueStatus();
            if (count == 0) {
                leng = this.ftdi.read(buff, offset, 1);
                if (leng == 0) {
                    throw new DriverTimeoutException("Read timed out");
                }
                ++offset;
                count = this.ftdi.getQueueStatus();
            }
            if (offset + count > buff.length) {
                count = buff.length - offset;
            }
            if (count > 0) {
                leng += this.ftdi.read(buff, offset, count);
            }
            return leng;
        }
        catch (FtdiException e) {
            throw new DriverException((Throwable)((Object)e));
        }
    }

    @Override
    public void flush() throws DriverException {
        try {
            int count = this.ftdi.getQueueStatus();
            if (count > 0) {
                byte[] buff = new byte[count];
                this.ftdi.read(buff, 0, count);
            }
        }
        catch (FtdiException e) {
            throw new DriverException((Throwable)((Object)e));
        }
    }

    @Override
    public void setTimeout(int timeout) throws DriverException {
        try {
            this.ftdi.setTimeouts(timeout, 0);
        }
        catch (FtdiException e) {
            throw new DriverException((Throwable)((Object)e));
        }
    }
}

