/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.Util;

public class BootstrapParser
extends BasicParser {
    protected void processOption(String arg, ListIterator iter) throws ParseException {
        boolean hasOption = this.getOptions().hasOption(arg);
        if (!hasOption) {
            this.cmd.addArg(arg);
            return;
        }
        Option opt = (Option)this.getOptions().getOption(arg).clone();
        this.updateRequiredOptions(opt);
        if (opt.hasArg()) {
            this.processArgs(opt, iter);
        }
        this.cmd.addOption(opt);
    }

    private void updateRequiredOptions(Option opt) throws ParseException {
        if (opt.isRequired()) {
            this.getRequiredOptions().remove(opt.getKey());
        }
        if (this.getOptions().getOptionGroup(opt) != null) {
            OptionGroup group = this.getOptions().getOptionGroup(opt);
            if (group.isRequired()) {
                this.getRequiredOptions().remove(group);
            }
            group.setSelected(opt);
        }
    }

    public void processArgs(Option opt, ListIterator iter) throws ParseException {
        while (iter.hasNext()) {
            String str = (String)iter.next();
            if (this.getOptions().hasOption(str) && str.startsWith("-")) {
                iter.previous();
                break;
            }
            try {
                opt.addValueForProcessing(Util.stripLeadingAndTrailingQuotes((String)str));
            }
            catch (RuntimeException runtimeException) {
                iter.previous();
                break;
            }
        }
        if (opt.getValues() == null && !opt.hasOptionalArg()) {
            throw new MissingArgumentException(opt);
        }
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties, boolean stopAtNonOption) throws ParseException {
        for (Object opt : options.helpOptions()) {
            ((Option)opt).clearValues();
        }
        for (Object group : options.getOptionGroups()) {
            ((OptionGroup)group).setSelected(null);
        }
        this.setOptions(options);
        this.cmd = new CommandLine();
        if (arguments == null) {
            arguments = new String[]{};
        }
        List<String> tokenList = Arrays.asList(this.flatten(this.getOptions(), arguments, stopAtNonOption));
        ListIterator<String> iterator = tokenList.listIterator();
        while (iterator.hasNext()) {
            String t = iterator.next();
            if ("--".equals(t)) continue;
            if ("-".equals(t)) {
                if (stopAtNonOption) continue;
                this.cmd.addArg(t);
                continue;
            }
            if (t.startsWith("-")) {
                if (stopAtNonOption && !this.getOptions().hasOption(t)) {
                    this.cmd.addArg(t);
                    continue;
                }
                this.processOption(t, iterator);
                continue;
            }
            this.cmd.addArg(t);
            if (!stopAtNonOption) continue;
        }
        this.processProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }
}

