/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class TestScpi {
    protected Scpi scpi = new Scpi();

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        this.scpi.open(type.getValue(), ident, param);
    }

    @Command(name="close", description="Close connection to device")
    public void close() throws DriverException {
        this.scpi.close();
    }

    @Command(name="write", description="Write command to device")
    public void write(@Argument(name="command", description="Command to write") String command) throws DriverException {
        this.scpi.write(command);
    }

    @Command(name="read", description="Read response from device")
    public String read() throws DriverException {
        return this.scpi.read();
    }

    @Command(name="read", description="Write command and read response")
    public String read(@Argument(name="command", description="Command to write") String command) throws DriverException {
        return this.scpi.read(command);
    }

    @Command(name="writecommand", description="Write command")
    public void writeCommand(@Argument(name="command", description="Command to write") String command) throws DriverException {
        this.scpi.writeCommand(command);
    }

    @Command(name="readstring", description="Write command and read string response")
    public String readString(@Argument(name="command", description="Command to write") String command) throws DriverException {
        return this.scpi.readString(command);
    }

    @Command(name="readinteger", description="Write command and read integer response")
    public int readInteger(@Argument(name="command", description="Command to write") String command) throws DriverException {
        return this.scpi.readInteger(command);
    }

    @Command(name="readdouble", description="Write command and read double response")
    public double readDouble(@Argument(name="command", description="Command to write") String command) throws DriverException {
        return this.scpi.readDouble(command);
    }

    @Command(name="readfloat", description="Write command and read float response")
    public float readFloat(@Argument(name="command", description="Command to write") String command) throws DriverException {
        return this.scpi.readFloat(command);
    }

    @Command(name="timeout", description="Set read response timeout")
    public void timeout(@Argument(name="time", description="Timeout value (sec)") double time) throws DriverException {
        this.scpi.setTimeout(time);
    }

    @Command(name="setterm", description="Set command terminator")
    public void setTerm(@Argument(name="term", description="Terminator string") String term) throws DriverException {
        char[] cTerm = new char[term.length()];
        term.getChars(0, cTerm.length, cTerm, 0);
        int jout = 0;
        int jin = 0;
        while (jin < cTerm.length) {
            if (cTerm[jin] == '\\' && jin < cTerm.length - 1) {
                switch (cTerm[++jin]) {
                    case 'r': {
                        cTerm[jin] = 13;
                        break;
                    }
                    case 'n': {
                        cTerm[jin] = 10;
                        break;
                    }
                    case 't': {
                        cTerm[jin] = 9;
                        break;
                    }
                    case 'b': {
                        cTerm[jin] = 8;
                        break;
                    }
                    case 'f': {
                        cTerm[jin] = 12;
                    }
                }
            }
            cTerm[jout++] = cTerm[jin];
            ++jin;
        }
        this.scpi.setTerminator(new String(cTerm, 0, jout));
    }

    @Command(name="clear", description="Clear saved status")
    public void clear() throws DriverException {
        this.scpi.clearStatus();
    }

    @Command(name="reset", description="Reset to power-on state")
    public void reset() throws DriverException {
        this.scpi.reset();
    }

    @Command(name="enableopc", description="Enable operation complete reporting")
    public void enableOpc() throws DriverException {
        this.scpi.enableOperationComplete();
    }

    @Command(name="setese", description="Set event status enable register")
    public void setEse(@Argument(name="value", description="Value to set") int value) throws DriverException {
        this.scpi.setEventStatusEnable(value);
    }

    @Command(name="setsre", description="Set service request enable register")
    public void setSre(@Argument(name="value", description="Value to set") int value) throws DriverException {
        this.scpi.setServiceRequestEnable(value);
    }

    @Command(name="wait", description="Wait for previous command completion")
    public void waitComp() throws DriverException {
        this.scpi.waitCompletion();
    }

    @Command(name="showesr", description="Display the event status register")
    public String showEsr() throws DriverException {
        return String.format("0x%02x", this.scpi.getEventStatus());
    }

    @Command(name="showese", description="Display the event status enable register")
    public String showEse() throws DriverException {
        return String.format("0x%02x", this.scpi.getEventStatusEnable());
    }

    @Command(name="showopc", description="Display the operation complete state")
    public int showOpc() throws DriverException {
        return this.scpi.getOperationComplete();
    }

    @Command(name="showsre", description="Display the service request enable register")
    public String showSre() throws DriverException {
        return String.format("0x%02x", this.scpi.getServiceRequestEnable());
    }

    @Command(name="showstatus", description="Display the status byte")
    public String showStatus() throws DriverException {
        return String.format("0x%02x", this.scpi.getStatusByte());
    }

    @Command(name="selftest", description="Run the self test")
    public int selfTest() throws DriverException {
        return this.scpi.runSelfTest();
    }

    @Command(name="showerror", description="Display the first error item")
    public String showError() throws DriverException {
        return this.scpi.getError();
    }

    @Command(name="showident", description="Show SCPI device identification")
    public String showIdentification() throws DriverException {
        String[] id = this.scpi.getIdentification();
        return "Manufacturer:   " + id[0] + "\nModel name:     " + id[1] + "\nSerial number:  " + id[2] + "\nF/W version:    " + id[3];
    }

    public static enum ConnType {
        NET(0),
        FTDI(1),
        SERIAL(2);

        int value;

        private ConnType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

