/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.scpi.ScpiComm;

public class ScpiCommSerial
implements ScpiComm {
    private SerialPort port;
    private int timeout;

    @Override
    public void open(String device, int parm) throws DriverException {
        try {
            this.port = new SerialPort(device);
            this.port.openPort();
            this.port.setParams(parm, 8, 1, 0);
        }
        catch (SerialPortException e) {
            throw new DriverException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() throws DriverException {
        try {
            this.port.closePort();
        }
        catch (SerialPortException e) {
            throw new DriverException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] command) throws DriverException {
        try {
            this.port.writeBytes(command);
        }
        catch (SerialPortException e) {
            throw new DriverException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int read(byte[] buff, int offset) throws DriverException {
        try {
            byte[] data;
            int leng = 0;
            int count = this.port.getInputBufferBytesCount();
            if (count == 0) {
                data = this.timeout > 0 ? this.port.readBytes(1, this.timeout) : this.port.readBytes(1);
                buff[offset++] = data[0];
                leng = 1;
                count = this.port.getInputBufferBytesCount();
            }
            if (offset + count > buff.length) {
                count = buff.length - offset;
            }
            if (count > 0) {
                data = this.port.readBytes(count);
                System.arraycopy(data, 0, buff, offset, count);
                leng += count;
            }
            return leng;
        }
        catch (SerialPortTimeoutException serialPortTimeoutException) {
            throw new DriverTimeoutException("Read timed out");
        }
        catch (SerialPortException e) {
            throw new DriverException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }
}

