package org.lsst.ccs.drivers.scpi;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *****************************************************************************
 **
 **  Communications interface for SCPI devices.
 **
 **  @author Owen Saxton
 **
 *****************************************************************************
 */

public interface ScpiComm {

    public void open(String ident, int parm) throws DriverException;

    public void close() throws DriverException;

    public void write(byte[] data) throws DriverException;

    public int read(byte[] data, int offset) throws DriverException;

    public void setTimeout(int timeout) throws DriverException;

}
