/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import java.io.OutputStream;
import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class TalkScpi {
    private static final PrintStream out = System.out;
    private static final String[] terms = new String[]{"\r\n", "\r", "\n"};
    private final Thread readW = new Thread(new Reader());
    private Scpi scpi = new Scpi();
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open;

    public static void main(String[] args) {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
            new TalkScpi().run(optns);
        }
        catch (CmdLineException e) {
            out.println(e.getMessage());
            System.err.println("Usage: TalkScpi [options...] <ident> <parm>");
            parser.printUsage((OutputStream)System.err);
        }
        catch (Exception e) {
            out.println(e);
        }
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        String line;
        this.scpi.open(optns.type.getValue(), optns.ident, optns.parm);
        this.open = true;
        this.scpi.setTimeout(optns.timeout);
        this.scpi.setTerminator(terms[optns.term.ordinal()]);
        this.readW.setDaemon(true);
        this.readW.start();
        ConsoleReader readC = new ConsoleReader();
        while ((line = readC.readLine("")) != null) {
            if (line.equals("")) {
                out.format("#reads: %s; #bytes: %s; #timeouts: %s %n", this.nRead, this.nByte, this.nTimeout);
                continue;
            }
            this.scpi.write(line);
        }
        this.open = false;
        this.scpi.close();
    }

    private static enum ConnType {
        NET(0),
        FTDI(1),
        SERIAL(2);

        int value;

        private ConnType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class Options {
        @Option(name="-c", metaVar="<connType>", usage="connection type: NET (default), FTDI or SERIAL")
        private ConnType type = ConnType.NET;
        @Option(name="-r", metaVar="<timeout>", usage="read timeout (ms) (default = 0)")
        private int timeout = 0;
        @Option(name="-t", metaVar="<term>", usage="command terminator: CRLF (default), CR or LF")
        private Terminator term = Terminator.CRLF;
        @Argument(index=0, required=true, metaVar="<ident>", usage="device identifier (node, serial or device)")
        private String ident;
        @Argument(index=1, required=true, metaVar="<parm>", usage="device parameter (port number or baud rate)")
        private int parm;

        private Options() {
        }
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            while (TalkScpi.this.open) {
                try {
                    String reply = TalkScpi.this.scpi.read();
                    out.println(reply);
                    TalkScpi talkScpi = TalkScpi.this;
                    talkScpi.nRead = talkScpi.nRead + 1;
                    TalkScpi talkScpi2 = TalkScpi.this;
                    talkScpi2.nByte = talkScpi2.nByte + reply.length();
                }
                catch (DriverTimeoutException driverTimeoutException) {
                    TalkScpi talkScpi = TalkScpi.this;
                    talkScpi.nTimeout = talkScpi.nTimeout + 1;
                }
                catch (DriverException e) {
                    if (!TalkScpi.this.open) continue;
                    out.println((Object)e);
                    System.exit(0);
                }
            }
        }
    }

    private static enum Terminator {
        CRLF,
        CR,
        LF;

    }
}

