/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.scpi.ScpiComm;
import org.lsst.ccs.drivers.scpi.ScpiCommFtdi;
import org.lsst.ccs.drivers.scpi.ScpiCommNet;
import org.lsst.ccs.drivers.scpi.ScpiCommSerial;

public class Scpi {
    public static final int CONN_TYPE_NETWORK = 0;
    public static final int CONN_TYPE_FTDI = 1;
    public static final int CONN_TYPE_SERIAL = 2;
    public static final int IDENT_MANUFACTURER = 0;
    public static final int IDENT_MODEL_NAME = 1;
    public static final int IDENT_SERIAL_NUMBER = 2;
    public static final int IDENT_FW_VERSION = 3;
    public static final int CHECK_EQUALS = 0;
    public static final int CHECK_STARTS_WITH = 1;
    public static final int CHECK_ENDS_WITH = 2;
    public static final int CHECK_CONTAINS = 3;
    public static final int CHECK_MATCHES = 4;
    public static final int SB_ERROR_QUEUE = 4;
    public static final int SB_QUESTIONABLE_STATUS = 8;
    public static final int SB_MESSAGE_AVAILABLE = 16;
    public static final int SB_EVENT_STATUS = 32;
    public static final int SB_MASTER_STATUS = 64;
    public static final int SB_OPERATION_STATUS = 128;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private ScpiComm comm;
    private String terminator = "\r\n";
    private int timeout = 1000;
    private byte[] buff = new byte[1024];
    private int buffIn;
    private int buffOut;

    public void open(int type, String ident, int parm) throws DriverException {
        ScpiComm newComm;
        if (this.comm != null) {
            throw new DriverException("Device already connected");
        }
        switch (type) {
            case 0: {
                newComm = new ScpiCommNet();
                break;
            }
            case 1: {
                newComm = new ScpiCommFtdi();
                break;
            }
            case 2: {
                newComm = new ScpiCommSerial();
                break;
            }
            default: {
                throw new DriverException("Invalid connection type: " + type);
            }
        }
        newComm.open(ident, parm);
        this.comm = newComm;
        this.comm.setTimeout(this.timeout);
    }

    public void close() throws DriverException {
        this.checkOpen();
        try {
            this.comm.close();
        }
        finally {
            this.comm = null;
            this.buffOut = 0;
            this.buffIn = 0;
        }
    }

    public boolean closeSilent() {
        try {
            this.close();
            return true;
        }
        catch (DriverException driverException) {
            return false;
        }
    }

    public synchronized void write(String command) throws DriverException {
        this.checkOpen();
        this.comm.write((String.valueOf(command) + this.terminator).getBytes());
    }

    public synchronized String read() throws DriverException {
        this.checkOpen();
        try {
            int start = this.buffOut;
            int end = this.buffIn;
            int term = -1;
            while (true) {
                int j = start;
                while (j < end) {
                    if (this.buff[j] == 13 || this.buff[j] == 10) {
                        if (j == this.buffOut) {
                            ++this.buffOut;
                        } else {
                            term = j;
                            break;
                        }
                    }
                    ++j;
                }
                if (term >= 0) {
                    String resp = new String(this.buff, this.buffOut, term - this.buffOut);
                    this.buffOut = term + 1;
                    return resp;
                }
                if (this.buffOut > 0) {
                    System.arraycopy(this.buff, this.buffOut, this.buff, 0, this.buffIn - this.buffOut);
                    this.buffIn -= this.buffOut;
                    this.buffOut = 0;
                }
                if (this.buffIn >= this.buff.length) {
                    throw new DriverException("Input buffer overflow");
                }
                start = this.buffIn;
                this.buffIn += this.comm.read(this.buff, this.buffIn);
                end = this.buffIn;
            }
        }
        catch (DriverTimeoutException re) {
            throw re;
        }
        catch (DriverException re) {
            this.closeSilent();
            throw re;
        }
    }

    public synchronized String read(String command) throws DriverException {
        this.write(command);
        return this.read();
    }

    public synchronized void writeCommand(String command) throws DriverException {
        this.write("*CLS;" + command);
        this.checkError();
    }

    public synchronized String readString(String command) throws DriverException {
        try {
            return this.read("*CLS;" + command);
        }
        catch (DriverTimeoutException e) {
            this.checkError();
            throw e;
        }
    }

    public String[] readStringArray(String command) throws DriverException {
        return this.readString("*CLS;" + command).split(",");
    }

    public int readInteger(String command) throws DriverException {
        try {
            return Integer.decode(this.readString(command));
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public int[] readIntegerArray(String command) throws DriverException {
        try {
            String[] reply = this.readStringArray(command);
            int[] iReply = new int[reply.length];
            int j = 0;
            while (j < iReply.length) {
                iReply[j] = Integer.decode(reply[j]);
                ++j;
            }
            return iReply;
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public double readDouble(String command) throws DriverException {
        try {
            return Double.valueOf(this.readString(command));
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public double[] readDoubleArray(String command) throws DriverException {
        try {
            String[] reply = this.readStringArray(command);
            double[] dReply = new double[reply.length];
            int j = 0;
            while (j < dReply.length) {
                dReply[j] = Double.valueOf(reply[j]);
                ++j;
            }
            return dReply;
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public float readFloat(String command) throws DriverException {
        try {
            return Float.valueOf(this.readString(command)).floatValue();
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public float[] readFloatArray(String command) throws DriverException {
        try {
            String[] reply = this.readStringArray(command);
            float[] fReply = new float[reply.length];
            int j = 0;
            while (j < fReply.length) {
                fReply[j] = Float.valueOf(reply[j]).floatValue();
                ++j;
            }
            return fReply;
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    public void setTerminator(String term) {
        this.terminator = term;
    }

    public void setTimeout(double time) throws DriverException {
        this.timeout = (int)(1000.0 * time);
        if (this.comm != null) {
            this.comm.setTimeout(this.timeout);
        }
    }

    public boolean testIdentification(String manufact, int manCheck, String model, int modCheck) throws DriverException {
        String[] id = this.getIdentification();
        return Scpi.checkString(id[0], manufact, manCheck) && Scpi.checkString(id[1], model, modCheck);
    }

    public void checkIdentification(String manufact, int manCheck, String model, int modCheck) throws DriverException {
        String[] id = this.getIdentification();
        if (!Scpi.checkString(id[0], manufact, manCheck) || !Scpi.checkString(id[1], model, modCheck)) {
            this.closeSilent();
            throw new DriverException("Wrong device: " + id[0] + ":" + id[1]);
        }
    }

    public void clearStatus() throws DriverException {
        this.write("*CLS");
    }

    public void setEventStatusEnable(int value) throws DriverException {
        this.write("*ESE " + value);
    }

    public int getEventStatusEnable() throws DriverException {
        return this.readInt("*ESE?");
    }

    public int getEventStatus() throws DriverException {
        return this.readInt("*ESR?");
    }

    public String[] getIdentification() throws DriverException {
        int ID_LENG = 4;
        String[] ident = this.readStringArray("*IDN?");
        if (ident.length == ID_LENG) {
            return ident;
        }
        String[] idCopy = new String[ID_LENG];
        int j = 0;
        while (j < ID_LENG) {
            idCopy[j] = j < ident.length ? ident[j] : "";
            ++j;
        }
        return idCopy;
    }

    public void enableOperationComplete() throws DriverException {
        this.write("*OPC");
    }

    public int getOperationComplete() throws DriverException {
        return this.readInt("*OPC?");
    }

    public void reset() throws DriverException {
        this.write("*RST");
    }

    public void setServiceRequestEnable(int value) throws DriverException {
        this.write("*SRE " + value);
    }

    public int getServiceRequestEnable() throws DriverException {
        return this.readInt("*SRE?");
    }

    public int getStatusByte() throws DriverException {
        return this.readInt("*STB?");
    }

    public int runSelfTest() throws DriverException {
        return this.readInt("*TST?");
    }

    public void waitCompletion() throws DriverException {
        this.write("*WAI");
    }

    public String getError() throws DriverException {
        return this.read("SYST:ERR?");
    }

    public String makeChannelList(int chan) {
        return " (@" + chan + ")";
    }

    public String makeChannelList(int[] chan) {
        if (chan.length == 0) {
            return "";
        }
        StringBuilder list = new StringBuilder(" (@" + chan[0]);
        int j = 1;
        while (j < chan.length) {
            list.append(",").append(chan[j]);
            ++j;
        }
        list.append(")");
        return list.toString();
    }

    private void checkOpen() throws DriverException {
        if (this.comm == null) {
            throw new DriverException("Device not connected");
        }
    }

    private int readInt(String command) throws DriverException {
        try {
            return Integer.decode(this.read(command));
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void checkError() throws DriverException {
        try {
            if ((this.getStatusByte() & 4) == 0) {
                return;
            }
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
        throw new DriverException("SCPI error: " + this.getError());
    }

    private static boolean checkString(String string1, String string2, int type) {
        if (string1 == null) {
            return true;
        }
        switch (type) {
            case 0: {
                return string1.equals(string2);
            }
            case 1: {
                return string1.startsWith(string2);
            }
            case 2: {
                return string1.endsWith(string2);
            }
            case 3: {
                return string1.indexOf(string2) >= 0;
            }
            case 4: {
                return string1.matches(string2);
            }
        }
        return string1.equals(string2);
    }
}

