/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap.resources;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourcesTreeProperties
extends Properties {
    private String resourceDirectory;
    private String propertyFileName;
    private Properties parent;
    private static final String envVar_str_pattern = ".*(\\$\\[env\\.(.*)\\]).*";
    private static final Pattern envVar_pattern = Pattern.compile(".*(\\$\\[env\\.(.*)\\]).*");

    public ResourcesTreeProperties(String propertyFileName, String resourceDirectory, Properties parent) {
        super(parent);
        this.resourceDirectory = resourceDirectory;
        this.propertyFileName = propertyFileName;
        this.parent = parent;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public String getPropertyFileName() {
        return this.propertyFileName;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Properties getParent() {
        return this.parent;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String valueStr = (String)value;
        Matcher m = envVar_pattern.matcher(valueStr);
        if (m.matches()) {
            String envVarValue = System.getenv(m.group(2));
            if (envVarValue != null) {
                valueStr = valueStr.replace(m.group(1), envVarValue);
            } else {
                System.out.println("[WARNING] Environment variable " + m.group(2) + " is not defined.");
            }
        }
        return super.put(key, valueStr);
    }

    public void copyProperties(Properties props) {
        if (this.parent != null) {
            if (this.parent instanceof ResourcesTreeProperties) {
                ((ResourcesTreeProperties)this.parent).copyProperties(props);
            } else {
                for (Object key : this.parent.keySet()) {
                    props.put(key, this.parent.get(key));
                }
            }
        }
        for (Object key : this.keySet()) {
            props.put(key, this.get(key));
        }
    }
}

