/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;

public abstract class BootstrapUtils {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String DISTRIBUTION_JARS_DIRECTORY = "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_RESOURCES_DIRECTORY = "etc" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_LIB_DIRECTORY = "lib" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_JNI_DIRECTORY = String.valueOf(DISTRIBUTION_LIB_DIRECTORY) + "jni" + FILE_SEPARATOR;
    static final String APPLICATION_MAINJAR_PROPERTY = "org.lsst.ccs.application.mainJar";
    private static final String TRANSPORT_DEFINITION_PROPERTY = "lsst.ccs.transport";
    private static List<String> listOfApplications = null;
    private static List<String> listOfTransports = null;
    static final String CCS_RESOURCE_PATH_ENV_VAR = "CCS_RESOURCE_PATH";
    private static String ccsDistributionRootDirectory = null;
    private static ResourcesTree resourcesTree = null;

    public static ResourcesTree getBootstrapResourcesTree() {
        if (resourcesTree == null) {
            resourcesTree = new ResourcesTree();
            List<String> resourceDirectories = BootstrapUtils.getOrderedListOfResourceDirectories();
            for (String resourceDirectory : resourceDirectories) {
                resourcesTree.addResourceDirectory(resourceDirectory);
            }
        }
        return resourcesTree;
    }

    static List<String> getOrderedListOfResourceDirectories() {
        String userProvidedResourceDirs = System.getenv(CCS_RESOURCE_PATH_ENV_VAR);
        return BootstrapUtils.getOrderedListOfResourceDirectories(userProvidedResourceDirs, true);
    }

    public static List<String> getOrderedListOfResourceDirectories(String userProvidedResourceDirs, boolean checkExistance) {
        String resourceDirectories = BootstrapUtils.getDistributionResourcesDirectory();
        if (userProvidedResourceDirs != null && !userProvidedResourceDirs.equals("")) {
            resourceDirectories = String.valueOf(userProvidedResourceDirs) + PATH_SEPARATOR + resourceDirectories;
        }
        ArrayList<String> orderedListOfResourceDirectories = new ArrayList<String>();
        StringTokenizer dirsToken = new StringTokenizer(resourceDirectories, ":;");
        while (dirsToken.hasMoreTokens()) {
            String resourceDir = dirsToken.nextToken().trim();
            if (!resourceDir.endsWith(FILE_SEPARATOR)) {
                resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
            }
            Path p = Paths.get(BootstrapUtils.getCCSDistributionRootDirectory(), new String[0]);
            resourceDir = resourceDir.replace("~", System.getProperty("user.home"));
            if (!(resourceDir = p.resolve(resourceDir).normalize().toString()).endsWith(FILE_SEPARATOR)) {
                resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
            }
            File dir = new File(resourceDir);
            if (checkExistance && !dir.exists()) continue;
            orderedListOfResourceDirectories.add(resourceDir);
        }
        return orderedListOfResourceDirectories;
    }

    static String getDistributionResourcesDirectory() {
        return BootstrapUtils.getDistributionResourcesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionResourcesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_RESOURCES_DIRECTORY;
    }

    static String getDistributionLibDirectory() {
        return BootstrapUtils.getDistributionLibDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionLibDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_LIB_DIRECTORY;
    }

    static String getDistributionJniDirectory() {
        return BootstrapUtils.getDistributionJniDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJniDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JNI_DIRECTORY;
    }

    static String getDistributionJarFilesDirectory() {
        return BootstrapUtils.getDistributionJarFilesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJarFilesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JARS_DIRECTORY;
    }

    public static String getCCSDistributionRootDirectory() {
        if (ccsDistributionRootDirectory == null) {
            ccsDistributionRootDirectory = BootstrapUtils.getCCSDistributionRootDirectory(BootstrapUtils.class);
        }
        return ccsDistributionRootDirectory;
    }

    static String getCCSDistributionRootDirectory(Class clazz) {
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        String sourceCodeLocation = location.getFile();
        if (sourceCodeLocation.endsWith(".jar")) {
            ccsDistributionRootDirectory = sourceCodeLocation.substring(0, sourceCodeLocation.lastIndexOf(FILE_SEPARATOR) + 1);
        } else if (sourceCodeLocation.endsWith(FILE_SEPARATOR)) {
            ccsDistributionRootDirectory = sourceCodeLocation;
        } else {
            throw new RuntimeException("Could not process souce code location " + sourceCodeLocation + " It is neither a directory nor a jar file.");
        }
        if (ccsDistributionRootDirectory.endsWith(DISTRIBUTION_JARS_DIRECTORY)) {
            ccsDistributionRootDirectory = ccsDistributionRootDirectory.replace(DISTRIBUTION_JARS_DIRECTORY, "");
        }
        return ccsDistributionRootDirectory;
    }

    public static List<String> getBootstrapListOfApplications() {
        if (listOfApplications == null) {
            listOfApplications = new ArrayList<String>();
            List<String> allPropertiesInResources = ResourcesUtils.getResourcesInResourcesTreeByExtension(BootstrapUtils.getBootstrapResourcesTree(), "properties");
            for (String propertyFile : allPropertiesInResources) {
                Properties props = ResourcesUtils.getMergedPropertyFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                String mainJar = props.getProperty(APPLICATION_MAINJAR_PROPERTY);
                if (mainJar == null || mainJar.isEmpty()) continue;
                listOfApplications.add(propertyFile.replace(".properties", ""));
            }
        }
        return listOfApplications;
    }

    static List<String> getBootstrapListOfTransports() {
        if (listOfTransports == null) {
            listOfTransports = new ArrayList<String>();
            List<String> allPropertiesInResources = ResourcesUtils.getResourcesInResourcesTreeByExtension(BootstrapUtils.getBootstrapResourcesTree(), "properties");
            for (String propertyFile : allPropertiesInResources) {
                Properties props = ResourcesUtils.getMergedPropertyFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                String transportProperty = props.getProperty(TRANSPORT_DEFINITION_PROPERTY);
                if (transportProperty == null) continue;
                listOfTransports.add(propertyFile.replace(".properties", ""));
            }
        }
        return listOfTransports;
    }

    static Properties getPropertiesForTransport(String transport) {
        return BootstrapResourceUtils.getBootstrapProperties(transport, false);
    }

    static Properties getApplicationDefinitionProperties(String application) {
        return BootstrapResourceUtils.getBootstrapProperties(application, false);
    }

    static String getBootstrapLibraryPath() {
        String libraryPath = String.valueOf(BootstrapUtils.getDistributionJniDirectory()) + File.pathSeparator + BootstrapUtils.getDistributionLibDirectory();
        String existingLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (existingLibraryPath != null && !existingLibraryPath.isEmpty()) {
            libraryPath = String.valueOf(libraryPath) + File.pathSeparator + existingLibraryPath;
        }
        return libraryPath;
    }
}

