/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rotator;

import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.rotator.Position;
import org.lsst.ccs.drivers.rotator.PositionEvent;
import org.lsst.ccs.drivers.rotator.PositionListener;
import org.lsst.ccs.drivers.rotator.RotatorInterface;
import org.lsst.ccs.drivers.rotator.RotatorState;
import org.lsst.ccs.drivers.rotator.RotatorStateChangeListener;
import org.lsst.ccs.drivers.rotator.RotatorStateChangedEvent;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALTelemetry;
import org.lsst.sal.rotator.SALRotator;
import org.lsst.sal.rotator.command.ClearErrorCommand;
import org.lsst.sal.rotator.command.ConfigureAccelerationCommand;
import org.lsst.sal.rotator.command.ConfigureVelocityCommand;
import org.lsst.sal.rotator.command.DisableCommand;
import org.lsst.sal.rotator.command.EnableCommand;
import org.lsst.sal.rotator.command.EnterControlCommand;
import org.lsst.sal.rotator.command.ExitControlCommand;
import org.lsst.sal.rotator.command.MoveCommand;
import org.lsst.sal.rotator.command.PositionSetCommand;
import org.lsst.sal.rotator.command.StandbyCommand;
import org.lsst.sal.rotator.command.StartCommand;
import org.lsst.sal.rotator.command.StopCommand;
import org.lsst.sal.rotator.event.ControllerStateEvent;
import org.lsst.sal.rotator.event.HeartbeatEvent;
import org.lsst.sal.rotator.event.SummaryStateEvent;
import org.lsst.sal.rotator.telemetry.ApplicationTelemetry;

public class RotatorDriver
implements RotatorInterface,
AutoCloseable {
    private final SALRotator mgr = SALRotator.create();
    private static final Logger LOG = Logger.getLogger(RotatorDriver.class.getName());
    private final Future<Void> eventListener;
    private final Future<Object> telemetryListener;
    private final BlockingDeque<Object> eventQueue = new LinkedBlockingDeque<Object>();
    private final Future<?> eventDelivery;
    private final List<PositionListener> positionListeners = new CopyOnWriteArrayList<PositionListener>();
    private final List<RotatorStateChangeListener> stateListeners = new CopyOnWriteArrayList<RotatorStateChangeListener>();
    private volatile long lastHeartbeat;
    private volatile SummaryStateEvent.SummaryState summaryState;
    private volatile RotatorState rotatorState;
    private volatile Position position;

    public RotatorDriver() {
        this(Executors.newFixedThreadPool(4));
    }

    public RotatorDriver(ExecutorService executor) {
        this.eventListener = executor.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    SALEvent event = this.mgr.getNextEvent(Duration.ofMinutes(1L));
                    LOG.log(Level.FINE, "Received {0}", event);
                    if (event == null) {
                        LOG.info("Still waiting for an event");
                        continue;
                    }
                    if (event instanceof HeartbeatEvent) {
                        HeartbeatEvent beat = (HeartbeatEvent)event;
                        this.lastHeartbeat = System.currentTimeMillis();
                        continue;
                    }
                    if (event instanceof SummaryStateEvent) {
                        SummaryStateEvent sse = (SummaryStateEvent)event;
                        this.summaryState = this.convertEnum(sse.getSummaryState() - 1, SummaryStateEvent.SummaryState.class);
                        continue;
                    }
                    if (event instanceof ControllerStateEvent) {
                        ControllerStateEvent cse = (ControllerStateEvent)event;
                        this.rotatorState = new RotatorState(this.convertEnum(cse.getControllerState(), RotatorState.RotatorSummaryState.class), this.convertEnum(cse.getOfflineSubstate(), RotatorState.OfflineState.class), this.convertEnum(cse.getEnabledSubstate(), RotatorState.EnabledState.class), cse.getApplicationStatus());
                        this.eventQueue.offer(new RotatorStateChangedEvent(this.rotatorState));
                        continue;
                    }
                    LOG.log(Level.FINE, "Received unhandled {0}", event);
                }
                catch (Throwable x) {
                    LOG.log(Level.SEVERE, "Error ", x);
                }
            }
            return null;
        });
        this.telemetryListener = executor.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    SALTelemetry telemetry = this.mgr.getTelemetry(Duration.ofMinutes(1L));
                    LOG.log(Level.FINE, "Received {0}", telemetry);
                    if (telemetry == null) {
                        LOG.info("Still waiting for telemetry");
                        continue;
                    }
                    if (telemetry instanceof ApplicationTelemetry) {
                        ApplicationTelemetry at = (ApplicationTelemetry)telemetry;
                        Position newPosition = new Position(at.getDemand(), at.getPosition(), at.getError());
                        if (!newPosition.isSignificantlyDifferent(this.position)) continue;
                        this.position = newPosition;
                        PositionEvent pe = new PositionEvent(this.position);
                        this.eventQueue.offer(pe);
                        continue;
                    }
                    LOG.log(Level.FINE, "Received unhandled {0}", telemetry);
                }
                catch (Throwable x) {
                    LOG.log(Level.SEVERE, "Error ", x);
                }
            }
            return null;
        });
        this.eventDelivery = executor.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Object event = this.eventQueue.take();
                    if (event instanceof PositionEvent) {
                        this.deliverPositionEvent((PositionEvent)event);
                        continue;
                    }
                    if (!(event instanceof RotatorStateChangedEvent)) continue;
                    this.deliverStateChangedEvent((RotatorStateChangedEvent)event);
                }
                catch (Throwable x) {
                    LOG.log(Level.SEVERE, "Error ", x);
                }
            }
            return null;
        });
    }

    @Override
    public void close() throws DriverException {
        try {
            this.eventListener.cancel(true);
            this.telemetryListener.cancel(true);
            this.eventDelivery.cancel(false);
            this.mgr.close();
        }
        catch (SALException ex) {
            throw new DriverException("Error during close", (Throwable)ex);
        }
    }

    @Override
    public void move(double position) throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new PositionSetCommand(position));
        this.executeCommand((SALCommand)new MoveCommand(true), Duration.ofSeconds(60L));
    }

    private void executeCommand(SALCommand command) throws TimeoutException, DriverException {
        this.executeCommand(command, Duration.ofSeconds(60L));
    }

    public void enable() throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new EnableCommand());
    }

    public void disable() throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new DisableCommand());
    }

    public void standby() throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new StandbyCommand());
    }

    public void start(String config) throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new StartCommand(config));
    }

    public void enterControl() throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new EnterControlCommand());
    }

    public void exitControl() throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new ExitControlCommand());
    }

    @Override
    public void stop() throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new StopCommand(0));
    }

    @Override
    public void configureAcceleration(double aLimit) throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new ConfigureAccelerationCommand(aLimit));
    }

    @Override
    public void configureVelocity(double vLimit) throws DriverException, TimeoutException {
        this.executeCommand((SALCommand)new ConfigureVelocityCommand(vLimit));
    }

    @Override
    public void clearError() throws TimeoutException, DriverException {
        this.executeCommand((SALCommand)new ClearErrorCommand(false));
    }

    @Override
    public void addStateChangeListener(RotatorStateChangeListener stateChangeListener) {
        this.stateListeners.add(stateChangeListener);
    }

    @Override
    public void removeStateChangeListener(RotatorStateChangeListener stateChangeListener) {
        this.stateListeners.remove(stateChangeListener);
    }

    private void deliverStateChangedEvent(RotatorStateChangedEvent stateChangeEvent) {
        for (RotatorStateChangeListener l : this.stateListeners) {
            l.stateChanged(stateChangeEvent);
        }
    }

    @Override
    public void addPositionListener(PositionListener positionListener) {
        this.positionListeners.add(positionListener);
    }

    @Override
    public void removePositionListener(PositionListener positionListener) {
        this.positionListeners.remove(positionListener);
    }

    private void deliverPositionEvent(PositionEvent positionEvent) {
        for (PositionListener l : this.positionListeners) {
            l.positionChanged(positionEvent);
        }
    }

    public Date getLastHeartbeat() {
        return new Date(this.lastHeartbeat);
    }

    public SummaryStateEvent.SummaryState getSummaryState() {
        return this.summaryState;
    }

    public RotatorState getRotatorState() {
        return this.rotatorState;
    }

    public Position getPosition() {
        return this.position;
    }

    private <T extends Enum> T convertEnum(int value, Class<T> enumClass) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        if (value < 0 || value >= values.length) {
            throw new IllegalArgumentException("Invalid value " + value + " for enum " + enumClass);
        }
        return (T)values[value];
    }

    private void executeCommand(SALCommand command, Duration timeout) throws TimeoutException, DriverException {
        try {
            SALCommandResponse response = this.mgr.issueCommand(command);
            int rc = response.waitForCompletion(timeout);
            if (rc != 303) {
                throw new DriverException("Command failed rc=" + rc);
            }
        }
        catch (SALException ex) {
            throw new DriverException("Error during command execution: " + command, (Throwable)ex);
        }
    }
}

