package org.lsst.ccs.drivers.rotator;

import java.util.Date;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.sal.rotator.event.SummaryStateEvent.SummaryState;

/**
 *
 * @author tonyj
 */
public class RotatorDriverTest {
    private final RotatorDriver driver = new RotatorDriver();

    public RotatorDriverTest() {
        driver.addStateChangeListener((RotatorStateChangedEvent event) -> {
            System.out.println("StateChange: "+event.getRotatorState());
        });
        driver.addPositionListener((PositionEvent event) -> {
            System.out.println("Position: "+event.getPosition());
        });
    }
    
    @Command(name = "move", alias="mv", description = "Move to position")
    public void move(double position) throws DriverException, TimeoutException {
        driver.move(position);
    }

    @Command(name = "enable", description = "Enable")
    public void enable() throws DriverException, TimeoutException {
        driver.enable();
    }

    @Command(name = "disable", description = "Enable")
    public void disable() throws DriverException, TimeoutException {
        driver.disable();
    }

    @Command(name = "standby", description = "Standby")
    public void standby() throws DriverException, TimeoutException {
        driver.standby();
    }

    @Command(name = "start", description = "Start")
    public void start(String config) throws DriverException, TimeoutException {
        driver.start(config);
    }

    @Command(name = "enterControl", description = "EnterControl")
    public void enterControl() throws DriverException, TimeoutException {
        driver.enterControl();
    }
    
    @Command(name = "exitControl", description = "ExitControl")
    public void exitControl() throws DriverException, TimeoutException {
        driver.exitControl();
    }
    
    @Command(name = "clearError", description = "ClearError")
    public void clearError() throws DriverException, TimeoutException {
        driver.clearError();
    }    

    @Command(name = "lastHeartbeat", alias="hb", description = "Get the last heartbeat time")
    public Date lastHeartbeat() {
        return driver.getLastHeartbeat();
    }

    @Command(name = "summaryState", alias="ss", description = "Get the current summary state")
    public SummaryState summaryState() {
        return driver.getSummaryState();
    }

    @Command(name = "rotatorState", alias="rs", description = "Get the current rotator state")
    public RotatorState controllerState() {
        return driver.getRotatorState();
    }

    @Command(name = "position", alias="p", description = "Get the current position")
    public Position position() {
        return driver.getPosition();
    }
}
