package org.lsst.ccs.drivers.rotator;

import java.io.Serializable;

/**
 *
 * @author tonyj
 */
public class Position implements Serializable {

    private static final long serialVersionUID = 1L;
    private final double demand;
    private final double position;
    private final double error;

    Position(double demand, double position, double error) {
        this.demand = demand;
        this.position = position;
        this.error = error;
    }

    /**
     * Commanded rotator position.
     * @return
     */
    public double getDemand() {
        return demand;
    }

    /**
     * Actual rotator position.
     * @return
     */
    public double getPosition() {
        return position;
    }

    /**
     * Rotator following error.
     * @return
     */
    public double getError() {
        return error;
    }    

    @Override
    public String toString() {
        return "Position{" + "demand=" + demand + ", position=" + position + ", error=" + error + '}';
    }

    boolean isSignificantlyDifferent(Position that) {
        if (that == null || this.demand != that.demand) {
            return true;
        }
        return Math.abs(this.position - that.position) > 1e-5;
    }
}
