/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.rotator;

import java.io.Serializable;

public class Position
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double demand;
    private final double position;
    private final double error;

    Position(double demand, double position, double error) {
        this.demand = demand;
        this.position = position;
        this.error = error;
    }

    public double getDemand() {
        return this.demand;
    }

    public double getPosition() {
        return this.position;
    }

    public double getError() {
        return this.error;
    }

    public String toString() {
        return "Position{demand=" + this.demand + ", position=" + this.position + ", error=" + this.error + '}';
    }

    boolean isSignificantlyDifferent(Position that) {
        if (that == null || this.demand != that.demand) {
            return true;
        }
        return Math.abs(this.position - that.position) > 1.0E-5;
    }
}

