/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reflex;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reflex.BoardControl;
import org.lsst.ccs.drivers.reflex.ReflexController;

public class AD8X100Control
extends BoardControl {
    AD8X100Control(ReflexController ctl, ReflexController.BoardSlot slot) {
        super(ctl, slot);
    }

    @Override
    public ReflexController.BoardType getBoardType() {
        return ReflexController.BoardType.AD8X100;
    }

    public void setClampLow(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress, x);
    }

    public int getClampLow() throws DriverException {
        return this.ctl.readRegister(this.baseAddress);
    }

    public void setClampHigh(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 1, x);
    }

    public int getClampHigh() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 1);
    }

    public void setRawMode(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 2, x);
    }

    public int getRawMode() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 2);
    }

    public void setRawChannel(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 3, x);
    }

    public int getRawChannel() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 3);
    }

    public void setCDSGain(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 4, x);
    }

    public int getCDSGain() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 4);
    }

    public void setCDSOffset(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 5, x);
    }

    public int getCDSOffset() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 5);
    }

    public void setHDRMode(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 6, x);
    }

    public int getHDRMode() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 6);
    }

    public void setCDSResetStart(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 7, x);
    }

    public int getCDSResetStart() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 7);
    }

    public void setCDSResetStop(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 8, x);
    }

    public int getCDSResetStop() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 8);
    }

    public void setCDSVideoStart(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 9, x);
    }

    public int getCDSVideoStart() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 9);
    }

    public void setCDSVideoStop(int x) throws DriverException {
        this.ctl.writeRegister(this.baseAddress + 10, x);
    }

    public int getCDSVideoStop() throws DriverException {
        return this.ctl.readRegister(this.baseAddress + 10);
    }
}

